/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @Minimum_Percent_Type_1 decimal(05,02) = 50.00  -- minimum percent reduction for index_type 1

DECLARE @Minimum_Percent_Type_2 decimal(05,02) = 80.00  -- minimum percent reduction for index_type 2

DECLARE @Minimum_Size_GB_Type_1 decimal(19,05) =  0.500 -- minimum size GB reduction for index_type 1

DECLARE @Minimum_Size_GB_Type_2 decimal(19,05) =  0.100 -- minimum size GB reduction for index_type 2

DECLARE @GeneralSchema varchar(0128) = '%' -- enter schema name here, use LIKE wildcards as necessary

DECLARE @GeneralObject varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary

-- PRINT 'Nature PK means primary   key'
-- PRINT 'Nature AK means alternate key (unique constraint)'
-- PRINT 'Nature U  means unique'
-- PRINT 'Nature UF means unique filtered'
-- PRINT 'Nature S  means simple'
-- PRINT 'Nature SF means simple filtered'

-- PRINT CHAR(13) + CHAR(10)

-- PRINT 'table_type 0 means a table as heap'
-- PRINT 'table_type 1 means a table as clustered index'
-- PRINT 'table_type 5 means a table as clustered index (columnstore)'

-- PRINT CHAR(13) + CHAR(10)

-- PRINT 'index_type 0 means a table as heap'
-- PRINT 'index_type 1 means a table as clustered index'
-- PRINT 'index_type 5 means a table as clustered index (columnstore)'
-- PRINT 'index_type 2 means a       nonclustered index'
-- PRINT 'index_type 6 means a       nonclustered index (columnstore)'

-- PRINT CHAR(13) + CHAR(10)

   DECLARE @VirtualID               int = 0

   DECLARE @GeneralID               int
-- DECLARE @GeneralObject varchar(0128)
-- DECLARE @GeneralSchema varchar(0128)

DECLARE @SQLServerName varchar(0128)
DECLARE @SQLServerFile varchar(0128)
DECLARE @RegularColumn varchar(2000)
DECLARE @IncludeColumn varchar(2000)
DECLARE @GeneralFilter varchar(2000)

DECLARE @table_type smallint
DECLARE @index_type smallint

DECLARE @index_id        int

DECLARE @fill_factor tinyint

DECLARE @SQLCode varchar(4000)

IF OBJECT_ID('tempdb..#ZKey', 'U ') IS NOT NULL DROP TABLE #ZKey

IF OBJECT_ID('tempdb..#Hunk', 'U ') IS NOT NULL DROP TABLE #Hunk

IF OBJECT_ID('tempdb..#Hack', 'U ') IS NOT NULL DROP TABLE #Hack

IF OBJECT_ID('tempdb..#Task', 'U ') IS NOT NULL DROP TABLE #Task

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , I.is_unique
        , I.is_disabled
        , M.is_included_column
        , M.is_descending_key
        , M.partition_ordinal
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , CASE WHEN M.is_included_column  = 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY M.key_ordinal, M.index_column_id) ELSE 0 END AS regular_column_id
        , CASE WHEN M.is_included_column != 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY                M.index_column_id) ELSE 0 END AS include_column_id
        , ISNULL(I.filter_definition, SPACE(0)) AS GeneralFilter
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
     INTO #ZKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
LEFT JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
      AND S.name LIKE @GeneralSchema
      AND O.name LIKE @GeneralObject
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName
        ,   index_column_id

   SELECT T.object_id AS GeneralID
        , T.index_id
        , T.index_rows
        , T.Partitions
        , CASE WHEN T.DC_MIN  = T.DC_MAX AND T.DC_MIN = 1 THEN 'ROW'
               WHEN T.DC_MIN  = T.DC_MAX AND T.DC_MIN = 2 THEN 'PAGE'
               WHEN T.DC_MIN  = T.DC_MAX AND T.DC_MIN > 2 THEN 'COLUMNSTORE'
               WHEN T.DC_MIN != T.DC_MAX                  THEN 'MIXED TYPES' ELSE SPACE(0) END AS [Compression]
        , Z.pages_total
     INTO #Hunk
     FROM
  (SELECT I.object_id
        , I.index_id
        , SUM(P.rows)                AS index_rows
        , COUNT(*)                   AS Partitions
        , MIN(P.data_compression)    AS DC_MIN
        , MAX(P.data_compression)    AS DC_MAX
     FROM sys.schemas    AS S
     JOIN sys.objects    AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes    AS I
       ON O.object_id
        = I.object_id
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ')
      AND S.name LIKE @GeneralSchema
      AND O.name LIKE @GeneralObject
 GROUP BY I.object_id
        , I.index_id)    AS T
     JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(A.total_pages)         AS pages_total
     FROM sys.partitions AS P
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type != 0
 GROUP BY P.object_id
        , P.index_id)    AS Z
       ON T.object_id
        = Z.object_id
      AND T.index_id
        = Z.index_id
 ORDER BY T.object_id
        , T.index_id

   UPDATE Z SET table_type = CASE WHEN E.GeneralType = 'V ' THEN 0 - E.index_type ELSE E.index_type END
     FROM #ZKey AS Z
     JOIN #ZKey AS E
       ON Z.GeneralID
        = E.GeneralID
      AND E.index_type      IN (0, 1, 5)
      AND E.index_column_id IN (0, 1)

   SELECT Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
        , SUM(CASE WHEN Z.regular_column_id >  0 THEN 1 ELSE 0 END) AS KeyColumns
        , SUM(CASE WHEN Z.include_column_id >  0 THEN 1 ELSE 0 END) AS AnyColumns
        , MAX(CASE WHEN Z.regular_column_id =  1 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  2 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  3 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  4 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  5 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  6 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  7 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  8 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  9 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 10 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 11 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 12 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 13 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 14 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 15 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 16 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 17 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 18 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 19 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS RegularColumn
        , MAX(CASE WHEN Z.include_column_id =  1 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  2 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  3 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  4 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  5 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  6 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  7 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  8 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  9 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 10 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 11 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 12 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 13 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 14 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 15 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 16 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 17 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 18 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 19 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS IncludeColumn
     INTO #Hack
     FROM #ZKey AS Z
 GROUP BY Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
 ORDER BY Z.GeneralSchema
        , Z.GeneralObject
        , Z.index_id

CREATE TABLE #Task
     ( GeneralID                    int
     , GeneralSchema      varchar(0128)
     , GeneralObject      varchar(0128)
     , SQLServerName      varchar(0128)
     , index_id                     int
     , index_type              smallint
     , partition_number             int
     , entire_current_KB         bigint
     , entire_changed_KB         bigint
     , sample_current_KB         bigint
     , sample_changed_KB         bigint )

  DECLARE DBItems CURSOR FAST_FORWARD FOR
   SELECT I.GeneralID
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.table_type
        , I.index_type
        , I.index_id
        , I.fill_factor
     FROM #Hack AS I
     JOIN #Hunk AS E
       ON I.GeneralID
        = E.GeneralID
      AND I.index_id
        = E.index_id
    WHERE I.index_type IN (1, 2)
      AND E.Compression != 'PAGE'
      AND CONVERT(decimal(19,05), E.pages_total / 128.0 / 1024.0) > CASE WHEN I.index_type = 1 THEN @Minimum_Size_GB_Type_1 ELSE @Minimum_Size_GB_Type_2 END
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , I.index_type
        , I.SQLServerName

OPEN DBItems

FETCH NEXT FROM DBItems INTO @GeneralID, @GeneralSchema, @GeneralObject, @SQLServerName, @SQLServerFile, @table_type, @index_type, @index_id, @fill_factor

WHILE @@FETCH_STATUS = 0

    BEGIN

       INSERT #Task
            ( GeneralObject
            , GeneralSchema
            , index_id
            , partition_number
            , entire_current_KB
            , entire_changed_KB
            , sample_current_KB
            , sample_changed_KB)
      EXECUTE sp_estimate_data_compression_savings @GeneralSchema, @GeneralObject, @index_id, NULL, 'PAGE'

    FETCH NEXT FROM DBItems INTO @GeneralID, @GeneralSchema, @GeneralObject, @SQLServerName, @SQLServerFile, @table_type, @index_type, @index_id, @fill_factor

    END

CLOSE DBItems DEALLOCATE DBItems

/*

   UPDATE #Task SET
            GeneralID
        = I.GeneralID
        ,   SQLServerName
        = I.SQLServerName
        ,   index_type
        = I.index_type
     FROM #Task AS T
     JOIN #Hack AS I
       ON T.GeneralSchema
        = I.GeneralSchema
      AND T.GeneralObject
        = I.GeneralObject
      AND T.index_id
        = I.index_id

*/

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
        , CASE WHEN I.index_type            = 0 THEN 'S '
               WHEN I.index_type            = 5 THEN 'S '
               WHEN I.index_type            = 6 THEN 'S '
               WHEN I.is_primary_key       != 0 THEN 'PK'
               WHEN I.is_unique_constraint != 0 THEN 'AK'
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) = 0 THEN 'U '
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) > 0 THEN 'UF'
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) = 0 THEN 'S '
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) > 0 THEN 'SF' END AS Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , E.index_rows
--      , E.Partitions
        , E.Compression
--      , CONVERT(decimal(19,05), E.pages_total / 128.0 / 1024.0) AS GBs_total_size
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
        ,          CONVERT(decimal(19,05), CONVERT(decimal(19,02), (T.entire_current_KB                      )) / 1024.0 / 1024.0) AS Standard_Size_GB
        ,          CONVERT(decimal(19,05), CONVERT(decimal(19,02), (                      T.entire_changed_KB)) / 1024.0 / 1024.0) AS Compress_Size_GB
        , 100.00 - CONVERT(decimal(05,02),
                   CONVERT(decimal(19,02),                                               T.entire_changed_KB    ) * 100.0
                 / CONVERT(decimal(19,02), CASE WHEN T.entire_current_KB = 0 THEN 1 ELSE T.entire_current_KB END)                ) AS Compress_Percent
     FROM #Hack AS I
     JOIN #Hunk AS E
       ON I.GeneralID
        = E.GeneralID
      AND I.index_id
        = E.index_id
     JOIN #Task AS T
       ON I.GeneralSchema
        = T.GeneralSchema
      AND I.GeneralObject
        = T.GeneralObject
      AND I.index_id
        = T.index_id
    WHERE I.index_type IN (1, 2)
      AND E.Compression != 'PAGE'
      AND          CONVERT(decimal(19,05), CONVERT(decimal(19,02), (T.entire_current_KB - T.entire_changed_KB)) / 1024.0 / 1024.0) !< CASE WHEN I.index_type = 1 THEN @Minimum_Size_GB_Type_1 ELSE @Minimum_Size_GB_Type_2 END
      AND 100.00 - CONVERT(decimal(05,02),
                   CONVERT(decimal(19,02),                                               T.entire_changed_KB    ) * 100.0
                 / CONVERT(decimal(19,02), CASE WHEN T.entire_current_KB = 0 THEN 1 ELSE T.entire_current_KB END)                ) !< CASE WHEN I.index_type = 1 THEN @Minimum_Percent_Type_1 ELSE @Minimum_Percent_Type_2 END
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , I.index_type
        , I.SQLServerName

  DECLARE DBItems CURSOR FAST_FORWARD FOR
   SELECT I.GeneralID
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.table_type
        , I.index_type
        , I.index_id
        , I.fill_factor
     FROM #Hack AS I
     JOIN #Hunk AS E
       ON I.GeneralID
        = E.GeneralID
      AND I.index_id
        = E.index_id
     JOIN #Task AS T
       ON I.GeneralSchema
        = T.GeneralSchema
      AND I.GeneralObject
        = T.GeneralObject
      AND I.index_id
        = T.index_id
    WHERE I.index_type IN (1, 2)
      AND E.Compression != 'PAGE'
      AND          CONVERT(decimal(19,05), CONVERT(decimal(19,02), (T.entire_current_KB - T.entire_changed_KB)) / 1024.0 / 1024.0) !< CASE WHEN I.index_type = 1 THEN @Minimum_Size_GB_Type_1 ELSE @Minimum_Size_GB_Type_2 END
      AND 100.00 - CONVERT(decimal(05,02),
                   CONVERT(decimal(19,02),                                               T.entire_changed_KB    ) * 100.0
                 / CONVERT(decimal(19,02), CASE WHEN T.entire_current_KB = 0 THEN 1 ELSE T.entire_current_KB END)                ) !< CASE WHEN I.index_type = 1 THEN @Minimum_Percent_Type_1 ELSE @Minimum_Percent_Type_2 END
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , I.index_type
        , I.SQLServerName

OPEN DBItems

FETCH NEXT FROM DBItems INTO @GeneralID, @GeneralSchema, @GeneralObject, @SQLServerName, @SQLServerFile, @table_type, @index_type, @index_id, @fill_factor

WHILE @@FETCH_STATUS = 0

    BEGIN

    IF @GeneralID != @VirtualID

        BEGIN

        SET @VirtualID = @GeneralID

        SET @SQLCode = '-- ' + @GeneralSchema + '.' + @GeneralObject

        PRINT @SQLCode

        PRINT CHAR(13) + CHAR(10)

        END

    SET @SQLCode = 'ALTER INDEX [' + @SQLServerName + '] ON [' + @GeneralSchema + '].[' + @GeneralObject + ']' + CHAR(13) + CHAR(10)
                 + 'REBUILD WITH (ONLINE = OFF'
                 + CASE WHEN @index_type IN (1, 2      )                      THEN ', SORT_IN_TEMPDB = OFF'                                 ELSE SPACE(0) END
                 + CASE WHEN @index_type IN (1, 2      ) AND @fill_factor > 0 THEN ', FILLFACTOR = ' + CONVERT(varchar(0010), @fill_factor) ELSE SPACE(0) END + ', DATA_COMPRESSION = PAGE) ON [' + @SQLServerFile + ']' + CASE WHEN @index_type = 1 THEN ' -- clustered' ELSE SPACE(0) END

    PRINT @SQLCode

    PRINT CHAR(13) + CHAR(10)

--  EXECUTE (@SQLCode)

    FETCH NEXT FROM DBItems INTO @GeneralID, @GeneralSchema, @GeneralObject, @SQLServerName, @SQLServerFile, @table_type, @index_type, @index_id, @fill_factor

    END

CLOSE DBItems DEALLOCATE DBItems

DROP TABLE #ZKey

DROP TABLE #Hunk

DROP TABLE #Hack

DROP TABLE #Task

SET NOCOUNT OFF

