/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

   SELECT D.name AS [DBSource]
        , E.name AS [SNAPSHOT]
        , CONVERT(varchar(0040), E.create_date, 120) AS create_date
     FROM sys.databases AS D
     JOIN sys.databases AS E
       ON        D.database_id
        = E.source_database_id
 ORDER BY D.name
        , E.create_date

   SELECT O.type      AS GeneralType
        , SPACE(0)    AS GeneralSchema
        , O.name      AS GeneralObject
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , O.is_disabled
        , 'DDL trigger on server'   AS SQLServerName
     FROM sys.server_triggers AS O
 ORDER BY O.type
        , O.name

   SELECT O.type      AS GeneralType
        , SPACE(0)    AS GeneralSchema
        , O.name      AS GeneralObject
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , O.is_disabled
        , 'DDL trigger in database' AS SQLServerName
     FROM sys.triggers AS O
    WHERE O.parent_id = 0
 ORDER BY O.type
        , O.name

   SELECT O.type      AS GeneralType
        , S.name      AS GeneralSchema
        , O.name      AS GeneralObject
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , CASE O.type WHEN 'TA' THEN M.assembly_class COLLATE database_default + '.' + M.assembly_method COLLATE database_default
                      WHEN 'PC' THEN M.assembly_class COLLATE database_default + '.' + M.assembly_method COLLATE database_default
                      WHEN 'FS' THEN M.assembly_class COLLATE database_default + '.' + M.assembly_method COLLATE database_default
                      WHEN 'FT' THEN M.assembly_class COLLATE database_default + '.' + M.assembly_method COLLATE database_default
                      WHEN 'AF' THEN M.assembly_class COLLATE database_default + '.' + 'Aggregation' ELSE SPACE(0) END AS SQLServerCode
        , O.type_desc AS SQLServerName
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.assembly_modules AS M
       ON O.object_id
        = M.object_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('TA' ,'PC', 'FS', 'FT' ,'AF')
 ORDER BY O.type
        , S.name
        , O.name

SET NOCOUNT OFF

