/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

IF OBJECT_ID('tempdb..#TKey' , 'U ') IS NOT NULL DROP TABLE #TKey

IF OBJECT_ID('tempdb..#TKeys', 'U ') IS NOT NULL DROP TABLE #TKeys

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , CONVERT(varchar(0040), T.create_date, 120) AS create_date
        , CONVERT(varchar(0040), T.modify_date, 120) AS modify_date
--      , T.type      AS SQLServerType
        , I.type      AS table_type
--      , I.type      AS index_type
        , Z.is_track_columns_updated_on
        , Z.begin_version
        , Z.cleanup_version
        , Z.min_valid_version
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.change_tracking_tables AS Z
       ON T.object_id
        = Z.object_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
 ORDER BY S.name
        , T.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , CONVERT(varchar(0040), T.create_date, 120) AS create_date
        , CONVERT(varchar(0040), T.modify_date, 120) AS modify_date
--      , T.type      AS SQLServerType
        , I.type      AS table_type
--      , I.type      AS index_type
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
      AND T.is_tracked_by_cdc != 0
 ORDER BY S.name
        , T.name

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , E.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , C.column_id
        , C.is_nullable
        , C.is_computed
        , C.is_identity
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
        , ISNULL(                   C.collation_name , '') AS collation_name
        , ISNULL(CONVERT(varchar(4000), W.definition), '') AS FormulaCode
        , ISNULL(CONVERT(varchar(4000), Z.definition), '') AS DefaultCode
        , ISNULL(                             Z.name , '') AS DefaultName
     INTO #TKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.columns AS C
       ON O.object_id
        = C.object_id
     JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.computed_columns AS W
       ON C.object_id
        = W.object_id
      AND C.column_id
        = W.column_id
LEFT JOIN sys.default_constraints AS Z
       ON        C.object_id
        = Z.parent_object_id
      AND        C.column_id
        = Z.parent_column_id
     JOIN sys.table_types AS E
       ON            O.object_id
        = E.type_table_object_id
 ORDER BY   GeneralType
        ,   GeneralSchema
        ,   GeneralObject
        ,   column_id

   SELECT T.*
        , CASE WHEN T.name = 'time'           THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetime2'      THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetimeoffset' THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'float'          THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2)                                         + ')'
               WHEN T.name = 'numeric'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'decimal'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'vardecimal'     THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'binary'         THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varbinary'      THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'nchar'          THEN T.name + '(' +                                 RIGHT(STR(T.min_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'nvarchar'       THEN T.name + '(' + CASE WHEN T.min_length > 0 THEN RIGHT(STR(T.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'char'           THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varchar'        THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE T.name END AS SQLServerType
     INTO #TKeys
     FROM #TKey AS T
 ORDER BY T.GeneralType
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id

   SELECT T.GeneralSchema
        , T.GeneralObject
        , T.create_date
        , T.modify_date
        , T.column_id
        , T.GeneralColumn
        , T.SQLServerType
        , T.collation_name
        , T.is_nullable
        , T.is_identity
        , T.DefaultName
        , T.DefaultCode
        , T.FormulaCode
     FROM #TKeys AS T
 ORDER BY T.GeneralType
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id

DROP TABLE #TKey

DROP TABLE #TKeys

SET NOCOUNT OFF

