/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

PRINT 'index_type 2 means a       nonclustered      index (memory optimized)'
PRINT 'index_type 7 means a       nonclustered hash index (memory optimized)'

PRINT CHAR(13) + CHAR(10)

   SELECT S.name      AS ReferenceBySchema
        , O.name      AS ReferenceByObject
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
--      , O.type      AS SQLServerType
        , Z.name      AS ReferenceOfSchema
        , T.name      AS ReferenceOfObject
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.sql_expression_dependencies AS D
       ON O.object_id
        = D.referencing_id
     JOIN sys.objects AS T
       ON D.referenced_id
        = T.object_id
     JOIN sys.schemas AS Z
       ON T.schema_id
        = Z.schema_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('P ')
      AND ISNULL(OBJECTPROPERTY(O.object_id, 'ExecIsWithNativeCompilation'), 0) != 0
 ORDER BY S.name
        , O.name
        , Z.name
        , T.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , CONVERT(varchar(0040), T.create_date, 120) AS create_date
        , CONVERT(varchar(0040), T.modify_date, 120) AS modify_date
--      , T.type      AS SQLServerType
        , I.type      AS table_type
--      , I.type      AS index_type
        , T.is_memory_optimized
        , T.durability_desc
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
      AND ISNULL(OBJECTPROPERTY(T.object_id, 'TableIsMemoryOptimized'), 0) != 0
 ORDER BY S.name
        , T.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , W.name      AS SQLServerName
        , I.type      AS table_type
        , W.type      AS index_type
        , MAX(CASE WHEN M.index_column_id = 1 THEN   '[' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 2 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 3 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 4 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 5 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 6 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 7 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 8 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 9 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id > 9 THEN ', [...]'                                                                                ELSE SPACE(0) END) AS GeneralColumn
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.indexes AS W
       ON T.object_id
        = W.object_id
      AND W.type = 2
     JOIN sys.index_columns AS M
       ON W.object_id
        = M.object_id
      AND W.index_id
        = M.index_id
     JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
      AND ISNULL(OBJECTPROPERTY(T.object_id, 'TableIsMemoryOptimized'), 0) != 0
 GROUP BY S.name
        , T.name
        , W.name
        , I.type
        , W.type
        , W.is_primary_key
        , W.is_unique_constraint
 ORDER BY S.name
        , T.name
        , CASE WHEN W.is_primary_key != 0 THEN 0 WHEN W.is_unique_constraint != 0 THEN 1 ELSE 2 END
        , W.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , W.name      AS SQLServerName
        , I.type      AS table_type
        , W.type      AS index_type
        , MAX(CASE WHEN M.index_column_id = 1 THEN   '[' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 2 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 3 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 4 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 5 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 6 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 7 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 8 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 9 THEN ', [' + C.name + ']' + CASE WHEN M.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id > 9 THEN ', [...]'                                                                                ELSE SPACE(0) END) AS GeneralColumn
        , Z.bucket_count
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.indexes AS W
       ON T.object_id
        = W.object_id
      AND W.type = 7
     JOIN sys.index_columns AS M
       ON W.object_id
        = M.object_id
      AND W.index_id
        = M.index_id
     JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
     JOIN sys.hash_indexes AS Z
       ON W.object_id
        = Z.object_id
      AND W.index_id
        = Z.index_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
      AND ISNULL(OBJECTPROPERTY(T.object_id, 'TableIsMemoryOptimized'), 0) != 0
 GROUP BY S.name
        , T.name
        , W.name
        , I.type
        , W.type
        , W.is_primary_key
        , W.is_unique_constraint
        , Z.bucket_count
 ORDER BY S.name
        , T.name
        , CASE WHEN W.is_primary_key != 0 THEN 0 WHEN W.is_unique_constraint != 0 THEN 1 ELSE 2 END
        , W.name

SET NOCOUNT OFF

