/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

IF OBJECT_ID('tempdb..#TKey' , 'U ') IS NOT NULL DROP TABLE #TKey

IF OBJECT_ID('tempdb..#TKeys', 'U ') IS NOT NULL DROP TABLE #TKeys

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , C.column_id
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , C.is_nullable
        , C.is_computed
        , C.is_identity
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_SEED   (S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [From]
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_INCR   (S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [Plus]
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_CURRENT(S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [Used]
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
        , ISNULL(                   C.collation_name , '') AS collation_name
        , ISNULL(CONVERT(varchar(4000), W.definition), '') AS FormulaCode
        , ISNULL(CONVERT(varchar(4000), Z.definition), '') AS DefaultCode
        , ISNULL(                             Z.name , '') AS DefaultName
     INTO #TKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.columns AS C
       ON O.object_id
        = C.object_id
     JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND I.is_primary_key != 0
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
      AND C.column_id
        = M.column_id
LEFT JOIN sys.computed_columns AS W
       ON C.object_id
        = W.object_id
      AND C.column_id
        = W.column_id
LEFT JOIN sys.default_constraints AS Z
       ON        C.object_id
        = Z.parent_object_id
      AND        C.column_id
        = Z.parent_column_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralType
        ,   GeneralSchema
        ,   GeneralObject
        ,   column_id

   SELECT T.*
        , CASE WHEN T.name = 'time'           THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetime2'      THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetimeoffset' THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'float'          THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2)                                         + ')'
               WHEN T.name = 'numeric'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'decimal'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'vardecimal'     THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'binary'         THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varbinary'      THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'nchar'          THEN T.name + '(' +                                 RIGHT(STR(T.min_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'nvarchar'       THEN T.name + '(' + CASE WHEN T.min_length > 0 THEN RIGHT(STR(T.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'char'           THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varchar'        THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE T.name END AS SQLServerType
     INTO #TKeys
     FROM #TKey AS T
--  WHERE T.GeneralType IN ('U ')
 ORDER BY T.GeneralType
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , CONVERT(varchar(0040), T.create_date, 120) AS create_date
        , CONVERT(varchar(0040), T.modify_date, 120) AS modify_date
--      , T.type      AS SQLServerType
        , I.type      AS table_type
--      , I.type      AS index_type
        , T.temporal_type_desc
        , X.name      AS ValidFrom
        , Y.name      AS ValidTo
        , Z.name      AS HistorySchema
        , W.name      AS HistoryObject
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.columns AS X ON T.object_id = X.object_id AND X.generated_always_type = 1
     JOIN sys.columns AS Y ON T.object_id = Y.object_id AND Y.generated_always_type = 2
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.tables  AS W
       ON T.history_table_id
        = W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
      AND ISNULL(OBJECTPROPERTY(T.object_id, 'TableTemporalType'), 0) != 0
      AND T.temporal_type = 2
 ORDER BY S.name
        , T.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , CONVERT(varchar(0040), T.create_date, 120) AS create_date
        , CONVERT(varchar(0040), T.modify_date, 120) AS modify_date
--      , T.type      AS SQLServerType
        , I.type      AS table_type
--      , I.type      AS index_type
        , T.temporal_type_desc
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
      AND ISNULL(OBJECTPROPERTY(T.object_id, 'TableTemporalType'), 0) != 0
      AND T.temporal_type = 1
 ORDER BY S.name
        , T.name

   SELECT S.name      AS GeneralSchema
        , O.name      AS GeneralObject
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
--      , T.type      AS SQLServerType
        , I.type      AS table_type
--      , I.type      AS index_type
        , T.GeneralColumn
        , T.SQLServerType
        , Z.masking_function
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN #TKeys      AS T
       ON O.object_id
        = T.GeneralID
     JOIN sys.masked_columns AS Z
       ON T.GeneralID
        = Z.object_id
      AND T.column_id
        = Z.column_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
 ORDER BY S.name
        , O.name
        , T.column_id

   SELECT S.name      AS GeneralSchema
        , O.name      AS GeneralObject
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
--      , T.type      AS SQLServerType
        , I.type      AS table_type
--      , I.type      AS index_type
        , T.GeneralColumn
        , T.SQLServerType
        , C.encryption_type_desc
        , C.encryption_algorithm_name
        , ISNULL(C.column_encryption_key_database_name, DB_NAME()) AS column_encryption_key_database_name
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN #TKeys      AS T
       ON O.object_id
        = T.GeneralID
     JOIN sys.columns AS C
       ON T.GeneralID
        = C.object_id
      AND T.column_id
        = C.column_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND C.encryption_type_desc IS NOT NULL
 ORDER BY S.name
        , O.name
        , T.column_id

DROP TABLE #TKey

DROP TABLE #TKeys

SET NOCOUNT OFF

