/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @PrimaryObject varchar(0128)
DECLARE @PrimarySchema varchar(0128)
DECLARE @PrimaryColumn varchar(2000)

DECLARE @ForeignObject varchar(0128)
DECLARE @ForeignSchema varchar(0128)
DECLARE @ForeignColumn varchar(2000)

DECLARE @SQLServerName varchar(0128)

DECLARE @is_not_trusted bit

DECLARE @DELETE_save tinyint
DECLARE @DELETE_code tinyint
DECLARE @DELETE_name varchar(0100)

DECLARE @UPDATE_save tinyint
DECLARE @UPDATE_code tinyint
DECLARE @UPDATE_name varchar(0100)

DECLARE @PN smallint
DECLARE @PC smallint
DECLARE @FN smallint
DECLARE @FC smallint
DECLARE @ZN smallint

DECLARE @CHECK_save int

IF OBJECT_ID('tempdb..#Base' , 'U ') IS NOT NULL DROP TABLE #Base

IF OBJECT_ID('tempdb..#FKey' , 'U ') IS NOT NULL DROP TABLE #FKey
IF OBJECT_ID('tempdb..#FKeys', 'U ') IS NOT NULL DROP TABLE #FKeys

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , O.parent_object_id AS VariousID
        , CONVERT(varchar(max ), ISNULL(M.definition, SPACE(0))) AS SQLServerCode
     INTO #Base
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
LEFT JOIN sys.sql_modules AS M
       ON O.object_id
        = M.object_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY O.type
        , S.name
        , O.name

   SELECT O.object_id AS ForeignID
        , W.object_id AS PrimaryID
        , O.name      AS ForeignObject
        , W.name      AS PrimaryObject
        , S.name      AS ForeignSchema
        , Z.name      AS PrimarySchema
        , F.name      AS SQLServerName
        , CONVERT(varchar(0040), F.create_date, 120) AS create_date
        , CONVERT(varchar(0040), F.modify_date, 120) AS modify_date
        , F.is_disabled
        , F.is_not_trusted
        , M.constraint_column_id
        , C.name      AS ForeignColumn
        , K.name      AS PrimaryColumn
        , F.delete_referential_action
        , F.delete_referential_action_desc
        , F.update_referential_action
        , F.update_referential_action_desc
     INTO #FKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.foreign_keys AS F
       ON        O.object_id
        = F.parent_object_id
     JOIN sys.foreign_key_columns AS M
       ON            F.object_id
        = M.constraint_object_id
     JOIN sys.columns AS C
       ON M.parent_object_id
        =        C.object_id
      AND M.parent_column_id
        =        C.column_id
     JOIN sys.columns AS K
       ON M.referenced_object_id
        =            K.object_id
      AND M.referenced_column_id
        =            K.column_id
     JOIN sys.objects AS W
       ON F.referenced_object_id
        =            W.object_id
--    AND            O.object_id
--     !=            W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
      AND Z.name IN (SELECT [Schema] FROM @Match)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   PrimarySchema
        ,   PrimaryObject
        ,   ForeignSchema
        ,   ForeignObject
        ,   constraint_column_id

   SELECT F.PrimarySchema
        , F.PrimaryObject
        , MAX(CASE WHEN F.constraint_column_id = 1 THEN   '[' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 2 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 3 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 4 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 5 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 6 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 7 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 8 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 9 THEN ', [' + F.PrimaryColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id > 9 THEN ', [...]'                     ELSE SPACE(0) END) AS PrimaryColumn
        , F.SQLServerName
        , F.create_date
        , F.modify_date
        , F.is_disabled
        , F.is_not_trusted
        , F.delete_referential_action
        , F.delete_referential_action_desc
        , F.update_referential_action
        , F.update_referential_action_desc
        , F.ForeignSchema
        , F.ForeignObject
        , MAX(CASE WHEN F.constraint_column_id = 1 THEN   '[' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 2 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 3 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 4 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 5 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 6 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 7 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 8 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 9 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id > 9 THEN ', [...]'                     ELSE SPACE(0) END) AS ForeignColumn
     INTO #FKeys
     FROM #FKey AS F
 GROUP BY F.PrimarySchema
        , F.PrimaryObject
        , F.SQLServerName
        , F.create_date
        , F.modify_date
        , F.is_disabled
        , F.is_not_trusted
        , F.delete_referential_action
        , F.delete_referential_action_desc
        , F.update_referential_action
        , F.update_referential_action_desc
        , F.ForeignSchema
        , F.ForeignObject
 ORDER BY F.PrimarySchema
        , F.PrimaryObject
--      , F.SQLServerName
        , F.ForeignSchema
        , F.ForeignObject

   SELECT @CHECK_save  = SUM(CASE WHEN F.is_not_trusted = 0 THEN 0 ELSE 1 END)
        , @DELETE_save = MAX(F.delete_referential_action)
        , @UPDATE_save = MAX(F.update_referential_action)
        , @PN          = MAX(LEN(F.PrimarySchema) + LEN(F.PrimaryObject))
        , @FN          = MAX(LEN(F.ForeignSchema) + LEN(F.ForeignObject))
        , @ZN          = MAX(LEN(F.SQLServerName))
        , @PC          = MAX(LEN(F.PrimaryColumn))
        , @FC          = MAX(LEN(F.ForeignColumn))
     FROM #FKeys AS F

   SELECT F.PrimarySchema
        , F.PrimaryObject
        , F.PrimaryColumn
        , F.SQLServerName
        , F.create_date
        , F.modify_date
        , F.is_disabled
        , F.is_not_trusted
        , F.ForeignSchema
        , F.ForeignObject
        , F.ForeignColumn
        , CASE WHEN F.delete_referential_action = 0 THEN SPACE(0) ELSE F.delete_referential_action_desc END AS ON_DELETE
        , CASE WHEN F.update_referential_action = 0 THEN SPACE(0) ELSE F.update_referential_action_desc END AS ON_UPDATE
     FROM #FKeys AS F
 ORDER BY F.PrimarySchema
        , F.PrimaryObject
--      , F.SQLServerName
        , F.ForeignSchema
        , F.ForeignObject

-- generate SQL

  DECLARE Objects CURSOR FAST_FORWARD FOR
   SELECT F.PrimarySchema
        , F.PrimaryObject
        , F.ForeignSchema
        , F.ForeignObject
        , F.SQLServerName
     FROM #FKeys AS F
 ORDER BY F.PrimarySchema
        , F.PrimaryObject
--      , F.SQLServerName
        , F.ForeignSchema
        , F.ForeignObject

OPEN Objects

FETCH NEXT FROM Objects INTO @PrimarySchema, @PrimaryObject, @ForeignSchema, @ForeignObject, @SQLServerName

WHILE @@FETCH_STATUS = 0

    BEGIN

    PRINT 'ALTER TABLE ' + @ForeignSchema + '.' + @ForeignObject + SPACE(@FN - LEN(@ForeignSchema) - LEN(@ForeignObject))

        + ' DROP CONSTRAINT ' + @SQLServerName + SPACE(@ZN - LEN(@SQLServerName))

        + ' -- ' + @PrimarySchema + '.' + @PrimaryObject

    FETCH NEXT FROM Objects INTO @PrimarySchema, @PrimaryObject, @ForeignSchema, @ForeignObject, @SQLServerName

    END

CLOSE Objects DEALLOCATE Objects

PRINT CHAR(13) + CHAR(10)

  DECLARE Objects CURSOR FAST_FORWARD FOR
   SELECT E.GeneralSchema
        , E.GeneralObject
     FROM #Base AS E
 ORDER BY E.GeneralSchema
        , E.GeneralObject

OPEN Objects

FETCH NEXT FROM Objects INTO @PrimarySchema, @PrimaryObject

WHILE @@FETCH_STATUS = 0

    BEGIN

    PRINT '-- TRUNCATE TABLE ' + @PrimarySchema + '.' + @PrimaryObject

    FETCH NEXT FROM Objects INTO @PrimarySchema, @PrimaryObject

    END

CLOSE Objects DEALLOCATE Objects

PRINT CHAR(13) + CHAR(10)

  DECLARE Objects CURSOR FAST_FORWARD FOR
   SELECT F.PrimarySchema
        , F.PrimaryObject
        , F.PrimaryColumn
        , F.ForeignSchema
        , F.ForeignObject
        , F.ForeignColumn
        , F.SQLServerName
        , F.is_not_trusted
        , F.delete_referential_action
        , F.delete_referential_action_desc
        , F.update_referential_action
        , F.update_referential_action_desc
     FROM #FKeys AS F
 ORDER BY F.PrimarySchema
        , F.PrimaryObject
--      , F.SQLServerName
        , F.ForeignSchema
        , F.ForeignObject

OPEN Objects

FETCH NEXT FROM Objects INTO @PrimarySchema, @PrimaryObject, @PrimaryColumn, @ForeignSchema, @ForeignObject, @ForeignColumn, @SQLServerName, @is_not_trusted, @DELETE_code, @DELETE_name, @UPDATE_code, @UPDATE_name

WHILE @@FETCH_STATUS = 0

    BEGIN

    PRINT 'ALTER TABLE ' + @ForeignSchema + '.' + @ForeignObject + SPACE(@FN - LEN(@ForeignSchema) - LEN(@ForeignObject))

        + CASE WHEN @CHECK_save = 0 THEN SPACE(0) ELSE CASE WHEN @is_not_trusted = 0 THEN SPACE(13) ELSE ' WITH NOCHECK' END END

        + ' ADD CONSTRAINT ' + @SQLServerName + SPACE(@ZN - LEN(@SQLServerName))

        + ' FOREIGN KEY (' + @ForeignColumn + ')' + SPACE(@FC - LEN(@ForeignColumn))

        + ' REFERENCES ' + @PrimarySchema + '.' + @PrimaryObject + SPACE(@PN - LEN(@PrimarySchema) - LEN(@PrimaryObject)) + ' (' + @PrimaryColumn + ')' + SPACE(@PC - LEN(@PrimaryColumn))

        + CASE WHEN @DELETE_save = 0 THEN SPACE(0) ELSE CASE WHEN @DELETE_code = 0 THEN SPACE(22) ELSE ' ON DELETE ' + REPLACE(@DELETE_name, '_', ' ') + SPACE(11 - LEN(@DELETE_name)) END END

        + CASE WHEN @UPDATE_save = 0 THEN SPACE(0) ELSE CASE WHEN @UPDATE_code = 0 THEN SPACE(22) ELSE ' ON UPDATE ' + REPLACE(@UPDATE_name, '_', ' ') + SPACE(11 - LEN(@UPDATE_name)) END END

        + ' -- ' + @PrimarySchema + '.' + @PrimaryObject

    FETCH NEXT FROM Objects INTO @PrimarySchema, @PrimaryObject, @PrimaryColumn, @ForeignSchema, @ForeignObject, @ForeignColumn, @SQLServerName, @is_not_trusted, @DELETE_code, @DELETE_name, @UPDATE_code, @UPDATE_name

    END

CLOSE Objects DEALLOCATE Objects

PRINT CHAR(13) + CHAR(10)

DROP TABLE #Base

DROP TABLE #FKey
DROP TABLE #FKeys

SET NOCOUNT OFF

