/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Last_Run datetime = DATEADD(hour, -24, GETDATE()) -- minimum datetime of last run, CONVERT(datetime, '1900/01/01 00:00:00')

DECLARE @Seconds_SUM decimal(19,05) = 60                   -- minimum time for Seconds_SUM

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

IF OBJECT_ID('tempdb..#Action'     , 'U ') IS NOT NULL DROP TABLE #Action

IF OBJECT_ID('tempdb..#Action_Work', 'U ') IS NOT NULL DROP TABLE #Action_Work

IF OBJECT_ID('tempdb..#Action_Base', 'U ') IS NOT NULL DROP TABLE #Action_Base

IF OBJECT_ID('tempdb..#Action_More', 'U ') IS NOT NULL DROP TABLE #Action_More

   SELECT E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.ObjectType
        , E.query_plan
        , REPLACE(
          REPLACE(
          REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(E.query_plan, '&#x09;', ''), '&#x9;', '')
                                      , '&#x0D;', ''), '&#xD;', '')
                                      , '&#x0A;', ''), '&#xA;', '')
                                      , '&amp;amp;amp;', '')
                                      , '&amp;amp;'    , '')
                                      , '&amp;'        , '') AS query_plus
        , E.Executions
        , E.Creation
        , E.Last_Run
        , ROW_NUMBER() OVER (ORDER BY E.DBName, E.SchemaName, E.ObjectName, E.Creation, E.Last_Run) AS PlanID
        , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
        ,           E.text                  AS SQL_code_all
        , CONVERT(int, 0) AS T
        , CONVERT(int, 0) AS W
        , CONVERT(int, 0) AS Z
        , CONVERT(int, 0) AS V
     INTO #Action
     FROM
  (SELECT S.execution_count AS Executions
        , CONVERT(varchar(0040),       S.creation_time, 120) AS Creation
        , CONVERT(varchar(0040), S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), S.total_worker_time / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), S.total_worker_time / 1000.0 / 1000.0                    ) AS Seconds_SUM
        ,            DB_NAME(            V.dbid) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(V.objectid, V.dbid) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(V.objectid, V.dbid) COLLATE database_default AS ObjectName
        ,                               SPACE(2) COLLATE database_default AS ObjectType
        , CASE WHEN S.statement_start_offset < 0 THEN     0                                                                            ELSE (S.statement_start_offset / 2)     END + 1 AS I
        , CASE WHEN S.statement_end_offset   < 0 THEN LEN(T.text) WHEN S.statement_end_offset > (LEN(T.text) * 2) - 4 THEN LEN(T.text) ELSE (S.statement_end_offset   / 2) + 1 END + 1 AS O
        , T.text COLLATE database_default AS text
        , CONVERT(nvarchar(max), V.query_plan) COLLATE database_default AS query_plan
     FROM sys.dm_exec_query_stats AS S OUTER APPLY sys.dm_exec_sql_text(S.sql_handle) AS T OUTER APPLY sys.dm_exec_query_plan(S.plan_handle) AS V) AS E
    WHERE E.DBName NOT IN ('tempdb', 'msdb', 'master')
      AND E.query_plan LIKE '%<MissingIndexes>%'
      AND E.Seconds_SUM
       !<  @Seconds_SUM
      AND E.Last_Run
       !<  @Last_Run
 ORDER BY E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.Creation
        , E.Last_Run

   UPDATE #Action SET T = CHARINDEX(LEFT(REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(E.SQL_code, CHAR(09), '')
                                                           , CHAR(13), '')
                                                           , CHAR(10), '')
                                                           , '&amp;' , '')
                                                           , '&'     , '')
                                                           , '['     , '{'     )
                                                           , ']'     , '}'     )
                                                           , '<'     , '&lt;'  )
                                                           , '>'     , '&gt;'  )
                                                           , '"'     , '&quot;'), 2000), E.query_plus, 1)
     FROM #Action AS E
    WHERE E.T = 0

   UPDATE #Action SET T = CHARINDEX(LEFT(REPLACE(
                                         REPLACE(
                                         REPLACE(
--                                       REPLACE(
--                                       REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(
                                         REPLACE(E.SQL_code, CHAR(09), '')
                                                           , CHAR(13), '')
                                                           , CHAR(10), '')
                                                           , '&amp;' , '')
                                                           , '&'     , '')
--                                                         , '['     , '{'     )
--                                                         , ']'     , '}'     )
                                                           , '<'     , '&lt;'  )
                                                           , '>'     , '&gt;'  )
                                                           , '"'     , '&quot;'), 2000), E.query_plus, 1)
     FROM #Action AS E
    WHERE E.T = 0

   UPDATE #Action SET W = CHARINDEX('StatementSubTreeCost="', E.query_plus, E.T + 2)
     FROM #Action AS E

   UPDATE #Action SET Z = CHARINDEX('"', E.query_plus, E.W + 22)
     FROM #Action AS E

   UPDATE #Action SET V = CHARINDEX('</QueryPlan>', E.query_plus, E.Z + 2)
     FROM #Action AS E

DECLARE @T smallint

DECLARE @I smallint

   SELECT U.*
        , CHARINDEX('</MissingIndexGroup>', U.query_plus, U.I     ) AS O
        , CHARINDEX('"'                   , U.query_plus, U.I + 27) AS U
     INTO #Action_Work
     FROM
  (SELECT E.*
        , CONVERT(decimal(19,05), CONVERT(float(53), CASE WHEN E.T > 0 AND E.W > 0 AND E.W < E.Z THEN SUBSTRING(E.query_plus, E.W + 22, E.Z - E.W - 22) ELSE NULL END)) AS CostEstimate
        , CHARINDEX( '<MissingIndexGroup ', E.query_plus, E.T) AS I
     FROM #Action AS E) AS U
    WHERE U.I > 0
      AND U.I < U.V

SET @T = @@ROWCOUNT

WHILE @T > 0

    BEGIN

       INSERT #Action_Work
       SELECT U.*
            , CHARINDEX('</MissingIndexGroup>', U.query_plus, U.I     ) AS O
            , CHARINDEX('"'                   , U.query_plus, U.I + 27) AS U
         FROM
      (SELECT E.DBName
            , E.SchemaName
            , E.ObjectName
            , E.ObjectType
            , E.query_plan
            , E.query_plus
            , E.Executions
            , E.Creation
            , E.Last_Run
            , E.PlanID
            , E.SQL_code
            , E.SQL_code_all
            , E.T
            , E.W
            , E.Z
            , E.V
            , E.CostEstimate
            , CHARINDEX( '<MissingIndexGroup ', E.query_plus, Z.T) AS I
         FROM #Action_Work AS E
         JOIN
      (SELECT W.PlanID
            , MAX(W.O)     AS T
         FROM #Action_Work AS W
     GROUP BY W.PlanID)    AS Z
           ON E.PlanID
            = Z.PlanID
          AND E.O
            = Z.T)         AS U
        WHERE U.I > 0
          AND U.I < U.V

    SET @T = @@ROWCOUNT

    END

   SELECT E.*
        , CONVERT(decimal(09,04), SUBSTRING(E.query_plus, E.I + 27, E.U - E.I - 27)) AS index_value
        ,                         SUBSTRING(E.query_plus, E.U +  2, E.O - E.U -  2)  AS index_details_from_query_plan
        , CONVERT(varchar(0800) , SPACE(0)) AS INDEX_KEY
        , CONVERT(varchar(3200) , SPACE(0)) AS INDEX_NET
        , CONVERT(int, 0) AS DBItemFrom
        , CONVERT(int, 0) AS DBItemThru
        , CONVERT(int, 0) AS SchemaFrom
        , CONVERT(int, 0) AS SchemaThru
        , CONVERT(int, 0) AS ObjectFrom
        , CONVERT(int, 0) AS ObjectThru
        , CONVERT(int, 0) AS ColumnFrom
        , CONVERT(int, 0) AS ColumnThru
        , CONVERT(int, 0) AS ClauseFrom
        , CONVERT(int, 0) AS ClauseThru
     INTO #Action_Base
     FROM #Action_Work AS E

   UPDATE #Action_Base SET
          DBItemFrom = CHARINDEX('Database="', E.index_details_from_query_plan)
        , SchemaFrom = CHARINDEX(  'Schema="', E.index_details_from_query_plan)
        , ObjectFrom = CHARINDEX(   'Table="', E.index_details_from_query_plan)
        , ColumnFrom = CHARINDEX( 'EQUALITY"', E.index_details_from_query_plan)
        , ClauseFrom = CHARINDEX(  'INCLUDE"', E.index_details_from_query_plan)
     FROM #Action_Base AS E

   UPDATE #Action_Base SET
          DBItemThru = CHARINDEX('"', E.index_details_from_query_plan, E.DBItemFrom + 10)
        , SchemaThru = CHARINDEX('"', E.index_details_from_query_plan, E.SchemaFrom +  8)
        , ObjectThru = CHARINDEX('"', E.index_details_from_query_plan, E.ObjectFrom +  7)
     FROM #Action_Base AS E

   UPDATE #Action_Base SET
            ClauseFrom = LEN(E.index_details_from_query_plan)
     FROM #Action_Base AS E
    WHERE E.ClauseFrom = 0

   SELECT @I = COUNT(*)
     FROM #Action_Base AS E
    WHERE E.ColumnFrom > 0

WHILE @I > 0

    BEGIN

       UPDATE #Action_Base SET
                ColumnFrom = CHARINDEX('Column Name="', E.index_details_from_query_plan, E.ColumnFrom)
         FROM #Action_Base AS E
        WHERE E.ColumnFrom > 0

       UPDATE #Action_Base SET
                ColumnThru = CHARINDEX(            '"', E.index_details_from_query_plan, E.ColumnFrom + 13)
         FROM #Action_Base AS E
        WHERE E.ColumnFrom > 0

       UPDATE #Action_Base SET
              INDEX_KEY = E.INDEX_KEY + CASE WHEN LEN(E.INDEX_KEY) > 0 THEN ', ' ELSE SPACE(0) END + SUBSTRING(E.index_details_from_query_plan, E.ColumnFrom + 13, E.ColumnThru - E.ColumnFrom - 13)
         FROM #Action_Base AS E
        WHERE E.ColumnFrom > 0
          AND E.ColumnFrom < E.ClauseFrom

       UPDATE #Action_Base SET
              INDEX_NET = E.INDEX_NET + CASE WHEN LEN(E.INDEX_NET) > 0 THEN ', ' ELSE SPACE(0) END + SUBSTRING(E.index_details_from_query_plan, E.ColumnFrom + 13, E.ColumnThru - E.ColumnFrom - 13)
         FROM #Action_Base AS E
        WHERE E.ColumnFrom > 0
          AND E.ColumnFrom > E.ClauseFrom

       UPDATE #Action_Base SET
                ColumnFrom = E.ColumnThru + 2
         FROM #Action_Base AS E
        WHERE E.ColumnFrom > 0

    SET @I = @@ROWCOUNT

    END

   SELECT E.DBName     AS DBName_
        , E.SchemaName AS SchemaName_
        , E.ObjectName AS ObjectName_
        , E.ObjectType AS ObjectType_
        , E.query_plan
        , E.query_plus
        , E.Executions
        , E.Creation
        , E.Last_Run
        , E.PlanID
        , E.SQL_code
        , E.SQL_code_all
        , E.CostEstimate
        , E.index_value
        , E.index_details_from_query_plan
        , CONVERT(bigint, E.CostEstimate * (E.index_value / 100.0) * E.Executions) AS Benefit
        , SUBSTRING(E.index_details_from_query_plan, E.DBItemFrom + 10, E.DBItemThru - E.DBItemFrom - 10) AS DBName
        , SUBSTRING(E.index_details_from_query_plan, E.SchemaFrom +  8, E.SchemaThru - E.SchemaFrom -  8) AS SchemaName
        , SUBSTRING(E.index_details_from_query_plan, E.ObjectFrom +  7, E.ObjectThru - E.ObjectFrom -  7) AS ObjectName
        , E.INDEX_KEY
        , E.INDEX_NET
     INTO #Action_More
     FROM #Action_Base AS E
 ORDER BY   DBName
        ,   SchemaName
        ,   ObjectName
        ,   INDEX_KEY
        ,   INDEX_NET
        ,   DBName_
        ,   SchemaName_
        ,   ObjectName_

   SELECT 'CREATE NONCLUSTERED INDEX IX_DBA ON ' + E.DBName
        +                                    '.' + E.SchemaName
        +                                    '.' + E.ObjectName
        +                                             ' (' + E.INDEX_KEY + ')'
        + CASE WHEN LEN(E.INDEX_NET) > 0 THEN ' INCLUDE (' + E.INDEX_NET + ')' ELSE SPACE(0) END AS CREATE_INDEX
        , E.index_value
        , E.CostEstimate
        , E.Executions
        , E.Benefit
--      , E.index_details_from_query_plan
--      , CONVERT(XML, E.query_plan) AS query_plan
--      , E.PlanID
        , E.Creation
        , E.Last_Run
        , E.DBName_
        , E.SchemaName_
        , E.ObjectName_
--      , E.ObjectType_
        , E.SQL_code
        , E.SQL_code_all
     FROM #Action_More AS E
 ORDER BY E.DBName_
        , E.SchemaName_
        , E.ObjectName_
        , E.SQL_code
        , E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.INDEX_KEY
        , E.INDEX_NET

   SELECT 'CREATE NONCLUSTERED INDEX IX_DBA ON ' + E.DBName
        +                                    '.' + E.SchemaName
        +                                    '.' + E.ObjectName
        +                                             ' (' + E.INDEX_KEY + ')'
        + CASE WHEN LEN(E.INDEX_NET) > 0 THEN ' INCLUDE (' + E.INDEX_NET + ')' ELSE SPACE(0) END AS CREATE_INDEX
        , E.index_value
        , E.CostEstimate
        , E.Executions
        , E.Benefit
--      , E.index_details_from_query_plan
--      , CONVERT(XML, E.query_plan) AS query_plan
--      , E.PlanID
        , E.Creation
        , E.Last_Run
        , E.DBName_
        , E.SchemaName_
        , E.ObjectName_
--      , E.ObjectType_
        , E.SQL_code
        , E.SQL_code_all
     FROM #Action_More AS E
 ORDER BY E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.INDEX_KEY
        , E.INDEX_NET
        , E.DBName_
        , E.SchemaName_
        , E.ObjectName_
        , E.SQL_code

   SELECT 'CREATE NONCLUSTERED INDEX IX_DBA ON ' + E.DBName
        +                                    '.' + E.SchemaName
        +                                    '.' + E.ObjectName
        +                                             ' (' + E.INDEX_KEY + ')'
        + CASE WHEN LEN(E.INDEX_NET) > 0 THEN ' INCLUDE (' + E.INDEX_NET + ')' ELSE SPACE(0) END AS CREATE_INDEX
        , SUM(E.Benefit) AS Benefit
        , COUNT(*)       AS Queries
     FROM #Action_More AS E
 GROUP BY E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.INDEX_KEY
        , E.INDEX_NET
 ORDER BY   Benefit DESC
        , E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.INDEX_KEY
        , E.INDEX_NET

DROP TABLE #Action

DROP TABLE #Action_Work

DROP TABLE #Action_Base

DROP TABLE #Action_More

SET NOCOUNT OFF

