/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

PRINT 'index_type 0 means a table as heap'
PRINT 'index_type 1 means a table as clustered index'
PRINT 'index_type 5 means a table as clustered index (columnstore)'
PRINT 'index_type 2 means a       nonclustered index'
PRINT 'index_type 6 means a       nonclustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

PRINT 'Issue 01 = clustering key is not unique'
PRINT 'Issue 02 = clustering key is 5+ columns'
PRINT 'Issue 03 = clustering key is GUID-based'
PRINT 'Issue 04 = 1 column, not FK, not unique'
PRINT 'Issue 05 = indexing key has long string'
PRINT 'Issue 06 = index has sparse fill factor'
PRINT 'Issue 07 = index is disabled internally'

PRINT CHAR(13) + CHAR(10)

IF OBJECT_ID('tempdb..#ZKey' , 'U ') IS NOT NULL DROP TABLE #ZKey

IF OBJECT_ID('tempdb..#ZKeys', 'U ') IS NOT NULL DROP TABLE #ZKeys

IF OBJECT_ID('tempdb..#Hack' , 'U ') IS NOT NULL DROP TABLE #Hack

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , I.is_unique
        , I.is_disabled
        , M.is_included_column
        , M.is_descending_key
        , M.partition_ordinal
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , CASE WHEN M.is_included_column  = 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY M.key_ordinal, M.index_column_id) ELSE 0 END AS regular_column_id
        , CASE WHEN M.is_included_column != 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY                M.index_column_id) ELSE 0 END AS include_column_id
        , ISNULL(I.filter_definition, SPACE(0)) AS GeneralFilter
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
     INTO #ZKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
LEFT JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName
        ,   index_column_id

   SELECT Z.*
        , CASE WHEN Z.name = 'time'           THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'datetime2'      THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'datetimeoffset' THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'float'          THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2)                                         + ')'
               WHEN Z.name = 'numeric'        THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'decimal'        THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'vardecimal'     THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'binary'         THEN Z.name + '(' +                                 RIGHT(STR(Z.max_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'varbinary'      THEN Z.name + '(' + CASE WHEN Z.max_length > 0 THEN RIGHT(STR(Z.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN Z.name = 'nchar'          THEN Z.name + '(' +                                 RIGHT(STR(Z.min_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'nvarchar'       THEN Z.name + '(' + CASE WHEN Z.min_length > 0 THEN RIGHT(STR(Z.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN Z.name = 'char'           THEN Z.name + '(' +                                 RIGHT(STR(Z.max_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'varchar'        THEN Z.name + '(' + CASE WHEN Z.max_length > 0 THEN RIGHT(STR(Z.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE Z.name END AS SQLServerType
     INTO #ZKeys
     FROM #ZKey AS Z
 ORDER BY Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerName
        , Z.index_column_id

   UPDATE Z SET table_type = CASE WHEN E.GeneralType = 'V ' THEN 0 - E.index_type ELSE E.index_type END FROM #ZKey  AS Z JOIN #ZKey AS E ON Z.GeneralID = E.GeneralID AND E.index_type IN (0, 1, 5) AND E.index_column_id IN (0, 1)
   UPDATE Z SET table_type = CASE WHEN E.GeneralType = 'V ' THEN 0 - E.index_type ELSE E.index_type END FROM #ZKeys AS Z JOIN #ZKey AS E ON Z.GeneralID = E.GeneralID AND E.index_type IN (0, 1, 5) AND E.index_column_id IN (0, 1)

   SELECT Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
        , SUM(CASE WHEN Z.regular_column_id >  0 THEN 1 ELSE 0 END) AS KeyColumns
        , SUM(CASE WHEN Z.include_column_id >  0 THEN 1 ELSE 0 END) AS AnyColumns
        , MAX(CASE WHEN Z.regular_column_id =  1 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  2 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  3 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  4 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  5 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  6 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  7 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  8 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  9 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 10 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 11 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 12 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 13 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 14 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 15 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 16 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 17 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 18 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 19 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS RegularColumn
        , MAX(CASE WHEN Z.include_column_id =  1 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  2 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  3 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  4 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  5 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  6 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  7 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  8 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  9 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 10 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 11 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 12 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 13 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 14 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 15 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 16 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 17 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 18 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 19 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS IncludeColumn
     INTO #Hack
     FROM #ZKey AS Z
 GROUP BY Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
 ORDER BY Z.GeneralSchema
        , Z.GeneralObject
        , Z.index_id

   SELECT '01' AS [Issue]
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS [TYPE]s
        , I.table_type
        , I.index_type
        , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
     FROM #Hack AS I
    WHERE I.index_type = 1
      AND I.is_unique  = 0
      AND ISNULL(OBJECTPROPERTY(I.GeneralID, 'TableTemporalType'), 0) = 0
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

   SELECT '02' AS [Issue]
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS [TYPE]s
        , I.table_type
        , I.index_type
        , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
     FROM #Hack AS I
    WHERE I.index_type = 1
      AND I.KeyColumns > 4
      AND ISNULL(OBJECTPROPERTY(I.GeneralID, 'TableTemporalType'), 0) = 0
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

   SELECT '03' AS [Issue]
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS [TYPE]s
        , I.table_type
        , I.index_type
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
        , Z.GeneralColumn
        , Z.SQLServerType
     FROM #Hack  AS I
     JOIN #ZKeys AS Z
       ON I.GeneralID
        = Z.GeneralID
      AND I.index_id
        = Z.index_id
    WHERE I.index_type      = 1
      AND Z.index_column_id = 1
      AND Z.SQLServerType   = 'uniqueidentifier'
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

   SELECT '04' AS [Issue]
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS [TYPE]s
        , I.table_type
        , I.index_type
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
        , Z.GeneralColumn
        , Z.SQLServerType
     FROM #Hack  AS I
     JOIN #ZKeys AS Z
       ON I.GeneralID
        = Z.GeneralID
      AND I.index_id
        = Z.index_id
    WHERE I.index_type = 2
      AND I.KeyColumns = 1
      AND I.AnyColumns = 0
      AND I.is_unique  = 0
      AND NOT EXISTS
  (SELECT *
     FROM sys.foreign_keys        AS F
     JOIN sys.foreign_key_columns AS M
       ON            F.object_id
        = M.constraint_object_id
      AND M.constraint_column_id = 1
     JOIN sys.columns AS C
       ON M.parent_object_id
        =        C.object_id
      AND M.parent_column_id
        =        C.column_id
    WHERE F.parent_object_id
        =        I.GeneralID
      AND I.RegularColumn = '[' + C.name + ']')
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

   SELECT '05' AS [Issue]
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS [TYPE]s
        , I.table_type
        , I.index_type
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
        , Z.GeneralColumn
        , Z.SQLServerType
     FROM #Hack  AS I
     JOIN #ZKeys AS Z
       ON I.GeneralID
        = Z.GeneralID
      AND I.index_id
        = Z.index_id
    WHERE CASE WHEN Z.name =     'char' AND Z.max_length > 16 THEN 1
               WHEN Z.name =    'nchar' AND Z.max_length > 24 THEN 1
               WHEN Z.name =  'varchar' AND Z.max_length > 24 THEN 1
               WHEN Z.name = 'nvarchar' AND Z.max_length > 36 THEN 1 ELSE 0 END != 0
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName
        , Z.index_column_id

   SELECT '06' AS [Issue]
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS [TYPE]s
        , I.table_type
        , I.index_type
        , I.RegularColumn
        , I.IncludeColumn
        , I.GeneralFilter
     FROM #Hack AS I
    WHERE I.fill_factor BETWEEN 1 AND 69
      AND ISNULL(OBJECTPROPERTY(I.GeneralID, 'TableTemporalType'), 0) = 0
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

   SELECT '07' AS [Issue]
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
--      , I.SQLServerFile
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS [TYPE]s
        , I.table_type
        , I.index_type
        , I.RegularColumn
        , I.IncludeColumn
        , I.GeneralFilter
     FROM #Hack AS I
    WHERE I.is_disabled != 0
      AND ISNULL(OBJECTPROPERTY(I.GeneralID, 'TableTemporalType'), 0) = 0
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

DROP TABLE #ZKey

DROP TABLE #ZKeys

DROP TABLE #Hack

SET NOCOUNT OFF

