/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , O.name      AS SQLServerName
        , I.type      AS table_type
        , O.type      AS index_type
        , 'XML'       AS index_type_name
        ,        Z.xml_index_type_description            AS xml_index_type_desc
        , ISNULL(Z.secondary_type_desc       , SPACE(0)) AS secondary_type_desc
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.indexes AS O
       ON T.object_id
        = O.object_id
      AND O.type = 3
     JOIN sys.xml_indexes AS Z
       ON O.object_id
        = Z.object_id
      AND O.index_id
        = Z.index_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
 ORDER BY S.name
        , T.name
        , O.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , O.name      AS SQLServerName
        , I.type      AS table_type
        , O.type      AS index_type
        , 'spatial'   AS index_type_name
        , Z.spatial_index_type_desc
        , Z.tessellation_scheme
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.indexes AS O
       ON T.object_id
        = O.object_id
      AND O.type = 4
     JOIN sys.spatial_indexes AS Z
       ON O.object_id
        = Z.object_id
      AND O.index_id
        = Z.index_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
 ORDER BY S.name
        , T.name
        , O.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , O.name      AS SQLServerName
        , I.type      AS table_type
        , O.type      AS index_type
        , 'clustered columnstore' AS index_type_name
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.indexes AS O
       ON T.object_id
        = O.object_id
      AND O.type = 5
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
 ORDER BY S.name
        , T.name
        , O.name

   SELECT S.name      AS GeneralSchema
        , T.name      AS GeneralObject
        , O.name      AS SQLServerName
        , I.type      AS table_type
        , O.type      AS index_type
        , 'nonclustered columnstore' AS index_type_name
        , MAX(CASE WHEN M.index_column_id =  1 THEN   '[' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  2 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  3 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  4 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  5 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  6 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  7 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  8 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id =  9 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 10 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 11 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 12 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 13 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 14 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 15 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 16 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 17 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 18 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id = 19 THEN ', [' + C.name + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN M.index_column_id > 19 THEN ', [...]'            ELSE SPACE(0) END) AS GeneralColumn
     FROM sys.schemas AS S
     JOIN sys.tables  AS T
       ON S.schema_id
        = T.schema_id
     JOIN sys.indexes AS I
       ON T.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.indexes AS O
       ON T.object_id
        = O.object_id
      AND O.type = 6
     JOIN sys.index_columns AS M
       ON O.object_id
        = M.object_id
      AND O.index_id
        = M.index_id
     JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND T.type IN ('U ')
 GROUP BY S.name
        , T.name
        , O.name
        , I.type
        , O.type
 ORDER BY S.name
        , T.name
        , O.name

SET NOCOUNT OFF

