/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @ForeignSchema varchar(0128) = '%' -- enter schema name here, use LIKE wildcards as necessary

DECLARE @ForeignObject varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary

IF OBJECT_ID('tempdb..#FKey', 'U ') IS NOT NULL DROP TABLE #FKey

IF OBJECT_ID('tempdb..#ZKey', 'U ') IS NOT NULL DROP TABLE #ZKey

IF OBJECT_ID('tempdb..#WKey', 'U ') IS NOT NULL DROP TABLE #WKey

IF OBJECT_ID('tempdb..#Task', 'U ') IS NOT NULL DROP TABLE #Task

   SELECT O.object_id AS ForeignID
        , W.object_id AS PrimaryID
        , O.name      AS ForeignObject
        , W.name      AS PrimaryObject
        , S.name      AS ForeignSchema
        , Z.name      AS PrimarySchema
        , F.name      AS SQLServerName
        , CONVERT(varchar(0040), F.create_date, 120) AS create_date
        , CONVERT(varchar(0040), F.modify_date, 120) AS modify_date
        , F.is_disabled
        , F.is_not_trusted
        , M.constraint_column_id
        , C.name      AS ForeignColumn
        , K.name      AS PrimaryColumn
        , F.delete_referential_action
        , F.delete_referential_action_desc
        , F.update_referential_action
        , F.update_referential_action_desc
     INTO #FKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.foreign_keys AS F
       ON        O.object_id
        = F.parent_object_id
     JOIN sys.foreign_key_columns AS M
       ON            F.object_id
        = M.constraint_object_id
     JOIN sys.columns AS C
       ON M.parent_object_id
        =        C.object_id
      AND M.parent_column_id
        =        C.column_id
     JOIN sys.columns AS K
       ON M.referenced_object_id
        =            K.object_id
      AND M.referenced_column_id
        =            K.column_id
     JOIN sys.objects AS W
       ON F.referenced_object_id
        =            W.object_id
--    AND            O.object_id
--     !=            W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
      AND Z.name IN (SELECT [Schema] FROM @Match)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   PrimarySchema
        ,   PrimaryObject
        ,   ForeignSchema
        ,   ForeignObject
        ,   constraint_column_id

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , I.is_unique
        , I.is_disabled
        , M.is_included_column
        , M.is_descending_key
        , M.partition_ordinal
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , CASE WHEN M.is_included_column  = 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY M.key_ordinal, M.index_column_id) ELSE 0 END AS regular_column_id
        , CASE WHEN M.is_included_column != 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY                M.index_column_id) ELSE 0 END AS include_column_id
        , ISNULL(I.filter_definition, SPACE(0)) AS GeneralFilter
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
     INTO #ZKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
LEFT JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName
        ,   index_column_id

   SELECT I.object_id
        , SUM(P.rows)    AS [Rows]
     INTO #WKey
     FROM sys.indexes    AS I
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
    WHERE I.type IN (0, 1, 5)
 GROUP BY I.object_id

   SELECT O.object_id AS ReferenceByID
        , O.type      AS ReferenceByType
        , O.name      AS ReferenceByObject
        , S.name      AS ReferenceBySchema
        , W.object_id AS ReferenceOfID
        , W.type      AS ReferenceOfType
        , W.name      AS ReferenceOfObject
        , Z.name      AS ReferenceOfSchema
     INTO #Task
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN
  (SELECT D.referencing_id AS ReferenceByID
        , D.referenced_id  AS ReferenceOfID
     FROM sys.sql_expression_dependencies AS D
    WHERE D.referencing_id
       != D.referenced_id
 GROUP BY D.referencing_id
        , D.referenced_id) AS K
       ON O.object_id
        = K.ReferenceByID
     JOIN sys.objects AS W
       ON K.ReferenceOfID
        = W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
      AND Z.name IN (SELECT [Schema] FROM @Match)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type NOT IN ('C ')
 ORDER BY   ReferenceByID
        ,   ReferenceOfID

   SELECT A.PrimarySchema
        , A.PrimaryObject
--      , A.SQLServerName
        , A.ForeignSchema
        , A.ForeignObject
        , A.ForeignColumn
        , (SELECT COUNT(*) FROM                 #Task AS E                                      WHERE                                   E.ReferenceOfID = A.PrimaryID) AS Uses_PSO
        , (SELECT COUNT(*) FROM #Task AS T                                                      WHERE T.ReferenceOfID = A.ForeignID                                  ) AS Uses_FSO
        , (SELECT COUNT(*) FROM #Task AS T JOIN #Task AS E ON T.ReferenceByID = E.ReferenceByID WHERE T.ReferenceOfID = A.ForeignID AND E.ReferenceOfID = A.PrimaryID) AS Uses_Both
        , X.[Rows] AS Rows_PSO
        , Y.[Rows] AS Rows_FSO
        , A.ON_DELETE
        , A.ON_UPDATE
        , U.SQLServerName
        , U.RegularColumn
        , CASE WHEN U.SQLServerName IS NULL THEN CASE WHEN A.is_disabled !=0 THEN '--' + SPACE(1) ELSE SPACE(3) END + 'CREATE NONCLUSTERED INDEX IX_DBA ON [' + A.ForeignSchema + '].[' + A.ForeignObject + '] (' + A.ForeignColumn + ')' ELSE SPACE(0) END AS CREATE_INDEX
     FROM
  (SELECT F.PrimaryID
        , F.PrimarySchema
        , F.PrimaryObject
        , F.SQLServerName
        , F.ForeignID
        , F.ForeignSchema
        , F.ForeignObject
        , MAX(CASE WHEN F.constraint_column_id = 1 THEN   '[' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 2 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 3 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 4 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 5 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 6 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 7 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 8 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id = 9 THEN ', [' + F.ForeignColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN F.constraint_column_id > 9 THEN ', [...]'                     ELSE SPACE(0) END) AS ForeignColumn
        , CASE WHEN F.delete_referential_action = 0 THEN SPACE(0) ELSE F.delete_referential_action_desc END  AS ON_DELETE
        , CASE WHEN F.update_referential_action = 0 THEN SPACE(0) ELSE F.update_referential_action_desc END  AS ON_UPDATE
        , F.is_disabled
     FROM #FKey AS F
    WHERE F.SQLServerName LIKE '%'
      AND F.ForeignSchema LIKE @ForeignSchema
      AND F.ForeignObject LIKE @ForeignObject
 GROUP BY F.PrimaryID
        , F.PrimarySchema
        , F.PrimaryObject
        , F.SQLServerName
        , F.ForeignID
        , F.ForeignSchema
        , F.ForeignObject
        , F.delete_referential_action
        , F.delete_referential_action_desc
        , F.update_referential_action
        , F.update_referential_action_desc
        , F.is_disabled) AS A
LEFT JOIN
  (SELECT Z.GeneralID
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerName
        , MAX(CASE WHEN Z.regular_column_id = 1 THEN   '[' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 2 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 3 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 4 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 5 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 6 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 7 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 8 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 9 THEN ', [' + Z.GeneralColumn + ']' ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id > 9 THEN ', [...]'                     ELSE SPACE(0) END) AS RegularColumn
     FROM #ZKey AS Z
    WHERE Z.GeneralFilter = SPACE(0)
 GROUP BY Z.GeneralID
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerName) AS U
       ON A.ForeignID
        = U.GeneralID
      AND REPLACE(REPLACE(U.RegularColumn, '[', '<'), ']', '>')
     LIKE REPLACE(REPLACE(A.ForeignColumn, '[', '<'), ']', '>') + '%'
     JOIN #WKey AS X
       ON A.PrimaryID
        = X.object_id
     JOIN #WKey AS Y
       ON A.ForeignID
        = Y.object_id
--  WHERE U.SQLServerName IS NULL -- filters out foreign keys with supporting indexes
 ORDER BY A.ForeignSchema
        , A.ForeignObject
        , A.ForeignColumn
        , U.RegularColumn DESC

DROP TABLE #FKey

DROP TABLE #ZKey

DROP TABLE #WKey

DROP TABLE #Task

SET NOCOUNT OFF

