/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


IF EXISTS (SELECT * FROM sys.triggers WHERE name = 'DatabaseActivity') DROP TRIGGER DatabaseActivity ON DATABASE
GO
CREATE TRIGGER DatabaseActivity ON DATABASE FOR DDL_DATABASE_LEVEL_EVENTS
AS

SET NOCOUNT ON

DECLARE @XML xml = EVENTDATA()

DECLARE @DBUser   varchar(0128) = @XML.value('(/EVENT_INSTANCE/LoginName)[1]', 'varchar(0128)')

DECLARE @DBHost   varchar(0128) = HOST_NAME()

DECLARE @DBTool   varchar(0128) = APP_NAME()

DECLARE @DBTime   varchar(0100) = CONVERT(varchar(0100), GETDATE(), 121)

DECLARE @DBWork   varchar(0100) = @XML.value('(/EVENT_INSTANCE/EventType)[1]', 'varchar(0100)')

DECLARE @DBCode   varchar(4000)

DECLARE @DBName   varchar(0128)

DECLARE @DBSchema varchar(0128)

DECLARE @DBObject varchar(0128)

IF @DBWork LIKE 'CREATE%'
OR @DBWork LIKE 'ALTER%'
OR @DBWork LIKE 'DROP%'

    BEGIN

    SET @DBCode   = NULL

    SET @DBName   = @XML.value('(/EVENT_INSTANCE/DatabaseName)[1]', 'varchar(0128)')

    SET @DBSchema = @XML.value('(/EVENT_INSTANCE/SchemaName)[1]'  , 'varchar(0128)')

    SET @DBObject = @XML.value('(/EVENT_INSTANCE/ObjectName)[1]'  , 'varchar(0128)')

       INSERT Monitor.dbo.DDLActivity -- change the database name here
            ( IsDone
            , DBUser
            , DBHost
            , DBTool
            , DBTime
            , DBWork
            , DBCode
            , DBName
            , DBSchema
            , DBObject )
       SELECT 0
            , @DBUser
            , @DBHost
            , @DBTool
            , @DBTime
            , @DBWork
            , @DBCode
            , @DBName
            , @DBSchema
            , @DBObject

    END

SET NOCOUNT OFF

GO

