/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


USE Monitor -- change the database name here, it's also embedded below
GO

IF OBJECT_ID('dbo.DDLActivity', 'U ') IS NOT NULL DROP TABLE dbo.DDLActivity
GO
CREATE TABLE dbo.DDLActivity
     ( MainID              int NOT NULL IDENTITY(1,1)
     , IsDone              bit NOT NULL
     , DBUser    varchar(0128)     NULL
     , DBHost    varchar(0128)     NULL
     , DBTool    varchar(0128)     NULL
     , DBTime    varchar(0100) NOT NULL
     , DBWork    varchar(0100) NOT NULL
     , DBCode    varchar(4000)     NULL
     , DBName    varchar(0128)     NULL
     , DBSchema  varchar(0128)     NULL
     , DBObject  varchar(0128)     NULL )
GO
ALTER TABLE dbo.DDLActivity ADD CONSTRAINT PK_DDLActivity PRIMARY KEY CLUSTERED (MainID)
GO
CREATE NONCLUSTERED INDEX IX_DBTime ON dbo.DDLActivity (DBTime) INCLUDE (IsDone)
GO

IF OBJECT_ID('dbo.ViewActivity', 'P ') IS NOT NULL DROP PROCEDURE dbo.ViewActivity
GO
CREATE PROCEDURE dbo.ViewActivity
       @DaysHistory int = 90
AS

SET NOCOUNT ON

   SELECT A.DBName
        , A.DBSchema
        , A.DBObject
        , A.DBWork
        , A.DBCode
        , A.DBTime
        , A.DBUser
        , A.DBHost
        , A.DBTool
        , A.IsDone
     FROM dbo.DDLActivity AS A
    WHERE A.DBTime > CONVERT(varchar(0100), DATEADD(day, 0 - @DaysHistory, GETDATE()), 121)
 ORDER BY A.DBName
        , A.DBSchema
        , A.DBObject
        , A.MainID

SET NOCOUNT OFF

RETURN (0)

GO

IF OBJECT_ID('dbo.SendActivityMessages', 'P ') IS NOT NULL DROP PROCEDURE dbo.SendActivityMessages
GO
CREATE PROCEDURE dbo.SendActivityMessages
AS

SET NOCOUNT ON

DECLARE @Message  varchar(4000)

DECLARE @DBUser   varchar(0128)
DECLARE @DBHost   varchar(0128)
DECLARE @DBTool   varchar(0128)
DECLARE @DBTime   varchar(0100)
DECLARE @DBWork   varchar(0100)
DECLARE @DBCode   varchar(4000)
DECLARE @DBName   varchar(0128)
DECLARE @DBSchema varchar(0128)
DECLARE @DBObject varchar(0128)

   SELECT A.*
     INTO #TEMP
     FROM dbo.DDLActivity AS A
    WHERE A.DBTime > CONVERT(varchar(0100), DATEADD(day, -14, GETDATE()), 121)
      AND A.IsDone = 0

BEGIN TRY

  DECLARE Messages CURSOR FAST_FORWARD FOR
   SELECT T.DBUser
        , T.DBHost
        , T.DBTool
        , T.DBTime
        , T.DBWork
        , T.DBCode
        , T.DBName
        , T.DBSchema
        , T.DBObject
     FROM #TEMP AS T
 ORDER BY T.MainID

OPEN Messages

FETCH NEXT FROM Messages INTO @DBUser, @DBHost, @DBTool, @DBTime, @DBWork, @DBCode, @DBName, @DBSchema, @DBObject

WHILE @@FETCH_STATUS = 0

    BEGIN

    SET @Message =                       CASE WHEN @DBName   IS NULL THEN '-' ELSE @DBName   END
                 + CHAR(13) + CHAR(10) + CASE WHEN @DBSchema IS NULL THEN '-' ELSE @DBSchema END
                 + CHAR(13) + CHAR(10) + CASE WHEN @DBObject IS NULL THEN '-' ELSE @DBObject END
                 + CHAR(13) + CHAR(10) +                                           @DBWork
                 + CHAR(13) + CHAR(10) +                                           @DBTime
                 + CHAR(13) + CHAR(10) +                                           @DBUser
                 + CHAR(13) + CHAR(10) +                                           @DBHost
                 + CHAR(13) + CHAR(10) +                                           @DBTool
                 + CASE WHEN @DBCode IS NULL THEN SPACE(0) ELSE CHAR(13) + CHAR(10) + CHAR(13) + CHAR(10) + @DBCode END

    EXECUTE msdb.dbo.sp_send_dbmail 'Wingenious', 'alerts@wingenious.com', NULL, NULL, 'DDL Activity Alerts', @Message -- change the profile name and the recipient list

    FETCH NEXT FROM Messages INTO @DBUser, @DBHost, @DBTool, @DBTime, @DBWork, @DBCode, @DBName, @DBSchema, @DBObject

    END

CLOSE Messages DEALLOCATE Messages

   UPDATE dbo.DDLActivity SET IsDone = 1
     FROM dbo.DDLActivity AS A
     JOIN #TEMP AS T
       ON A.MainID
        = T.MainID

END TRY

BEGIN CATCH

SET @DBUser   = SYSTEM_USER -- SUSER_SNAME(), USER_NAME()
SET @DBHost   = HOST_NAME()
SET @DBTool   = APP_NAME()
SET @DBTime   = CONVERT(varchar(0100), GETDATE(), 121)
SET @DBWork   = SPACE(0)
SET @DBCode   = ERROR_MESSAGE()
SET @DBName   = DB_NAME()
SET @DBSchema = OBJECT_SCHEMA_NAME(@@PROCID, DB_ID())
SET @DBObject =        OBJECT_NAME(@@PROCID, DB_ID())

   INSERT dbo.DDLActivity
        ( IsDone
        , DBUser
        , DBHost
        , DBTool
        , DBTime
        , DBWork
        , DBCode
        , DBName
        , DBSchema
        , DBObject )
   SELECT 0
        , @DBUser
        , @DBHost
        , @DBTool
        , @DBTime
        , @DBWork
        , @DBCode
        , @DBName
        , @DBSchema
        , @DBObject

END CATCH

DROP TABLE #TEMP

SET NOCOUNT OFF

RETURN (0)

GO

IF EXISTS (SELECT * FROM sys.server_triggers WHERE name = 'ServerActivity') DROP TRIGGER ServerActivity ON ALL SERVER
GO
CREATE TRIGGER ServerActivity ON ALL SERVER FOR DDL_SERVER_LEVEL_EVENTS
AS

SET NOCOUNT ON

DECLARE @XML xml = EVENTDATA()

DECLARE @DBUser   varchar(0128) = @XML.value('(/EVENT_INSTANCE/LoginName)[1]', 'varchar(0128)')

DECLARE @DBHost   varchar(0128) = HOST_NAME()

DECLARE @DBTool   varchar(0128) = APP_NAME()

DECLARE @DBTime   varchar(0100) = CONVERT(varchar(0100), GETDATE(), 121)

DECLARE @DBWork   varchar(0100) = @XML.value('(/EVENT_INSTANCE/EventType)[1]', 'varchar(0100)')

DECLARE @DBCode   varchar(4000)

DECLARE @DBName   varchar(0128)

DECLARE @DBSchema varchar(0128)

DECLARE @DBObject varchar(0128)

IF @DBWork LIKE 'CREATE%'
OR @DBWork LIKE 'ALTER%'
OR @DBWork LIKE 'DROP%'

    BEGIN

    SET @DBCode   = @XML.value('(/EVENT_INSTANCE/TSQLCommand/CommandText)[1]', 'varchar(4000)')

    SET @DBName   = NULL

    SET @DBSchema = NULL

    SET @DBObject = NULL

       INSERT Monitor.dbo.DDLActivity -- change the database name here
            ( IsDone
            , DBUser
            , DBHost
            , DBTool
            , DBTime
            , DBWork
            , DBCode
            , DBName
            , DBSchema
            , DBObject )
       SELECT 0
            , @DBUser
            , @DBHost
            , @DBTool
            , @DBTime
            , @DBWork
            , @DBCode
            , @DBName
            , @DBSchema
            , @DBObject

    END

SET NOCOUNT OFF

GO

