/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


USE Monitor -- change the database name here, it's also embedded below
GO

IF OBJECT_ID('dbo.SPErrorLog', 'U ') IS NOT NULL DROP TABLE dbo.SPErrorLog
GO
CREATE TABLE dbo.SPErrorLog
     ( SPErrorLogID             int NOT NULL IDENTITY(1,1)
     , FromDateTime        datetime NOT NULL
     , ThruDateTime        datetime NOT NULL
     , DBUser         varchar(0128)     NULL
     , DBHost         varchar(0128)     NULL
     , DBTool         varchar(0128)     NULL
     , DBName         varchar(0128) NOT NULL
     , DBSchema       varchar(0128) NOT NULL
     , DBObject       varchar(0128) NOT NULL
     , SPLine                   int NOT NULL
     , SPCode                   int NOT NULL
     , Detail         varchar(2000)     NULL )
GO
ALTER TABLE dbo.SPErrorLog ADD CONSTRAINT PK_SPErrorLog PRIMARY KEY CLUSTERED (SPErrorLogID)
GO
CREATE NONCLUSTERED INDEX IX_FromDateTime ON dbo.SPErrorLog (FromDateTime) INCLUDE (SPCode)
GO

IF OBJECT_ID('dbo.ViewSPErrorLog', 'P ') IS NOT NULL DROP PROCEDURE dbo.ViewSPErrorLog
GO
CREATE PROCEDURE dbo.ViewSPErrorLog
       @DaysHistory int = 90
AS

SET NOCOUNT ON

   SELECT E.DBName
        , E.DBSchema
        , E.DBObject
        , E.SPLine
        , E.SPCode
        , E.Detail
        , CONVERT(varchar(0100), E.FromDateTime, 121) AS FromDateTime
        , CONVERT(varchar(0100), E.ThruDateTime, 121) AS ThruDateTime
        , E.DBUser
        , E.DBHost
        , E.DBTool
     FROM dbo.SPErrorLog AS E
    WHERE E.FromDateTime > DATEADD(day, 0 - @DaysHistory, GETDATE())
 ORDER BY E.DBName
        , E.DBSchema
        , E.DBObject
        , E.SPErrorLogID

SET NOCOUNT OFF

RETURN (0)

GO

IF OBJECT_ID('dbo.RecordSPError', 'P ') IS NOT NULL DROP PROCEDURE dbo.RecordSPError
GO
CREATE PROCEDURE dbo.RecordSPError
       @FromDateTime       datetime
     , @ThruDateTime       datetime
     , @DBName        varchar(0128)
     , @DBSchema      varchar(0128)
     , @DBObject      varchar(0128)
     , @SPLine                  int
     , @SPCode                  int
     , @Detail        varchar(2000)
AS

SET NOCOUNT ON

BEGIN TRY

   INSERT dbo.SPErrorLog
        ( FromDateTime
        , ThruDateTime
        , DBUser
        , DBHost
        , DBTool
        , DBName
        , DBSchema
        , DBObject
        , SPLine
        , SPCode
        , Detail )
   SELECT @FromDateTime
        , @ThruDateTime
        , SYSTEM_USER -- SUSER_SNAME(), USER_NAME()
        , HOST_NAME()
        , APP_NAME()
        , @DBName
        , @DBSchema
        , @DBObject
        , @SPLine
        , @SPCode
        , @Detail

END TRY

BEGIN CATCH

RAISERROR ('The database is not accessible!', 16, 1)

END CATCH

SET NOCOUNT OFF

RETURN (0)

GO

IF OBJECT_ID('dbo.SPModel', 'P ') IS NOT NULL DROP PROCEDURE dbo.SPModel
GO
CREATE PROCEDURE dbo.SPModel
AS

SET NOCOUNT ON

SET XACT_ABORT ON

DECLARE @FromDateTime      datetime = GETDATE()
DECLARE @ThruDateTime      datetime
DECLARE @DBName       varchar(0128) = DB_NAME()
DECLARE @DBSchema     varchar(0128) = OBJECT_SCHEMA_NAME(@@PROCID, DB_ID())
DECLARE @DBObject     varchar(0128) =        OBJECT_NAME(@@PROCID, DB_ID())
DECLARE @SPLine                 int = 0
DECLARE @SPCode                 int = 0
DECLARE @Detail       varchar(4000) = SPACE(0)

BEGIN TRY

SELECT 0 / 1 AS Beauty -- preparation code goes here

BEGIN TRANSACTION

SELECT 1 / 0 AS Bummer -- transaction code goes here

COMMIT TRANSACTION

SET @ThruDateTime = GETDATE()

EXECUTE Monitor.dbo.RecordSPError @FromDateTime, @ThruDateTime, @DBName, @DBSchema, @DBObject, @SPLine, @SPCode, @Detail -- change the database name here

-- The line above can be used to record all executions for the SP, which is not recommended for extremely active SPs.

END TRY

BEGIN CATCH

IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION

SET @SPLine = ERROR_LINE()
SET @SPCode = ERROR_NUMBER()
SET @Detail = ERROR_MESSAGE()

IF LEFT(@Detail, 3) != '>>>'

    BEGIN

    SET @ThruDateTime = GETDATE()

    EXECUTE Monitor.dbo.RecordSPError @FromDateTime, @ThruDateTime, @DBName, @DBSchema, @DBObject, @SPLine, @SPCode, @Detail -- change the database name here

    SET @Detail = '>>> '     + CONVERT(varchar(40), @ThruDateTime, 120)
                + ' / '      + @DBName + '.' + @DBSchema + '.' + @DBObject
                + ' / Line ' + CONVERT(varchar(10), @SPLine)
                + ' / Code ' + CONVERT(varchar(10), @SPCode)
                + ' / '      + @Detail

    END

RAISERROR (@Detail, 16, 1) WITH NOWAIT

END CATCH

SET NOCOUNT OFF

RETURN (@SPCode)

GO
-- EXECUTE dbo.SPModel
GO
-- EXECUTE Monitor.dbo.ViewSPErrorLog -- change the database name here
GO

