/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


-- Block 1 (hide execution plans), initialization

IF OBJECT_ID('dbo.Demo', 'U ') IS NOT NULL DROP TABLE dbo.Demo
GO

CREATE TABLE dbo.Demo (DemoID int IDENTITY(1,1), DemoFKey int, DemoType smallint, DemoValue1 int, DemoValue2 int, DemoValue3 int, DemoString varchar(0010))

ALTER TABLE dbo.Demo ADD CONSTRAINT PK_Demo PRIMARY KEY CLUSTERED (DemoID)

DECLARE @I smallint

SET NOCOUNT ON

SET @I = 0; WHILE @I < 1000 BEGIN INSERT dbo.Demo (DemoFKey, DemoType, DemoString) SELECT @I       , 0, REPLICATE('-', 10); SET @I = @I + 1; END
SET @I = 0; WHILE @I <  500 BEGIN INSERT dbo.Demo (DemoFKey, DemoType, DemoString) SELECT      1000, 1, REPLICATE('-', 10); SET @I = @I + 1; END
SET @I = 0; WHILE @I <  500 BEGIN INSERT dbo.Demo (DemoFKey, DemoType, DemoString) SELECT      5000, 0, REPLICATE('-', 10); SET @I = @I + 1; END
SET @I = 0; WHILE @I < 1000 BEGIN INSERT dbo.Demo (DemoFKey, DemoType, DemoString) SELECT @I + 9000, 1, REPLICATE('-', 10); SET @I = @I + 1; END

SET NOCOUNT OFF

CREATE NONCLUSTERED INDEX IX_DemoFKey ON dbo.Demo (DemoFKey)

GO

-- Block 2 (show execution plans), see specific execution plans

SELECT DemoID, DemoType FROM dbo.Demo WHERE DemoFKey =    0 -- see plan generated expecting a small number of rows, plan is an index seek with key lookup
SELECT DemoID, DemoType FROM dbo.Demo WHERE DemoFKey = 1000 -- see plan generated expecting a large number of rows, plan is a clustered index scan
SELECT DemoID, DemoType FROM dbo.Demo WHERE DemoFKey = 5000 -- see plan generated expecting a large number of rows, plan is a clustered index scan
SELECT DemoID, DemoType FROM dbo.Demo WHERE DemoFKey = 9000 -- see plan generated expecting a small number of rows, plan is an index seek with key lookup

GO

-- Block 3 (show execution plans), see plan generated expecting a small number of rows, plan is cached and used repeatedly

IF OBJECT_ID('dbo.GetDemo', 'P ') IS NOT NULL DROP PROCEDURE dbo.GetDemo
GO

CREATE PROCEDURE dbo.GetDemo
       @DemoFKey int
AS

   SELECT D.DemoID
        , D.DemoType
     FROM dbo.Demo AS D
    WHERE D.DemoFKey
        =  @DemoFKey

GO

EXECUTE dbo.GetDemo    0 -- plan is an index seek with key lookup
EXECUTE dbo.GetDemo 9000 -- plan is an index seek with key lookup

EXECUTE dbo.GetDemo 1000 -- plan is an index seek with key lookup
EXECUTE dbo.GetDemo 5000 -- plan is an index seek with key lookup

GO

-- Block 4 (show execution plans), see plan generated expecting a large number of rows, plan is cached and used repeatedly

IF OBJECT_ID('dbo.GetDemo', 'P ') IS NOT NULL DROP PROCEDURE dbo.GetDemo
GO

CREATE PROCEDURE dbo.GetDemo
       @DemoFKey int
AS

   SELECT D.DemoID
        , D.DemoType
     FROM dbo.Demo AS D
    WHERE D.DemoFKey
        =  @DemoFKey

GO

EXECUTE dbo.GetDemo 1000 -- plan is a clustered index scan
EXECUTE dbo.GetDemo 5000 -- plan is a clustered index scan

EXECUTE dbo.GetDemo    0 -- plan is a clustered index scan
EXECUTE dbo.GetDemo 9000 -- plan is a clustered index scan

GO

-- Block 5 (show execution plans), create covering index by adding an INCLUDE clause

-- run the INCLUDE tool to see how it suggests the index change below

DROP                INDEX IX_DemoFKey ON dbo.Demo

CREATE NONCLUSTERED INDEX IX_DemoFKey ON dbo.Demo (DemoFKey) INCLUDE (DemoType)

GO

-- Block 6 (show execution plans), see plan generated expecting a small number of rows, plan is cached and used repeatedly

IF OBJECT_ID('dbo.GetDemo', 'P ') IS NOT NULL DROP PROCEDURE dbo.GetDemo
GO

CREATE PROCEDURE dbo.GetDemo
       @DemoFKey int
AS

   SELECT D.DemoID
        , D.DemoType
     FROM dbo.Demo AS D
    WHERE D.DemoFKey
        =  @DemoFKey

GO

EXECUTE dbo.GetDemo    0 -- plan is an index seek
EXECUTE dbo.GetDemo 9000 -- plan is an index seek

EXECUTE dbo.GetDemo 1000 -- plan is an index seek
EXECUTE dbo.GetDemo 5000 -- plan is an index seek

GO

-- Block 7 (show execution plans), see plan generated expecting a large number of rows, plan is cached and used repeatedly

IF OBJECT_ID('dbo.GetDemo', 'P ') IS NOT NULL DROP PROCEDURE dbo.GetDemo
GO

CREATE PROCEDURE dbo.GetDemo
       @DemoFKey int
AS

   SELECT D.DemoID
        , D.DemoType
     FROM dbo.Demo AS D
    WHERE D.DemoFKey
        =  @DemoFKey

GO

EXECUTE dbo.GetDemo 1000 -- plan is an index seek (same plan as previous block)
EXECUTE dbo.GetDemo 5000 -- plan is an index seek (same plan as previous block)

EXECUTE dbo.GetDemo    0 -- plan is an index seek (same plan as previous block)
EXECUTE dbo.GetDemo 9000 -- plan is an index seek (same plan as previous block)

GO

