/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Seconds_SUM decimal(19,05) = 0 -- minimum time for Seconds_SUM

DECLARE @CPU_time bit = 1
--      @CPU_time     = 0 means Seconds are run time
--      @CPU_time     = 1 means Seconds are CPU time

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

DECLARE @WT TABLE (RowID smallint NOT NULL, RangeFrom bigint  , RangeThru bigint  , Executions int, Seconds int, Reads int)

DECLARE @XT TABLE (RowID smallint NOT NULL, RangeFrom datetime, RangeThru datetime, Creation int, Last_Run int)
DECLARE @YT TABLE (RowID smallint NOT NULL, RangeFrom datetime, RangeThru datetime, Creation int, Last_Run int)
DECLARE @ZT TABLE (RowID smallint NOT NULL, RangeFrom datetime, RangeThru datetime, Creation int, Last_Run int)

DECLARE @BV datetime= CONVERT(datetime, '1900/01/01')

DECLARE @DV datetime = GETDATE()

DECLARE @XV datetime = DATEADD(day   , DATEDIFF(day   , @BV, @DV), @BV)

DECLARE @YV datetime = DATEADD(hour  , DATEDIFF(hour  , @BV, @DV), @BV)

DECLARE @ZV datetime = DATEADD(minute, DATEDIFF(minute, @BV, @DV), @BV)

DECLARE @ZN int

IF OBJECT_ID('tempdb..#Action', 'U ') IS NOT NULL DROP TABLE #Action

INSERT @WT SELECT  0,               0,               9, 0, 0, 0
INSERT @WT SELECT  1,              10,              99, 0, 0, 0
INSERT @WT SELECT  2,             100,             999, 0, 0, 0
INSERT @WT SELECT  3,            1000,            9999, 0, 0, 0
INSERT @WT SELECT  4,           10000,           99999, 0, 0, 0
INSERT @WT SELECT  5,          100000,          999999, 0, 0, 0
INSERT @WT SELECT  6,         1000000,         9999999, 0, 0, 0
INSERT @WT SELECT  7,        10000000,        99999999, 0, 0, 0
INSERT @WT SELECT  8,       100000000,       999999999, 0, 0, 0
INSERT @WT SELECT  9,      1000000000,      9999999999, 0, 0, 0
INSERT @WT SELECT 10,     10000000000,     99999999999, 0, 0, 0
INSERT @WT SELECT 11,    100000000000,    999999999999, 0, 0, 0
INSERT @WT SELECT 12,   1000000000000,   9999999999999, 0, 0, 0
INSERT @WT SELECT 13,  10000000000000,  99999999999999, 0, 0, 0
INSERT @WT SELECT 14, 100000000000000, 999999999999999, 0, 0, 0

INSERT @XT (RowID) VALUES (00), (01), (02), (03), (04), (05), (06), (07), (08), (09)
                        , (10), (11), (12), (13), (14), (15), (16), (17), (18), (19)
                        , (20), (21), (22), (23), (24), (25), (26), (27), (28), (29)
                        , (30), (31), (32), (33), (34), (35), (36), (37), (38), (39)
                        , (40), (41), (42), (43), (44), (45), (46), (47), (48), (49)
                        , (50), (51), (52), (53), (54), (55), (56), (57), (58), (59), (60)

INSERT @YT (RowID) VALUES (00), (01), (02), (03), (04), (05), (06), (07), (08), (09)
                        , (10), (11), (12), (13), (14), (15), (16), (17), (18), (19)
                        , (20), (21), (22), (23), (24), (25), (26), (27), (28), (29)
                        , (30), (31), (32), (33), (34), (35), (36), (37), (38), (39)
                        , (40), (41), (42), (43), (44), (45), (46), (47), (48), (49)
                        , (50), (51), (52), (53), (54), (55), (56), (57), (58), (59), (60)

INSERT @ZT (RowID) VALUES (00), (01), (02), (03), (04), (05), (06), (07), (08), (09)
                        , (10), (11), (12), (13), (14), (15), (16), (17), (18), (19)
                        , (20), (21), (22), (23), (24), (25), (26), (27), (28), (29)
                        , (30), (31), (32), (33), (34), (35), (36), (37), (38), (39)
                        , (40), (41), (42), (43), (44), (45), (46), (47), (48), (49)
                        , (50), (51), (52), (53), (54), (55), (56), (57), (58), (59), (60)

   UPDATE @XT SET
          RangeFrom =                                    DATEADD(day   , -T.RowID, @XV)
        , RangeThru = DATEADD(ms, -3, DATEADD(day   , 1, DATEADD(day   , -T.RowID, @XV)))
     FROM @XT AS T

   UPDATE @YT SET
          RangeFrom =                                    DATEADD(hour  , -T.RowID, @YV)
        , RangeThru = DATEADD(ms, -3, DATEADD(hour  , 1, DATEADD(hour  , -T.RowID, @YV)))
     FROM @YT AS T

   UPDATE @ZT SET
          RangeFrom =                                    DATEADD(minute, -T.RowID, @ZV)
        , RangeThru = DATEADD(ms, -3, DATEADD(minute, 1, DATEADD(minute, -T.RowID, @ZV)))
     FROM @ZT AS T

   UPDATE @XT SET RangeFrom = @BV WHERE RowID = 60
   UPDATE @YT SET RangeFrom = @BV WHERE RowID = 60
   UPDATE @ZT SET RangeFrom = @BV WHERE RowID = 60

   UPDATE @XT SET Creation = 0, Last_Run = 0
   UPDATE @YT SET Creation = 0, Last_Run = 0
   UPDATE @ZT SET Creation = 0, Last_Run = 0

-- SELECT @XV, @YV, @ZV

   SELECT     S.execution_count
        ,         S.cached_time
        , S.last_execution_time
        ,   S.total_worker_time
        ,  S.total_elapsed_time
        , S.total_logical_reads
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0) AS  Seconds_SUM
        ,            DB_NAME(             S.database_id) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(S.object_id, S.database_id) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(S.object_id, S.database_id) COLLATE database_default AS ObjectName
        ,                       ISNULL(S.type, SPACE(2)) COLLATE database_default AS ObjectType
     INTO #Action
     FROM sys.dm_exec_procedure_stats AS S
    WHERE DB_NAME(S.database_id) NOT IN ('tempdb', 'msdb', 'master')
      AND S.type IN ('P ')
      AND CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0) !< @Seconds_SUM

SET @ZN = @@ROWCOUNT

-- Executions

   UPDATE @WT SET Executions = T.Executions + O.MyCOUNT
     FROM @WT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @WT AS I
     JOIN #Action  AS A
       ON A.execution_count       BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- Seconds

   UPDATE @WT SET Seconds = T.Seconds + O.MyCOUNT
     FROM @WT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @WT AS I
     JOIN #Action  AS A
       ON ROUND(A.Seconds_SUM, 0) BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- Reads

   UPDATE @WT SET Reads = T.Reads + O.MyCOUNT
     FROM @WT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @WT AS I
     JOIN #Action  AS A
       ON A.total_logical_reads   BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- creation by day

   UPDATE @XT SET Creation = T.Creation + O.MyCOUNT
     FROM @XT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @XT AS I
     JOIN #Action  AS A
       ON A.cached_time BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- creation by hour

   UPDATE @YT SET Creation = T.Creation + O.MyCOUNT
     FROM @YT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @YT AS I
     JOIN #Action  AS A
       ON A.cached_time BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- creation by minute

   UPDATE @ZT SET Creation = T.Creation + O.MyCOUNT
     FROM @ZT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @ZT AS I
     JOIN #Action  AS A
       ON A.cached_time BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- last_run by day

   UPDATE @XT SET Last_Run = T.Last_Run + O.MyCOUNT
     FROM @XT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @XT AS I
     JOIN #Action  AS A
       ON A.last_execution_time BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- last_run by hour

   UPDATE @YT SET Last_Run = T.Last_Run + O.MyCOUNT
     FROM @YT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @YT AS I
     JOIN #Action  AS A
       ON A.last_execution_time BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- last_run by minute

   UPDATE @ZT SET Last_Run = T.Last_Run + O.MyCOUNT
     FROM @ZT AS T
     JOIN
  (SELECT I.RowID
        , COUNT(*) AS MyCOUNT
     FROM @ZT AS I
     JOIN #Action  AS A
       ON A.last_execution_time BETWEEN I.RangeFrom AND I.RangeThru
 GROUP BY I.RowID) AS O
       ON T.RowID
        = O.RowID

-- results

   SELECT CASE WHEN T.RowID < 60 THEN 'day'    ELSE SPACE(0) END AS SPAN
        , CONVERT(varchar(0040), T.RangeFrom, 120) AS DateTimeFrom
        , CONVERT(varchar(0040), T.RangeThru, 120) AS DateTimeThru
        , T.Creation AS Tally_Creation
        , T.Last_Run AS Tally_Last_Run
        , CONVERT(decimal(05,02), T.Creation * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Creation
        , CONVERT(decimal(05,02), T.Last_Run * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Last_Run
     FROM @XT AS T
 ORDER BY T.RowID

   SELECT CASE WHEN T.RowID < 60 THEN 'hour'   ELSE SPACE(0) END AS SPAN
        , CONVERT(varchar(0040), T.RangeFrom, 120) AS DateTimeFrom
        , CONVERT(varchar(0040), T.RangeThru, 120) AS DateTimeThru
        , T.Creation AS Tally_Creation
        , T.Last_Run AS Tally_Last_Run
        , CONVERT(decimal(05,02), T.Creation * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Creation
        , CONVERT(decimal(05,02), T.Last_Run * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Last_Run
     FROM @YT AS T
 ORDER BY T.RowID

   SELECT CASE WHEN T.RowID < 60 THEN 'minute' ELSE SPACE(0) END AS SPAN
        , CONVERT(varchar(0040), T.RangeFrom, 120) AS DateTimeFrom
        , CONVERT(varchar(0040), T.RangeThru, 120) AS DateTimeThru
        , T.Creation AS Tally_Creation
        , T.Last_Run AS Tally_Last_Run
        , CONVERT(decimal(05,02), T.Creation * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Creation
        , CONVERT(decimal(05,02), T.Last_Run * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Last_Run
     FROM @ZT AS T
 ORDER BY T.RowID

   SELECT 'decimal' AS SPAN
        , CONVERT(varchar(0020), T.RangeFrom) AS NumberFrom
        , CONVERT(varchar(0020), T.RangeThru) AS NumberThru
        ,                         T.Executions                                                  AS   Tally_Executions
        ,                         T.Seconds                                                     AS   Tally_Seconds
        ,                         T.Reads                                                       AS   Tally_Reads
        , CONVERT(decimal(05,02), T.Executions * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Executions
        , CONVERT(decimal(05,02), T.Seconds    * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Seconds
        , CONVERT(decimal(05,02), T.Reads      * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Reads
     FROM @WT AS T
 ORDER BY T.RowID

   SELECT                         COUNT(*)                                                  AS   Tally_Plans
        , CONVERT(decimal(05,02), COUNT(*) * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Plans
        , MIN(E.Creation) AS MIN_Creation
        , MAX(E.Creation) AS MAX_Creation
        , MIN(E.Last_Run) AS MIN_Last_Run
        , MAX(E.Last_Run) AS MAX_Last_Run
        , E.DBName
        , E.SchemaName
     FROM
  (SELECT A.execution_count                                   AS Executions
        , CONVERT(varchar(0040) ,         A.cached_time, 120) AS Creation
        , CONVERT(varchar(0040) , A.last_execution_time, 120) AS Last_Run
        , A.DBName
        , A.SchemaName
        , A.ObjectName
        , A.ObjectType
     FROM #Action AS A) AS E
 GROUP BY E.DBName
        , E.SchemaName
 ORDER BY E.DBName
        , E.SchemaName

   SELECT                         COUNT(*)                                                  AS   Tally_Plans
        , CONVERT(decimal(05,02), COUNT(*) * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Plans
        , MIN(E.Creation) AS MIN_Creation
        , MAX(E.Creation) AS MAX_Creation
        , MIN(E.Last_Run) AS MIN_Last_Run
        , MAX(E.Last_Run) AS MAX_Last_Run
        , E.DBName
     FROM
  (SELECT A.execution_count                                   AS Executions
        , CONVERT(varchar(0040) ,         A.cached_time, 120) AS Creation
        , CONVERT(varchar(0040) , A.last_execution_time, 120) AS Last_Run
        , A.DBName
        , A.SchemaName
        , A.ObjectName
        , A.ObjectType
     FROM #Action AS A) AS E
 GROUP BY E.DBName
 ORDER BY E.DBName

   SELECT                         COUNT(*)                                                  AS   Tally_Plans
        , CONVERT(decimal(05,02), COUNT(*) * 100.0 / CASE WHEN @ZN = 0 THEN 1 ELSE @ZN END) AS Percent_Plans
        , MIN(E.Creation) AS MIN_Creation
        , MAX(E.Creation) AS MAX_Creation
        , MIN(E.Last_Run) AS MIN_Last_Run
        , MAX(E.Last_Run) AS MAX_Last_Run
     FROM
  (SELECT A.execution_count                                   AS Executions
        , CONVERT(varchar(0040) ,         A.cached_time, 120) AS Creation
        , CONVERT(varchar(0040) , A.last_execution_time, 120) AS Last_Run
        , A.DBName
        , A.SchemaName
        , A.ObjectName
        , A.ObjectType
     FROM #Action AS A) AS E

DROP TABLE #Action

SET NOCOUNT OFF

