/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Seconds_SUM decimal(19,05) = 60 -- minimum time for Seconds_SUM

DECLARE @CPU_time bit = 1
--      @CPU_time     = 0 means Seconds are run time
--      @CPU_time     = 1 means Seconds are CPU time

DECLARE @DBName varchar(0128) = '%' -- enter database name here, use LIKE wildcards as necessary

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

   SELECT E.Executions
        ,                         CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END                  AS [Runs/Hour]
        , CONVERT(decimal(19,02), CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END * E.Seconds_AVG) AS [Time/Hour]
        , E.Creation
        , E.Last_Run
--      , E.Seconds_SUM -- total
        , E.Seconds_AVG -- average
        , E.Seconds_MIN -- minimum
        , E.Seconds_MAX -- maximum
--      , E.Seconds_LST -- last
--      , E.LReads_SUM
        , E.LReads_AVG
        , E.LReads_MIN
        , E.LReads_MAX
--      , E.LReads_LST
--      , E.PReads_SUM
--      , E.PReads_AVG
--      , E.PReads_MIN
--      , E.PReads_MAX
--      , E.PReads_LST
--      , E.Writes_SUM
        , E.Writes_AVG
        , E.Writes_MIN
        , E.Writes_MAX
--      , E.Writes_LST
--      , E.Rows_SUM
--      , E.Rows_AVG
--      , E.Rows_MIN
--      , E.Rows_MAX
--      , E.Rows_LST
        , E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.ObjectType
--      , E.query_plan
        , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
        ,           E.text                  AS SQL_code_all
     FROM
  (SELECT S.execution_count                                   AS Executions
        , DATEDIFF(second, S.creation_time, GETDATE()) + 1    AS Seconds
        , CONVERT(varchar(0040) ,       S.creation_time, 120) AS Creation
        , CONVERT(varchar(0040) , S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_SUM
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN  S.last_elapsed_time ELSE  S.last_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_LST
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.min_elapsed_time ELSE   S.min_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MIN
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.max_elapsed_time ELSE   S.max_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MAX
--      , CONVERT(decimal(19,05),                                  S.total_clr_time                              / 1000.0 / 1000.0 / S.execution_count) AS SQL_CLR_AVG
--      , CONVERT(decimal(19,05),                                  S.total_clr_time                              / 1000.0 / 1000.0                    ) AS SQL_CLR_SUM
--      , CONVERT(decimal(19,05),                                   S.last_clr_time                              / 1000.0 / 1000.0                    ) AS SQL_CLR_LST
--      , CONVERT(decimal(19,05),                                    S.min_clr_time                              / 1000.0 / 1000.0                    ) AS SQL_CLR_MIN
--      , CONVERT(decimal(19,05),                                    S.max_clr_time                              / 1000.0 / 1000.0                    ) AS SQL_CLR_MAX
        , S.total_logical_writes / S.execution_count AS Writes_AVG
        , S.total_logical_writes                     AS Writes_SUM
        ,  S.last_logical_writes                     AS Writes_LST
        ,   S.min_logical_writes                     AS Writes_MIN
        ,   S.max_logical_writes                     AS Writes_MAX
        ,  S.total_logical_reads / S.execution_count AS LReads_AVG
        ,  S.total_logical_reads                     AS LReads_SUM
        ,   S.last_logical_reads                     AS LReads_LST
        ,    S.min_logical_reads                     AS LReads_MIN
        ,    S.max_logical_reads                     AS LReads_MAX
        , S.total_physical_reads / S.execution_count AS PReads_AVG
        , S.total_physical_reads                     AS PReads_SUM
        ,  S.last_physical_reads                     AS PReads_LST
        ,   S.min_physical_reads                     AS PReads_MIN
        ,   S.max_physical_reads                     AS PReads_MAX
        ,           S.total_rows / S.execution_count AS Rows_AVG
        ,           S.total_rows                     AS Rows_SUM
        ,            S.last_rows                     AS Rows_LST
        ,             S.min_rows                     AS Rows_MIN
        ,             S.max_rows                     AS Rows_MAX
        ,            DB_NAME(            V.dbid) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(V.objectid, V.dbid) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(V.objectid, V.dbid) COLLATE database_default AS ObjectName
        ,                               SPACE(2) COLLATE database_default AS ObjectType
        , CASE WHEN S.statement_start_offset < 0 THEN     0                                                                            ELSE (S.statement_start_offset / 2)     END + 1 AS I
        , CASE WHEN S.statement_end_offset   < 0 THEN LEN(T.text) WHEN S.statement_end_offset > (LEN(T.text) * 2) - 4 THEN LEN(T.text) ELSE (S.statement_end_offset   / 2) + 1 END + 1 AS O
        , T.text COLLATE database_default AS text
        , V.query_plan
     FROM sys.dm_exec_query_stats AS S OUTER APPLY sys.dm_exec_sql_text(S.sql_handle) AS T OUTER APPLY sys.dm_exec_query_plan(S.plan_handle) AS V) AS E
    WHERE E.DBName LIKE @DBName
      AND E.DBName NOT IN ('msdb', 'master')
      AND E.ObjectType IN ('P ', 'V ', 'FN', 'IF', 'TF', 'TR', SPACE(2))
      AND E.Seconds_SUM
       !<  @Seconds_SUM
 ORDER BY [Time/Hour] DESC
        , [Runs/Hour] DESC

   SELECT E.Executions
        ,                         CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END                  AS [Runs/Hour]
        , CONVERT(decimal(19,02), CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END * E.Seconds_AVG) AS [Time/Hour]
        , E.Creation
        , E.Last_Run
--      , E.Seconds_SUM -- total
        , E.Seconds_AVG -- average
        , E.Seconds_MIN -- minimum
        , E.Seconds_MAX -- maximum
--      , E.Seconds_LST -- last
--      , E.LReads_SUM
        , E.LReads_AVG
        , E.LReads_MIN
        , E.LReads_MAX
--      , E.LReads_LST
--      , E.PReads_SUM
--      , E.PReads_AVG
--      , E.PReads_MIN
--      , E.PReads_MAX
--      , E.PReads_LST
--      , E.Writes_SUM
        , E.Writes_AVG
        , E.Writes_MIN
        , E.Writes_MAX
--      , E.Writes_LST
        , E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.ObjectType
--      , E.query_plan
     FROM
  (SELECT S.execution_count                                   AS Executions
        , DATEDIFF(second, S.cached_time, GETDATE()) + 1      AS Seconds
        , CONVERT(varchar(0040) ,         S.cached_time, 120) AS Creation
        , CONVERT(varchar(0040) , S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_SUM
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN  S.last_elapsed_time ELSE  S.last_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_LST
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.min_elapsed_time ELSE   S.min_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MIN
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.max_elapsed_time ELSE   S.max_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MAX
        , S.total_logical_writes / S.execution_count AS Writes_AVG
        , S.total_logical_writes                     AS Writes_SUM
        ,  S.last_logical_writes                     AS Writes_LST
        ,   S.min_logical_writes                     AS Writes_MIN
        ,   S.max_logical_writes                     AS Writes_MAX
        ,  S.total_logical_reads / S.execution_count AS LReads_AVG
        ,  S.total_logical_reads                     AS LReads_SUM
        ,   S.last_logical_reads                     AS LReads_LST
        ,    S.min_logical_reads                     AS LReads_MIN
        ,    S.max_logical_reads                     AS LReads_MAX
        , S.total_physical_reads / S.execution_count AS PReads_AVG
        , S.total_physical_reads                     AS PReads_SUM
        ,  S.last_physical_reads                     AS PReads_LST
        ,   S.min_physical_reads                     AS PReads_MIN
        ,   S.max_physical_reads                     AS PReads_MAX
        ,            DB_NAME(             S.database_id) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(S.object_id, S.database_id) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(S.object_id, S.database_id) COLLATE database_default AS ObjectName
        ,                       ISNULL(S.type, SPACE(2)) COLLATE database_default AS ObjectType
        , V.query_plan
     FROM sys.dm_exec_procedure_stats AS S OUTER APPLY sys.dm_exec_query_plan(S.plan_handle) AS V) AS E
    WHERE E.DBName LIKE @DBName
      AND E.DBName NOT IN ('msdb', 'master')
      AND E.ObjectType IN ('P ', 'V ', 'FN', 'IF', 'TF', 'TR', SPACE(2))
      AND E.Seconds_SUM
       !<  @Seconds_SUM
 ORDER BY [Time/Hour] DESC
        , [Runs/Hour] DESC

SET NOCOUNT OFF

