/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @QueryName varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary, for query filtering

DECLARE @TableName varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary, for table filtering

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

PRINT CHAR(13) + CHAR(10)

PRINT 'Nature PK means primary   key'
PRINT 'Nature AK means alternate key (unique constraint)'
PRINT 'Nature U  means unique'
PRINT 'Nature UF means unique filtered'
PRINT 'Nature S  means simple'
PRINT 'Nature SF means simple filtered'

PRINT CHAR(13) + CHAR(10)

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

IF OBJECT_ID('tempdb..#Base', 'U ') IS NOT NULL DROP TABLE #Base

IF OBJECT_ID('tempdb..#More', 'U ') IS NOT NULL DROP TABLE #More

IF OBJECT_ID('tempdb..#Task', 'U ') IS NOT NULL DROP TABLE #Task

IF OBJECT_ID('tempdb..#ZKey', 'U ') IS NOT NULL DROP TABLE #ZKey

IF OBJECT_ID('tempdb..#Hack', 'U ') IS NOT NULL DROP TABLE #Hack

IF OBJECT_ID('tempdb..#Work', 'U ') IS NOT NULL DROP TABLE #Work

IF OBJECT_ID('tempdb..#Zone', 'U ') IS NOT NULL DROP TABLE #Zone

IF OBJECT_ID('tempdb..#Disk', 'U ') IS NOT NULL DROP TABLE #Disk

   SELECT O.object_id AS GeneralID
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , COUNT(*)    AS Columns
     INTO #Base
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.columns AS C
       ON O.object_id
        = C.object_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 GROUP BY O.object_id
        , O.name
        , S.name
 ORDER BY O.object_id

   SELECT O.object_id AS ReferenceByID
        , O.type      AS ReferenceByType
        , O.name      AS ReferenceByObject
        , S.name      AS ReferenceBySchema
        , W.object_id AS ReferenceOfID
        , W.type      AS ReferenceOfType
        , W.name      AS ReferenceOfObject
        , Z.name      AS ReferenceOfSchema
     INTO #More
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN
  (SELECT D.referencing_id AS ReferenceByID
        , D.referenced_id  AS ReferenceOfID
     FROM sys.sql_expression_dependencies AS D
    WHERE D.referencing_id
       != D.referenced_id
      AND ISNULL(D.referenced_database_name, DB_NAME()) = DB_NAME()
 GROUP BY D.referencing_id
        , D.referenced_id) AS K
       ON O.object_id
        = K.ReferenceByID
     JOIN sys.objects AS W
       ON K.ReferenceOfID
        = W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
    WHERE O.type IN ('P ')
 ORDER BY   ReferenceByID
        ,   ReferenceOfID

   DELETE #More
     FROM #More AS M
     JOIN
  (SELECT W.ReferenceByID
     FROM #More AS W
    WHERE W.ReferenceOfType IN ('SN')
 GROUP BY W.ReferenceByID) AS Z
       ON M.ReferenceByID
        = Z.ReferenceByID

BEGIN TRY

   SELECT M.ReferenceByID
        , M.ReferenceByType
        , M.ReferenceByObject
        , M.ReferenceBySchema
        , M.ReferenceOfID
        , M.ReferenceOfType
        , M.ReferenceOfObject
        , M.ReferenceOfSchema
        , D.referenced_minor_name AS ReferenceOfColumn
        ,                                                                           D.referenced_minor_id  AS table_column_id
        , ROW_NUMBER() OVER (PARTITION BY M.ReferenceByID, M.ReferenceOfID ORDER BY D.referenced_minor_id) AS query_column_id
     INTO #Task
     FROM #More AS M
    CROSS APPLY sys.dm_sql_referenced_entities(M.ReferenceBySchema + '.' + M.ReferenceByObject, 'OBJECT') AS D
    WHERE M.ReferenceOfType   IN ('U ')
      AND M.ReferenceBySchema IN (SELECT [Schema] FROM @Match)
      AND M.ReferenceOfSchema IN (SELECT [Schema] FROM @Match)
      AND M.ReferenceByObject LIKE @QueryName
      AND M.ReferenceOfObject LIKE @TableName
      AND M.ReferenceByObject NOT LIKE 'uspG[SIUD]%'
      AND M.ReferenceByObject NOT LIKE 'trgG[SIUD]%'
      AND M.ReferenceOfID
        = D.referenced_id
      AND D.referenced_minor_id > 0
 ORDER BY M.ReferenceByID
        , M.ReferenceOfID
        , D.referenced_minor_id

END TRY

BEGIN CATCH

-- dismiss errors caused by unresolved references

END CATCH

-- indexes

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , I.is_unique
        , I.is_disabled
        , M.is_included_column
        , M.is_descending_key
        , M.partition_ordinal
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , CASE WHEN M.is_included_column  = 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY M.key_ordinal, M.index_column_id) ELSE 0 END AS regular_column_id
        , CASE WHEN M.is_included_column != 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY                M.index_column_id) ELSE 0 END AS include_column_id
        , ISNULL(I.filter_definition, SPACE(0)) AS GeneralFilter
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
     INTO #ZKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
LEFT JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName
        ,   index_column_id

   UPDATE Z SET table_type = CASE WHEN E.GeneralType = 'V ' THEN 0 - E.index_type ELSE E.index_type END
     FROM #ZKey AS Z
     JOIN #ZKey AS E
       ON Z.GeneralID
        = E.GeneralID
      AND E.index_type      IN (0, 1, 5)
      AND E.index_column_id IN (0, 1)

   SELECT Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
        , SUM(CASE WHEN Z.regular_column_id >  0 THEN 1 ELSE 0 END) AS KeyColumns
        , SUM(CASE WHEN Z.include_column_id >  0 THEN 1 ELSE 0 END) AS AnyColumns
        , MAX(CASE WHEN Z.regular_column_id =  1 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  2 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  3 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  4 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  5 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  6 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  7 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  8 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  9 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 10 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 11 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 12 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 13 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 14 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 15 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 16 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 17 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 18 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 19 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS RegularColumn
        , MAX(CASE WHEN Z.include_column_id =  1 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  2 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  3 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  4 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  5 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  6 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  7 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  8 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  9 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 10 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 11 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 12 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 13 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 14 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 15 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 16 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 17 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 18 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 19 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS IncludeColumn
     INTO #Hack
     FROM #ZKey AS Z
 GROUP BY Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
 ORDER BY Z.GeneralSchema
        , Z.GeneralObject
        , Z.index_id

   INSERT #ZKey
   SELECT Z.GeneralID
        , Z.GeneralType
        , Z.GeneralObject
        , Z.GeneralSchema
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , W.is_included_column
        , W.is_descending_key
        , W.partition_ordinal
        , 0 AS index_column_id
        , 0 AS regular_column_id
        , 0 AS include_column_id
        , Z.GeneralFilter
        , W.GeneralColumn
        , W.name
        , W.min_length
        , W.max_length
        , W.precision
        , W.scale
     FROM #ZKey AS Z
     JOIN #ZKey AS W
       ON Z.GeneralID
        = W.GeneralID
      AND Z.index_type = 2
      AND W.index_type = 1
    WHERE Z.index_column_id = 1

   SELECT T.ReferenceByID
        , T.ReferenceByType
        , T.ReferenceByObject
        , T.ReferenceBySchema
        , T.ReferenceOfID
        , T.ReferenceOfType
        , T.ReferenceOfObject
        , T.ReferenceOfSchema
        , Z.table_type
        , Z.index_type
        , Z.index_id
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.GeneralFilter
        , Z.SQLServerName
        , CASE WHEN Z.index_type            = 0 THEN 'S '
               WHEN Z.index_type            = 5 THEN 'S '
               WHEN Z.index_type            = 6 THEN 'S '
               WHEN Z.is_primary_key       != 0 THEN 'PK'
               WHEN Z.is_unique_constraint != 0 THEN 'AK'
               WHEN Z.is_unique            != 0 AND LEN(Z.GeneralFilter) = 0 THEN 'U '
               WHEN Z.is_unique            != 0 AND LEN(Z.GeneralFilter) > 0 THEN 'UF'
               WHEN Z.is_unique             = 0 AND LEN(Z.GeneralFilter) = 0 THEN 'S '
               WHEN Z.is_unique             = 0 AND LEN(Z.GeneralFilter) > 0 THEN 'SF' END AS Nature
        , E.Columns AS ColumnsTable
        , U.Columns AS ColumnsQuery
        , M.Columns AS ColumnsFound
     INTO #Work
     FROM #Task AS T
     JOIN #ZKey AS Z
       ON T.ReferenceOfID
        =     Z.GeneralID
--    AND T.ReferenceOfColumn
--      =     Z.GeneralColumn
      AND T.query_column_id  = 1
      AND Z.index_column_id  = 1
      AND Z.index_type       = 2
     JOIN
  (SELECT V.ReferenceByID
        , W.GeneralID
        , W.index_id
        , COUNT(*) AS Columns
     FROM #Task AS V
     JOIN #ZKey AS W
       ON V.ReferenceOfID
        =     W.GeneralID
      AND V.ReferenceOfColumn
        =     W.GeneralColumn
--    AND W.index_column_id != 1
      AND W.index_type       = 2
 GROUP BY V.ReferenceByID
        , W.GeneralID
        , W.index_id) AS M
       ON T.ReferenceByID
        = M.ReferenceByID
      AND Z.GeneralID
        = M.GeneralID
      AND Z.index_id
        = M.index_id
     JOIN
  (SELECT K.ReferenceByID
        , K.ReferenceOfID
        , COUNT(*) AS Columns
     FROM #Task AS K
 GROUP BY K.ReferenceByID
        , K.ReferenceOfID) AS U
       ON T.ReferenceByID
        = U.ReferenceByID
      AND T.ReferenceOfID
        = U.ReferenceOfID
     JOIN #Base AS E
       ON Z.GeneralID
        = E.GeneralID
 ORDER BY CASE T.ReferenceByType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceBySchema
        , T.ReferenceByObject
--      , T.ReferenceOfType
        , T.ReferenceOfSchema
        , T.ReferenceOfObject
        , Z.SQLServerName

   SELECT E.Executions
        ,                         CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END              AS [Runs/Hour]
        , CONVERT(decimal(19,02), CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END * E.CPU_AVG) AS [Time/Hour]
        , E.Creation
        , E.Last_Run
        , E.Run_AVG
        , E.Run_SUM
        , E.Run_LST
        , E.Run_MIN
        , E.Run_MAX
        , E.CPU_AVG
        , E.CPU_SUM
        , E.CPU_LST
        , E.CPU_MIN
        , E.CPU_MAX
        , E.Writes_AVG
        , E.Writes_SUM
        , E.Writes_LST
        , E.Writes_MIN
        , E.Writes_MAX
        , E.LReads_AVG
        , E.LReads_SUM
        , E.LReads_LST
        , E.LReads_MIN
        , E.LReads_MAX
        , E.PReads_AVG
        , E.PReads_SUM
        , E.PReads_LST
        , E.PReads_MIN
        , E.PReads_MAX
        , E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.ObjectType
        , E.query_plan
        , E.object_id AS ReferenceByID
     INTO #Zone
     FROM
  (SELECT S.execution_count                                   AS Executions
        , DATEDIFF(second, S.cached_time, GETDATE()) + 1      AS Seconds
        , CONVERT(varchar(0040) ,         S.cached_time, 120) AS Creation
        , CONVERT(varchar(0040) , S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), S.total_elapsed_time / 1000.0 / 1000.0 / S.execution_count) AS Run_AVG
        , CONVERT(decimal(19,05), S.total_elapsed_time / 1000.0 / 1000.0                    ) AS Run_SUM
        , CONVERT(decimal(19,05),  S.last_elapsed_time / 1000.0 / 1000.0                    ) AS Run_LST
        , CONVERT(decimal(19,05),   S.min_elapsed_time / 1000.0 / 1000.0                    ) AS Run_MIN
        , CONVERT(decimal(19,05),   S.max_elapsed_time / 1000.0 / 1000.0                    ) AS Run_MAX
        , CONVERT(decimal(19,05),  S.total_worker_time / 1000.0 / 1000.0 / S.execution_count) AS CPU_AVG
        , CONVERT(decimal(19,05),  S.total_worker_time / 1000.0 / 1000.0                    ) AS CPU_SUM
        , CONVERT(decimal(19,05),   S.last_worker_time / 1000.0 / 1000.0                    ) AS CPU_LST
        , CONVERT(decimal(19,05),    S.min_worker_time / 1000.0 / 1000.0                    ) AS CPU_MIN
        , CONVERT(decimal(19,05),    S.max_worker_time / 1000.0 / 1000.0                    ) AS CPU_MAX
        , S.total_logical_writes / S.execution_count AS Writes_AVG
        , S.total_logical_writes                     AS Writes_SUM
        ,  S.last_logical_writes                     AS Writes_LST
        ,   S.min_logical_writes                     AS Writes_MIN
        ,   S.max_logical_writes                     AS Writes_MAX
        ,  S.total_logical_reads / S.execution_count AS LReads_AVG
        ,  S.total_logical_reads                     AS LReads_SUM
        ,   S.last_logical_reads                     AS LReads_LST
        ,    S.min_logical_reads                     AS LReads_MIN
        ,    S.max_logical_reads                     AS LReads_MAX
        , S.total_physical_reads / S.execution_count AS PReads_AVG
        , S.total_physical_reads                     AS PReads_SUM
        ,  S.last_physical_reads                     AS PReads_LST
        ,   S.min_physical_reads                     AS PReads_MIN
        ,   S.max_physical_reads                     AS PReads_MAX
        ,            DB_NAME(             S.database_id) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(S.object_id, S.database_id) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(S.object_id, S.database_id) COLLATE database_default AS ObjectName
        ,                       ISNULL(S.type, SPACE(2)) COLLATE database_default AS ObjectType
        , REPLACE(REPLACE(CONVERT(nvarchar(max), V.query_plan), '[', '{'), ']', '}') COLLATE database_default AS query_plan
        , S.object_id
     FROM sys.dm_exec_procedure_stats AS S OUTER APPLY sys.dm_exec_query_plan(S.plan_handle) AS V) AS E
    WHERE E.DBName = DB_NAME()
      AND E.ObjectType IN ('P ')
      AND E.query_plan LIKE '%<Object Database="{%}" Schema="{%}" Table="{%}" Index="{%}"%'

   SELECT A.ReferenceByType   AS QueryType
        , A.ReferenceBySchema AS QuerySchema
        , A.ReferenceByObject AS QueryObject
--      , A.ReferenceOfType   AS TableType
        , A.ReferenceOfSchema AS TableSchema
        , A.ReferenceOfObject AS TableObject
        , A.table_type
--      , A.index_type
        , A.ColumnsQuery
        , A.ColumnsFound
        , A.ColumnsTable
        , H.KeyColumns + H.AnyColumns AS ColumnsIndex
        , A.GeneralFilter     AS IndexFilter
        , A.SQLServerName     AS IndexObject
        , A.Nature
        , H.RegularColumn
        , H.IncludeColumn
        , Z.Executions
        , Z.[Runs/Hour]
        , Z.[Time/Hour]
        , Z.Creation
        , Z.Last_Run
        , Z.Run_AVG
        , Z.Run_SUM
        , Z.Run_LST
        , Z.Run_MIN
        , Z.Run_MAX
        , Z.CPU_AVG
        , Z.CPU_SUM
        , Z.CPU_LST
        , Z.CPU_MIN
        , Z.CPU_MAX
        , Z.Writes_AVG
        , Z.Writes_SUM
        , Z.Writes_LST
        , Z.Writes_MIN
        , Z.Writes_MAX
        , Z.LReads_AVG
        , Z.LReads_SUM
        , Z.LReads_LST
        , Z.LReads_MIN
        , Z.LReads_MAX
        , Z.PReads_AVG
        , Z.PReads_SUM
        , Z.PReads_LST
        , Z.PReads_MIN
        , Z.PReads_MAX
     INTO #Disk
     FROM #Work AS A
     JOIN #Hack AS H
       ON A.ReferenceOfID
        = H.GeneralID
      AND A.index_id
        = H.index_id
     JOIN #Zone AS Z
       ON A.ReferenceByID
        = Z.ReferenceByID
      AND Z.query_plan LIKE '%<Object Database="{' + DB_NAME() + '}" Schema="{' + A.ReferenceOfSchema + '}" Table="{' + A.ReferenceOfObject + '}" Index="{' + A.SQLServerName + '}"%'
 ORDER BY CASE A.ReferenceByType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , A.ReferenceBySchema
        , A.ReferenceByObject
--      , A.ReferenceOfType
        , A.ReferenceOfSchema
        , A.ReferenceOfObject
        , A.SQLServerName

   SELECT Z.QueryType
        , Z.QuerySchema
        , Z.QueryObject
        , Z.Executions
        , Z.[Runs/Hour]
        , Z.[Time/Hour]
        , Z.Creation
        , Z.Last_Run
--      , Z.Run_SUM
        , Z.Run_AVG
--      , Z.Run_MIN
--      , Z.Run_MAX
--      , Z.Run_LST
--      , Z.CPU_SUM
        , Z.CPU_AVG
--      , Z.CPU_MIN
--      , Z.CPU_MAX
--      , Z.CPU_LST
--      , Z.LReads_SUM
        , Z.LReads_AVG
--      , Z.LReads_MIN
--      , Z.LReads_MAX
--      , Z.LReads_LST
--      , Z.PReads_SUM
--      , Z.PReads_AVG
--      , Z.PReads_MIN
--      , Z.PReads_MAX
--      , Z.PReads_LST
--      , Z.Writes_SUM
--      , Z.Writes_AVG
--      , Z.Writes_MIN
--      , Z.Writes_MAX
--      , Z.Writes_LST
--      , Z.TableType
        , Z.TableSchema
        , Z.TableObject
        , Z.table_type
--      , Z.index_type
        , Z.ColumnsQuery
        , Z.ColumnsFound
        , Z.ColumnsTable
        , Z.ColumnsIndex
        , Z.IndexObject
        , Z.Nature
--      , Z.IndexFilter
--      , Z.RegularColumn
--      , Z.IncludeColumn
     FROM #Disk AS Z
 ORDER BY CASE Z.QueryType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , Z.QuerySchema
        , Z.QueryObject
        , Z.TableSchema
        , Z.TableObject
        , Z.IndexObject

   SELECT Z.QueryType
        , Z.QuerySchema
        , Z.QueryObject
        , Z.Executions
        , Z.[Runs/Hour]
        , Z.[Time/Hour]
        , Z.Creation
        , Z.Last_Run
--      , Z.Run_SUM
        , Z.Run_AVG
--      , Z.Run_MIN
--      , Z.Run_MAX
--      , Z.Run_LST
--      , Z.CPU_SUM
        , Z.CPU_AVG
--      , Z.CPU_MIN
--      , Z.CPU_MAX
--      , Z.CPU_LST
--      , Z.LReads_SUM
        , Z.LReads_AVG
--      , Z.LReads_MIN
--      , Z.LReads_MAX
--      , Z.LReads_LST
--      , Z.PReads_SUM
--      , Z.PReads_AVG
--      , Z.PReads_MIN
--      , Z.PReads_MAX
--      , Z.PReads_LST
--      , Z.Writes_SUM
--      , Z.Writes_AVG
--      , Z.Writes_MIN
--      , Z.Writes_MAX
--      , Z.Writes_LST
--      , Z.TableType
        , Z.TableSchema
        , Z.TableObject
        , Z.table_type
--      , Z.index_type
        , Z.ColumnsQuery
        , Z.ColumnsFound
        , Z.ColumnsTable
        , Z.ColumnsIndex
        , Z.IndexObject
        , Z.Nature
--      , Z.IndexFilter
--      , Z.RegularColumn
--      , Z.IncludeColumn
     FROM #Disk AS Z
 ORDER BY Z.TableSchema
        , Z.TableObject
        , Z.IndexObject
        , CASE Z.QueryType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , Z.QuerySchema
        , Z.QueryObject

DROP TABLE #Base

DROP TABLE #More

DROP TABLE #Task

DROP TABLE #ZKey

DROP TABLE #Hack

DROP TABLE #Work

DROP TABLE #Zone

DROP TABLE #Disk

SET NOCOUNT OFF

