/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @CPU_time bit = 1
--      @CPU_time     = 0 means Seconds are run time
--      @CPU_time     = 1 means Seconds are CPU time

DECLARE @GeneralSchema varchar(0128) = '%' -- enter schema name here, use LIKE wildcards as necessary

DECLARE @GeneralObject varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

IF OBJECT_ID('tempdb..#Action_Procedure', 'U ') IS NOT NULL DROP TABLE #Action_Procedure

IF OBJECT_ID('tempdb..#Action_Statement', 'U ') IS NOT NULL DROP TABLE #Action_Statement

IF OBJECT_ID('tempdb..#Action_Parameter', 'U ') IS NOT NULL DROP TABLE #Action_Parameter

IF OBJECT_ID('tempdb..#Action_Associate', 'U ') IS NOT NULL DROP TABLE #Action_Associate

   SELECT E.*
     INTO #Action_Procedure
     FROM
  (SELECT S.execution_count                                   AS Executions
        , DATEDIFF(second, S.cached_time, GETDATE()) + 1      AS Seconds
        , CONVERT(varchar(0040) ,         S.cached_time, 120) AS Creation
        , CONVERT(varchar(0040) , S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_SUM
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN  S.last_elapsed_time ELSE  S.last_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_LST
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.min_elapsed_time ELSE   S.min_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MIN
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.max_elapsed_time ELSE   S.max_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MAX
        , S.total_logical_writes / S.execution_count AS Writes_AVG
        , S.total_logical_writes                     AS Writes_SUM
        ,  S.last_logical_writes                     AS Writes_LST
        ,   S.min_logical_writes                     AS Writes_MIN
        ,   S.max_logical_writes                     AS Writes_MAX
        ,  S.total_logical_reads / S.execution_count AS LReads_AVG
        ,  S.total_logical_reads                     AS LReads_SUM
        ,   S.last_logical_reads                     AS LReads_LST
        ,    S.min_logical_reads                     AS LReads_MIN
        ,    S.max_logical_reads                     AS LReads_MAX
        , S.total_physical_reads / S.execution_count AS PReads_AVG
        , S.total_physical_reads                     AS PReads_SUM
        ,  S.last_physical_reads                     AS PReads_LST
        ,   S.min_physical_reads                     AS PReads_MIN
        ,   S.max_physical_reads                     AS PReads_MAX
        ,            DB_NAME(             S.database_id) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(S.object_id, S.database_id) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(S.object_id, S.database_id) COLLATE database_default AS ObjectName
        ,                       ISNULL(S.type, SPACE(2)) COLLATE database_default AS ObjectType
        , S.sql_handle
        ,                 CONVERT(nvarchar(max), V.query_plan) COLLATE database_default AS query_plan
        , REPLACE(
          REPLACE(
          REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(CONVERT(nvarchar(max), V.query_plan), '&#x09;', ''), '&#x9;', '')
                                                              , '&#x0D;', ''), '&#xD;', '')
                                                              , '&#x0A;', ''), '&#xA;', '')
                                                              , '&amp;amp;amp;', '')
                                                              , '&amp;amp;'    , '')
                                                              , '&amp;'        , '') COLLATE database_default AS query_plus
     FROM sys.dm_exec_procedure_stats AS S OUTER APPLY sys.dm_exec_query_plan(S.plan_handle) AS V) AS E
    WHERE E.DBName = DB_NAME()
      AND E.SchemaName LIKE @GeneralSchema
      AND E.ObjectName LIKE @GeneralObject
 ORDER BY E.SchemaName
        , E.ObjectName

   SELECT E.*
        , ROW_NUMBER() OVER (PARTITION BY E.SchemaName, E.ObjectName ORDER BY E.I) AS StatementID
        , CONVERT(int, 0) AS T
        , CONVERT(int, 0) AS W
        , CONVERT(int, 0) AS Z
     INTO #Action_Statement
     FROM
  (SELECT S.execution_count                                   AS Executions
        , DATEDIFF(second, S.creation_time, GETDATE()) + 1    AS Seconds
        , CONVERT(varchar(0040) ,       S.creation_time, 120) AS Creation
        , CONVERT(varchar(0040) , S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_SUM
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN  S.last_elapsed_time ELSE  S.last_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_LST
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.min_elapsed_time ELSE   S.min_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MIN
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.max_elapsed_time ELSE   S.max_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MAX
        , S.total_logical_writes / S.execution_count AS Writes_AVG
        , S.total_logical_writes                     AS Writes_SUM
        ,  S.last_logical_writes                     AS Writes_LST
        ,   S.min_logical_writes                     AS Writes_MIN
        ,   S.max_logical_writes                     AS Writes_MAX
        ,  S.total_logical_reads / S.execution_count AS LReads_AVG
        ,  S.total_logical_reads                     AS LReads_SUM
        ,   S.last_logical_reads                     AS LReads_LST
        ,    S.min_logical_reads                     AS LReads_MIN
        ,    S.max_logical_reads                     AS LReads_MAX
        , S.total_physical_reads / S.execution_count AS PReads_AVG
        , S.total_physical_reads                     AS PReads_SUM
        ,  S.last_physical_reads                     AS PReads_LST
        ,   S.min_physical_reads                     AS PReads_MIN
        ,   S.max_physical_reads                     AS PReads_MAX
        ,           S.total_rows / S.execution_count AS Rows_AVG
        ,           S.total_rows                     AS Rows_SUM
        ,            S.last_rows                     AS Rows_LST
        ,             S.min_rows                     AS Rows_MIN
        ,             S.max_rows                     AS Rows_MAX
        ,            DB_NAME(            V.dbid) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(V.objectid, V.dbid) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(V.objectid, V.dbid) COLLATE database_default AS ObjectName
        ,                               SPACE(2) COLLATE database_default AS ObjectType
        , CASE WHEN S.statement_start_offset < 0 THEN     0                                                                            ELSE (S.statement_start_offset / 2)     END + 1 AS I
        , CASE WHEN S.statement_end_offset   < 0 THEN LEN(T.text) WHEN S.statement_end_offset > (LEN(T.text) * 2) - 4 THEN LEN(T.text) ELSE (S.statement_end_offset   / 2) + 1 END + 1 AS O
        , T.text COLLATE database_default AS text
        , S.sql_handle
        ,                 CONVERT(nvarchar(max), V.query_plan) COLLATE database_default AS query_plan
        , REPLACE(
          REPLACE(
          REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(CONVERT(nvarchar(max), V.query_plan), '&#x09;', ''), '&#x9;', '')
                                                              , '&#x0D;', ''), '&#xD;', '')
                                                              , '&#x0A;', ''), '&#xA;', '')
                                                              , '&amp;amp;amp;', '')
                                                              , '&amp;amp;'    , '')
                                                              , '&amp;'        , '') COLLATE database_default AS query_plus
     FROM sys.dm_exec_query_stats AS S OUTER APPLY sys.dm_exec_sql_text(S.sql_handle) AS T OUTER APPLY sys.dm_exec_query_plan(S.plan_handle) AS V) AS E
     JOIN #Action_Procedure AS Z
       ON E.sql_handle
        = Z.sql_handle
 ORDER BY E.SchemaName
        , E.ObjectName
        , E.I

   SELECT E.SchemaName
        , E.ObjectName
--      , E.ObjectType
        , E.SQLServerName
        , CASE WHEN E.name = 'time'           THEN E.name + '(' +                                                   STR(E.scale,       1)     + ')'
               WHEN E.name = 'datetime2'      THEN E.name + '(' +                                                   STR(E.scale,       1)     + ')'
               WHEN E.name = 'datetimeoffset' THEN E.name + '(' +                                                   STR(E.scale,       1)     + ')'
               WHEN E.name = 'float'          THEN E.name + '(' + RIGHT(STR(E.precision + 100, 3), 2)                                         + ')'
               WHEN E.name = 'numeric'        THEN E.name + '(' + RIGHT(STR(E.precision + 100, 3), 2) + ',' + RIGHT(STR(E.scale + 100, 3), 2) + ')'
               WHEN E.name = 'decimal'        THEN E.name + '(' + RIGHT(STR(E.precision + 100, 3), 2) + ',' + RIGHT(STR(E.scale + 100, 3), 2) + ')'
               WHEN E.name = 'vardecimal'     THEN E.name + '(' + RIGHT(STR(E.precision + 100, 3), 2) + ',' + RIGHT(STR(E.scale + 100, 3), 2) + ')'
               WHEN E.name = 'binary'         THEN E.name + '(' +                                 RIGHT(STR(E.max_length + 10000, 5), 4)                 + ')'
               WHEN E.name = 'varbinary'      THEN E.name + '(' + CASE WHEN E.max_length > 0 THEN RIGHT(STR(E.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN E.name = 'nchar'          THEN E.name + '(' +                                 RIGHT(STR(E.min_length + 10000, 5), 4)                 + ')'
               WHEN E.name = 'nvarchar'       THEN E.name + '(' + CASE WHEN E.min_length > 0 THEN RIGHT(STR(E.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN E.name = 'char'           THEN E.name + '(' +                                 RIGHT(STR(E.max_length + 10000, 5), 4)                 + ')'
               WHEN E.name = 'varchar'        THEN E.name + '(' + CASE WHEN E.max_length > 0 THEN RIGHT(STR(E.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE E.name END AS SQLServerType
        , E.parameter_id
     INTO #Action_Parameter
     FROM
  (SELECT S.name AS SchemaName
        , O.name AS ObjectName
        , O.type AS ObjectType
        , P.name AS SQLServerName
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND P.max_length > 0 THEN P.max_length / 2 ELSE P.max_length END AS min_length
        , P.max_length
        , P.precision
        , P.scale
        , P.parameter_id
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.parameters AS P
       ON O.object_id
        = P.object_id
     JOIN sys.types   AS T
       ON P.user_type_id
        = T.user_type_id
    WHERE S.name LIKE @GeneralSchema
      AND O.name LIKE @GeneralObject) AS E
     JOIN #Action_Procedure AS Z
       ON E.SchemaName
        = Z.SchemaName
      AND E.ObjectName
        = Z.ObjectName

   UPDATE #Action_Statement SET T = CHARINDEX(LEFT(REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(SUBSTRING(E.text, E.I, E.O - E.I), CHAR(09), '')      
                                                                                            , CHAR(13), '')      
                                                                                            , CHAR(10), '')      
                                                                                            , '&amp;' , '')      
                                                                                            , '&'     , '')      
                                                                                            , '['     , '{'     )
                                                                                            , ']'     , '}'     )
                                                                                            , '<'     , '&lt;'  )
                                                                                            , '>'     , '&gt;'  )
                                                                                            , '"'     , '&quot;'), 2000), E.query_plus, 1)
     FROM #Action_Statement AS E
    WHERE E.T = 0

   UPDATE #Action_Statement SET T = CHARINDEX(LEFT(REPLACE(
                                                   REPLACE(
                                                   REPLACE(
--                                                 REPLACE(
--                                                 REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(
                                                   REPLACE(SUBSTRING(E.text, E.I, E.O - E.I), CHAR(09), '')      
                                                                                            , CHAR(13), '')      
                                                                                            , CHAR(10), '')      
                                                                                            , '&amp;' , '')      
                                                                                            , '&'     , '')      
--                                                                                          , '['     , '{'     )
--                                                                                          , ']'     , '}'     )
                                                                                            , '<'     , '&lt;'  )
                                                                                            , '>'     , '&gt;'  )
                                                                                            , '"'     , '&quot;'), 2000), E.query_plus, 1)
     FROM #Action_Statement AS E
    WHERE E.T = 0

   UPDATE #Action_Statement SET W = CHARINDEX('StatementSubTreeCost="', E.query_plus, E.T + 2)
     FROM #Action_Statement AS E

   UPDATE #Action_Statement SET Z = CHARINDEX('"', E.query_plus, E.W + 22)
     FROM #Action_Statement AS E

   SELECT E.sql_handle
        , SUM(E.Seconds_AVG) AS Seconds_AVG
        , SUM(E.Seconds_LST) AS Seconds_LST
        , SUM( E.Writes_AVG) AS  Writes_AVG
        , SUM( E.Writes_LST) AS  Writes_LST
        , SUM( E.LReads_AVG) AS  LReads_AVG
        , SUM( E.LReads_LST) AS  LReads_LST
        , SUM( E.PReads_AVG) AS  PReads_AVG
        , SUM( E.PReads_LST) AS  PReads_LST
     INTO #Action_Associate
     FROM #Action_Statement AS E
 GROUP BY E.sql_handle
 ORDER BY E.sql_handle

   SELECT E.Executions
        ,                         CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END                  AS [Runs/Hour]
        , CONVERT(decimal(19,02), CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END * E.Seconds_AVG) AS [Time/Hour]
        , E.Creation
        , E.Last_Run
--      , E.Seconds_SUM -- total
        , E.Seconds_AVG -- average
        , E.Seconds_MIN -- minimum
        , E.Seconds_MAX -- maximum
--      , E.Seconds_LST -- last
--      , E.LReads_SUM
        , E.LReads_AVG
        , E.LReads_MIN
        , E.LReads_MAX
--      , E.LReads_LST
--      , E.PReads_SUM
--      , E.PReads_AVG
--      , E.PReads_MIN
--      , E.PReads_MAX
--      , E.PReads_LST
--      , E.Writes_SUM
        , E.Writes_AVG
        , E.Writes_MIN
        , E.Writes_MAX
--      , E.Writes_LST
        , E.SchemaName
        , E.ObjectName
--      , E.ObjectType
        , CONVERT(XML, E.query_plan) AS query_plan
     FROM #Action_Procedure AS E
 ORDER BY E.SchemaName
        , E.ObjectName

   SELECT E.Executions
        ,                         CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END                  AS [Runs/Hour]
        , CONVERT(decimal(19,02), CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END * E.Seconds_AVG) AS [Time/Hour]
        , E.Creation
        , E.Last_Run
--      , E.Seconds_SUM -- total
        , E.Seconds_AVG -- average
        , E.Seconds_MIN -- minimum
        , E.Seconds_MAX -- maximum
--      , E.Seconds_LST -- last
--      , E.LReads_SUM
        , E.LReads_AVG
        , E.LReads_MIN
        , E.LReads_MAX
--      , E.LReads_LST
--      , E.PReads_SUM
--      , E.PReads_AVG
--      , E.PReads_MIN
--      , E.PReads_MAX
--      , E.PReads_LST
--      , E.Writes_SUM
        , E.Writes_AVG
        , E.Writes_MIN
        , E.Writes_MAX
--      , E.Writes_LST
--      , E.Rows_SUM
--      , E.Rows_AVG
--      , E.Rows_MIN
--      , E.Rows_MAX
--      , E.Rows_LST
        , E.SchemaName
        , E.ObjectName
--      , E.ObjectType
--      , CONVERT(XML, E.query_plan) AS query_plan
        , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
--      ,           E.text                  AS SQL_code_all
        , E.StatementID AS Query
        , CONVERT(decimal(19,05), CONVERT(float(53), CASE WHEN E.T > 0 AND E.W > 0 AND E.W < E.Z THEN SUBSTRING(E.query_plus, E.W + 22, E.Z - E.W - 22) ELSE NULL END)) AS CostEstimate
        , CONVERT(decimal(05,02), E.Seconds_AVG * 100.0 / CASE WHEN Z.Seconds_AVG > 0.0 THEN Z.Seconds_AVG ELSE 1.0 END) AS [Percent]
--      , CONVERT(decimal(05,02), E.Seconds_AVG * 100.0 / CASE WHEN Z.Seconds_AVG > 0.0 THEN Z.Seconds_AVG ELSE 1.0 END) AS [Percent_AVG]
--      , CONVERT(decimal(05,02), E.Seconds_LST * 100.0 / CASE WHEN Z.Seconds_LST > 0.0 THEN Z.Seconds_LST ELSE 1.0 END) AS [Percent_LST]
     FROM #Action_Statement AS E
     JOIN #Action_Associate AS Z
       ON E.sql_handle
        = Z.sql_handle
 ORDER BY E.SchemaName
        , E.ObjectName
        , E.I

   SELECT W.SchemaName
        , W.ObjectName
        , W.parameter_id
        , W.SQLServerName
        , W.SQLServerType
        , CASE WHEN W.I > 0 AND W.I < W.O THEN SUBSTRING(W.query_plan, W.I, W.O - W.I) ELSE NULL END AS parameter_value
     FROM
  (SELECT E.SchemaName
        , E.ObjectName
        , E.parameter_id
        , E.SQLServerName
        , E.SQLServerType
        , Z.query_plan
        ,                              CHARINDEX('ParameterCompiledValue="', Z.query_plan, CHARINDEX('<ColumnReference Column="' + E.SQLServerName + '" ParameterDataType="', Z.query_plan, 1)) + 24  AS I
        , CHARINDEX('"', Z.query_plan, CHARINDEX('ParameterCompiledValue="', Z.query_plan, CHARINDEX('<ColumnReference Column="' + E.SQLServerName + '" ParameterDataType="', Z.query_plan, 1)) + 24) AS O
     FROM #Action_Parameter AS E
LEFT JOIN #Action_Procedure AS Z
       ON E.SchemaName
        = Z.SchemaName
      AND E.ObjectName
        = Z.ObjectName
      AND Z.query_plan LIKE '%<ColumnReference Column="' + E.SQLServerName + '" ParameterDataType="%') AS W
 ORDER BY W.SchemaName
        , W.ObjectName
        , W.parameter_id

DROP TABLE #Action_Procedure

DROP TABLE #Action_Statement

DROP TABLE #Action_Parameter

DROP TABLE #Action_Associate

SET NOCOUNT OFF

