/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @GeneralSchema varchar(0128) = '%' -- enter schema name here, use LIKE wildcards as necessary

DECLARE @GeneralObject varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

PRINT CHAR(13) + CHAR(10)

PRINT 'Instance Collation = ' + CONVERT(varchar(0256), SERVERPROPERTY('Collation'))

PRINT CHAR(13) + CHAR(10)

PRINT 'Database Collation = ' + CONVERT(varchar(0256), DATABASEPROPERTYEX(DB_NAME(), 'Collation'))

PRINT CHAR(13) + CHAR(10)

PRINT 'GeneralType (U ) means table'
PRINT 'GeneralType (V ) means view'
PRINT 'GeneralType (P ) means stored procedure'
PRINT 'GeneralType (FN) means user-defined function, scalar'
PRINT 'GeneralType (IF) means user-defined function, table-valued, inline'
PRINT 'GeneralType (TF) means user-defined function, table-valued, multi-statement'
PRINT 'GeneralType (TR) means trigger'

PRINT CHAR(13) + CHAR(10)

DECLARE @CPU_time bit = 1
--      @CPU_time     = 0 means Seconds are run time
--      @CPU_time     = 1 means Seconds are CPU time

DECLARE @Layer smallint

DECLARE @Batch smallint

IF OBJECT_ID('tempdb..#Base' , 'U ') IS NOT NULL DROP TABLE #Base

IF OBJECT_ID('tempdb..#Work' , 'U ') IS NOT NULL DROP TABLE #Work

IF OBJECT_ID('tempdb..#Task' , 'U ') IS NOT NULL DROP TABLE #Task

IF OBJECT_ID('tempdb..#TKey' , 'U ') IS NOT NULL DROP TABLE #TKey
IF OBJECT_ID('tempdb..#TKeys', 'U ') IS NOT NULL DROP TABLE #TKeys

IF OBJECT_ID('tempdb..#UKey' , 'U ') IS NOT NULL DROP TABLE #UKey
IF OBJECT_ID('tempdb..#UKeys', 'U ') IS NOT NULL DROP TABLE #UKeys

IF OBJECT_ID('tempdb..#DBAR' , 'U ') IS NOT NULL DROP TABLE #DBAR
IF OBJECT_ID('tempdb..#DBAT' , 'U ') IS NOT NULL DROP TABLE #DBAT

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , O.parent_object_id AS VariousID
        , CONVERT(varchar(max ), ISNULL(M.definition, SPACE(0))) AS SQLServerCode
     INTO #Base
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
LEFT JOIN sys.sql_modules AS M
       ON O.object_id
        = M.object_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY O.type
        , S.name
        , O.name

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , CONVERT(     int, -1) AS Layer
        , CONVERT(     int, -1) AS Estimate
        , CONVERT(smallint,  0) AS Factor01
        , CONVERT(smallint,  0) AS Factor02
        , CONVERT(smallint,  0) AS Factor03
        , CONVERT(smallint,  0) AS Factor04
        , CONVERT(smallint,  0) AS Factor05
     INTO #Work
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')

   SELECT O.object_id AS ReferenceByID
        , O.type      AS ReferenceByType
        , O.name      AS ReferenceByObject
        , S.name      AS ReferenceBySchema
        , W.object_id AS ReferenceOfID
        , W.type      AS ReferenceOfType
        , W.name      AS ReferenceOfObject
        , Z.name      AS ReferenceOfSchema
     INTO #Task
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN
  (SELECT D.referencing_id AS ReferenceByID
        , D.referenced_id  AS ReferenceOfID
     FROM sys.sql_expression_dependencies AS D
    WHERE D.referencing_id
       != D.referenced_id
 GROUP BY D.referencing_id
        , D.referenced_id) AS K
       ON O.object_id
        = K.ReferenceByID
     JOIN sys.objects AS W
       ON K.ReferenceOfID
        = W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
      AND Z.name IN (SELECT [Schema] FROM @Match)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type NOT IN ('C ')
 ORDER BY   ReferenceByID
        ,   ReferenceOfID

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , C.column_id
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , C.is_sparse
        , C.is_nullable
        , C.is_computed
        , C.is_identity
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_SEED   (S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [From]
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_INCR   (S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [Plus]
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_CURRENT(S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [Used]
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
        , ISNULL(                   C.collation_name , '') AS collation_name
        , ISNULL(CONVERT(varchar(4000), W.definition), '') AS FormulaCode
        , ISNULL(CONVERT(varchar(4000), Z.definition), '') AS DefaultCode
        , ISNULL(                             Z.name , '') AS DefaultName
     INTO #TKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.columns AS C
       ON O.object_id
        = C.object_id
     JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND I.is_primary_key != 0
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
      AND C.column_id
        = M.column_id
LEFT JOIN sys.computed_columns AS W
       ON C.object_id
        = W.object_id
      AND C.column_id
        = W.column_id
LEFT JOIN sys.default_constraints AS Z
       ON        C.object_id
        = Z.parent_object_id
      AND        C.column_id
        = Z.parent_column_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN (      'V ', 'P ', 'FN', 'IF', 'TF')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralType
        ,   GeneralSchema
        ,   GeneralObject
        ,   column_id

   SELECT T.*
        , CASE WHEN T.name = 'time'           THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetime2'      THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetimeoffset' THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'float'          THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2)                                         + ')'
               WHEN T.name = 'numeric'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'decimal'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'vardecimal'     THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'binary'         THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varbinary'      THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'nchar'          THEN T.name + '(' +                                 RIGHT(STR(T.min_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'nvarchar'       THEN T.name + '(' + CASE WHEN T.min_length > 0 THEN RIGHT(STR(T.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'char'           THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varchar'        THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE T.name END AS SQLServerType
     INTO #TKeys
     FROM #TKey AS T
--  WHERE T.GeneralType IN ('U ', 'V ', 'P ', 'FN', 'IF', 'TF')
 ORDER BY T.GeneralType
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , W.parameter_id
        , CONVERT(bit, COLUMNPROPERTY(O.object_id, W.name, 'AllowsNull')) AS is_nullable
        , CONVERT(bit, COLUMNPROPERTY(O.object_id, W.name, 'IsOutParam')) AS is_output
        , W.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND W.max_length > 0 THEN W.max_length / 2 ELSE W.max_length END AS min_length
        , W.max_length
        , W.precision
        , W.scale
     INTO #UKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.parameters AS W
       ON O.object_id
        = W.object_id
      AND W.parameter_id != 0
     JOIN sys.types AS T
       ON W.user_type_id
        = T.user_type_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN (            'P ', 'FN', 'IF', 'TF')
 ORDER BY   GeneralType
        ,   GeneralSchema
        ,   GeneralObject
        ,   parameter_id

   SELECT U.*
        , CASE WHEN U.name = 'time'           THEN U.name + '(' +                                                   STR(U.scale,       1)     + ')'
               WHEN U.name = 'datetime2'      THEN U.name + '(' +                                                   STR(U.scale,       1)     + ')'
               WHEN U.name = 'datetimeoffset' THEN U.name + '(' +                                                   STR(U.scale,       1)     + ')'
               WHEN U.name = 'float'          THEN U.name + '(' + RIGHT(STR(U.precision + 100, 3), 2)                                         + ')'
               WHEN U.name = 'numeric'        THEN U.name + '(' + RIGHT(STR(U.precision + 100, 3), 2) + ',' + RIGHT(STR(U.scale + 100, 3), 2) + ')'
               WHEN U.name = 'decimal'        THEN U.name + '(' + RIGHT(STR(U.precision + 100, 3), 2) + ',' + RIGHT(STR(U.scale + 100, 3), 2) + ')'
               WHEN U.name = 'vardecimal'     THEN U.name + '(' + RIGHT(STR(U.precision + 100, 3), 2) + ',' + RIGHT(STR(U.scale + 100, 3), 2) + ')'
               WHEN U.name = 'binary'         THEN U.name + '(' +                                 RIGHT(STR(U.max_length + 10000, 5), 4)                 + ')'
               WHEN U.name = 'varbinary'      THEN U.name + '(' + CASE WHEN U.max_length > 0 THEN RIGHT(STR(U.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN U.name = 'nchar'          THEN U.name + '(' +                                 RIGHT(STR(U.min_length + 10000, 5), 4)                 + ')'
               WHEN U.name = 'nvarchar'       THEN U.name + '(' + CASE WHEN U.min_length > 0 THEN RIGHT(STR(U.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN U.name = 'char'           THEN U.name + '(' +                                 RIGHT(STR(U.max_length + 10000, 5), 4)                 + ')'
               WHEN U.name = 'varchar'        THEN U.name + '(' + CASE WHEN U.max_length > 0 THEN RIGHT(STR(U.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE U.name END AS SQLServerType
     INTO #UKeys
     FROM #UKey AS U
--  WHERE U.GeneralType IN (            'P ', 'FN', 'IF', 'TF')
 ORDER BY U.GeneralType
        , U.GeneralSchema
        , U.GeneralObject
        , U.parameter_id

SET @Layer = 0

SET @Batch = 0

   UPDATE W SET Layer = @Layer
     FROM #Work AS W
LEFT JOIN #Task AS T
       ON W.GeneralID
        = T.ReferenceOfID
    WHERE T.ReferenceOfID IS NULL

SET @Batch = @@ROWCOUNT

WHILE @Batch > 0 AND @Layer < 50

    BEGIN

    SET @Layer = @Layer + 1

       UPDATE P SET Layer = @Layer
         FROM #Work AS P
        WHERE NOT EXISTS
      (SELECT *
         FROM #Work AS W
         JOIN #Task AS T
           ON W.GeneralID
            = T.ReferenceByID
          AND P.GeneralID
            = T.ReferenceOfID
        WHERE W.Layer < 0)
          AND P.Layer < 0

    SET @Batch = @@ROWCOUNT

    END

   UPDATE #Work  SET
          Factor01 = A.MyCOUNT
        , Estimate = A.MyCOUNT
     FROM #Work  AS W
     JOIN
  (SELECT T.GeneralID
        , COUNT(*)        AS MyCOUNT
     FROM #TKey  AS T
 GROUP BY T.GeneralID) AS A
       ON W.GeneralID
        = A.GeneralID

   UPDATE #Work  SET
          Factor02 =               A.MyCOUNT
        , Estimate = W.Estimate + (A.MyCOUNT * 3)
     FROM #Work  AS W
     JOIN
  (SELECT U.GeneralID
        , COUNT(*)        AS MyCOUNT
     FROM #UKey  AS U
 GROUP BY U.GeneralID) AS A
       ON W.GeneralID
        = A.GeneralID

   UPDATE #Work  SET
          Factor03 =               A.MyCOUNT
        , Estimate = W.Estimate + (A.MyCOUNT * 7)
     FROM #Work  AS W
     JOIN
  (SELECT E.GeneralID
        , CONVERT(smallint, (LEN(E.SQLServerCode) / 1024) + 1) AS MyCOUNT
     FROM #Base  AS E) AS A
       ON W.GeneralID
        = A.GeneralID

   UPDATE #Work  SET
          Factor04 =               A.MyCOUNT
        , Estimate = W.Estimate + (A.MyCOUNT * 5)
     FROM #Work  AS W
     JOIN
  (SELECT T.ReferenceByID AS GeneralID
        , COUNT(*)        AS MyCOUNT
     FROM #Task  AS T
    WHERE T.ReferenceOfType IN ('U ', 'V ', 'P ', 'FN', 'IF', 'TF', 'SN')
      AND T.ReferenceOfObject NOT LIKE 'uspG[SIUD]%'
      AND T.ReferenceOfObject NOT LIKE 'trgG[SIUD]%'
 GROUP BY T.ReferenceByID) AS A
       ON W.GeneralID
        = A.GeneralID

   UPDATE #Work  SET
          Factor05 =               A.MyCOUNT
        , Estimate = W.Estimate + (A.MyCOUNT * 9)
     FROM #Work  AS W
     JOIN
  (SELECT T.ReferenceOfID AS GeneralID
        , COUNT(*)        AS MyCOUNT
     FROM #Task  AS T
    WHERE T.ReferenceByType IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND T.ReferenceByObject NOT LIKE 'uspG[SIUD]%'
      AND T.ReferenceByObject NOT LIKE 'trgG[SIUD]%'
 GROUP BY T.ReferenceOfID) AS A
       ON W.GeneralID
        = A.GeneralID

SET @Layer = 0

SET @Batch = 0

   SELECT E.GeneralID AS ReferenceByID
        , E.GeneralID AS ReferenceOfID
        , @Layer AS Layer
     INTO #DBAT
     FROM #Base  AS E
    WHERE E.GeneralType IS NULL

   SELECT E.GeneralID AS ReferenceByID
        , E.GeneralID AS ReferenceOfID
        , @Layer AS Layer
     INTO #DBAR
     FROM #Base  AS E
    WHERE E.GeneralType IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')

SET @Batch = @@ROWCOUNT

WHILE @Batch > 0 AND @Layer < 50

    BEGIN

    SET @Layer = @Layer + 1

       INSERT #DBAT
       SELECT I.ReferenceByID
            , T.ReferenceOfID
            , @Layer
         FROM #DBAR  AS I
         JOIN #Task  AS T
           ON I.ReferenceOfID
            = T.ReferenceByID
        WHERE I.Layer + 1
            =  @Layer
          AND T.ReferenceOfType IN ('U ')

       INSERT #DBAR
       SELECT I.ReferenceByID
            , T.ReferenceOfID
            , @Layer
         FROM #DBAR  AS I
         JOIN #Task  AS T
           ON I.ReferenceOfID
            = T.ReferenceByID
        WHERE I.Layer + 1
            =  @Layer
          AND T.ReferenceOfType IN (      'V ',       'FN', 'IF', 'TF'      )

    SET @Batch = @@ROWCOUNT

    END

   SELECT E.GeneralType
        , E.GeneralSchema
        , E.GeneralObject
        , E.create_date
        , E.modify_date
        , W.Layer
        , W.Factor03 AS [KBs_SQL]
        , W.Factor01 AS [Columns]
        , W.Factor02 AS [Parameters]
        , W.Factor04 AS [ReferenceBy]
        , W.Factor05 AS [ReferenceOf]
        , ISNULL(Z.Tables_Distinct, 0) AS Tables_Distinct
        , ISNULL(Z.Tables_Contexts, 0) AS Tables_Contexts
     FROM #Base  AS E
     JOIN #Work  AS W
       ON E.GeneralID
        = W.GeneralID
LEFT JOIN
  (SELECT                I.ReferenceByID  AS GeneralID
        , COUNT(         I.ReferenceOfID) AS Tables_Contexts
        , COUNT(DISTINCT I.ReferenceOfID) AS Tables_Distinct
     FROM #DBAT  AS I
 GROUP BY I.ReferenceByID) AS Z
       ON E.GeneralID
        = Z.GeneralID
    WHERE E.GeneralType IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND E.GeneralObject NOT LIKE 'uspG[SIUD]%'
      AND E.GeneralObject NOT LIKE 'trgG[SIUD]%'
      AND E.GeneralSchema     LIKE @GeneralSchema
      AND E.GeneralObject     LIKE @GeneralObject
--    AND ISNULL(OBJECTPROPERTY(E.GeneralID, 'ExecIsWithNativeCompilation'), 0) = 0
 ORDER BY CASE E.GeneralType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , E.GeneralSchema
        , E.GeneralObject

   SELECT E.GeneralType
        , E.GeneralSchema
        , E.GeneralObject
--      , E.create_date
--      , E.modify_date
--      , W.Layer
        , Z.Executions
        ,                         CASE WHEN Z.Seconds < 3600 THEN Z.Executions ELSE CONVERT(decimal(19,00), Z.Executions * 3600.0 / Z.Seconds) END                  AS [Runs/Hour]
        , CONVERT(decimal(19,02), CASE WHEN Z.Seconds < 3600 THEN Z.Executions ELSE CONVERT(decimal(19,00), Z.Executions * 3600.0 / Z.Seconds) END * Z.Seconds_AVG) AS [Time/Hour]
        , Z.Creation
        , Z.Last_Run
--      , Z.Seconds_SUM -- total
        , Z.Seconds_AVG -- average
        , Z.Seconds_MIN -- minimum
        , Z.Seconds_MAX -- maximum
--      , Z.Seconds_LST -- last
--      , Z.LReads_SUM
        , Z.LReads_AVG
        , Z.LReads_MIN
        , Z.LReads_MAX
--      , Z.LReads_LST
--      , Z.PReads_SUM
--      , Z.PReads_AVG
--      , Z.PReads_MIN
--      , Z.PReads_MAX
--      , Z.PReads_LST
--      , Z.Writes_SUM
        , Z.Writes_AVG
        , Z.Writes_MIN
        , Z.Writes_MAX
--      , Z.Writes_LST
     FROM #Base  AS E
     JOIN #Work  AS W
       ON E.GeneralID
        = W.GeneralID
LEFT JOIN
  (SELECT S.execution_count                                   AS Executions
        , DATEDIFF(second, S.cached_time, GETDATE()) + 1      AS Seconds
        , CONVERT(varchar(0040) ,         S.cached_time, 120) AS Creation
        , CONVERT(varchar(0040) , S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_SUM
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN  S.last_elapsed_time ELSE  S.last_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_LST
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.min_elapsed_time ELSE   S.min_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MIN
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.max_elapsed_time ELSE   S.max_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MAX
        , S.total_logical_writes / S.execution_count AS Writes_AVG
        , S.total_logical_writes                     AS Writes_SUM
        ,  S.last_logical_writes                     AS Writes_LST
        ,   S.min_logical_writes                     AS Writes_MIN
        ,   S.max_logical_writes                     AS Writes_MAX
        ,  S.total_logical_reads / S.execution_count AS LReads_AVG
        ,  S.total_logical_reads                     AS LReads_SUM
        ,   S.last_logical_reads                     AS LReads_LST
        ,    S.min_logical_reads                     AS LReads_MIN
        ,    S.max_logical_reads                     AS LReads_MAX
        , S.total_physical_reads / S.execution_count AS PReads_AVG
        , S.total_physical_reads                     AS PReads_SUM
        ,  S.last_physical_reads                     AS PReads_LST
        ,   S.min_physical_reads                     AS PReads_MIN
        ,   S.max_physical_reads                     AS PReads_MAX
        ,            DB_NAME(             S.database_id) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(S.object_id, S.database_id) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(S.object_id, S.database_id) COLLATE database_default AS ObjectName
        ,                       ISNULL(S.type, SPACE(2)) COLLATE database_default AS ObjectType
     FROM
  (SELECT A.* FROM sys.dm_exec_procedure_stats AS A WHERE A.database_id = DB_ID()
    UNION
   SELECT A.* FROM sys.dm_exec_trigger_stats   AS A WHERE A.database_id = DB_ID()) AS S) AS Z
       ON E.GeneralSchema = Z.SchemaName
      AND E.GeneralObject = Z.ObjectName
    WHERE E.GeneralType IN ('P ', 'TR')
      AND E.GeneralObject NOT LIKE 'uspG[SIUD]%'
      AND E.GeneralObject NOT LIKE 'trgG[SIUD]%'
      AND E.GeneralSchema     LIKE @GeneralSchema
      AND E.GeneralObject     LIKE @GeneralObject
--    AND ISNULL(OBJECTPROPERTY(E.GeneralID, 'ExecIsWithNativeCompilation'), 0) = 0
 ORDER BY CASE E.GeneralType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , E.GeneralSchema
        , E.GeneralObject

/*

-- Columns

   SELECT T.GeneralType
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id
        , T.GeneralColumn
        , T.SQLServerType
        , T.collation_name
        , T.is_nullable
--      , T.is_identity
--      , T.[From]
--      , T.[Plus]
--      , T.[Used]
--      , T.index_column_id AS PK_column_id
--      , T.DefaultName
--      , T.DefaultCode
--      , T.FormulaCode
     FROM #TKeys AS T
    WHERE T.GeneralType IN (      'V ', 'P ', 'FN', 'IF', 'TF')
      AND T.GeneralObject NOT LIKE 'uspG[SIUD]%'
      AND T.GeneralObject NOT LIKE 'trgG[SIUD]%'
      AND T.GeneralSchema     LIKE @GeneralSchema
      AND T.GeneralObject     LIKE @GeneralObject
--    AND ISNULL(OBJECTPROPERTY(T.GeneralID, 'ExecIsWithNativeCompilation'), 0) = 0
 ORDER BY CASE T.GeneralType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id

-- Parameters

   SELECT U.GeneralType
        , U.GeneralSchema
        , U.GeneralObject
        , U.parameter_id
        , U.GeneralColumn
        , U.SQLServerType
        , U.is_nullable
        , U.is_output
     FROM #UKeys AS U
    WHERE U.GeneralType IN (            'P ', 'FN', 'IF', 'TF')
      AND U.GeneralObject NOT LIKE 'uspG[SIUD]%'
      AND U.GeneralObject NOT LIKE 'trgG[SIUD]%'
      AND U.GeneralSchema     LIKE @GeneralSchema
      AND U.GeneralObject     LIKE @GeneralObject
--    AND ISNULL(OBJECTPROPERTY(U.GeneralID, 'ExecIsWithNativeCompilation'), 0) = 0
 ORDER BY CASE U.GeneralType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , U.GeneralSchema
        , U.GeneralObject
        , U.parameter_id

-- References, external

   SELECT O.type      AS GeneralType
        , S.name      AS GeneralSchema
        , O.name      AS GeneralObject
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , CASE WHEN D.referenced_server_name   IS NULL THEN SPACE(0) ELSE                                                                           '[' + D.referenced_server_name   + ']' END
        + CASE WHEN D.referenced_database_name IS NULL THEN SPACE(0) ELSE CASE WHEN D.referenced_server_name   IS NULL THEN SPACE(0) ELSE '.' END + '[' + D.referenced_database_name + ']' END
        + CASE WHEN D.referenced_schema_name   IS NULL THEN SPACE(0) ELSE CASE WHEN D.referenced_database_name IS NULL THEN SPACE(0) ELSE '.' END + '[' + D.referenced_schema_name   + ']' END
        + CASE WHEN D.referenced_entity_name   IS NULL THEN SPACE(0) ELSE CASE WHEN D.referenced_schema_name   IS NULL THEN SPACE(0) ELSE '.' END + '[' + D.referenced_entity_name   + ']' END AS SQLServerPath
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.sql_expression_dependencies AS D
       ON O.object_id
        = D.referencing_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND D.referenced_id IS NULL
      AND S.name LIKE @GeneralSchema
      AND O.name LIKE @GeneralObject
 ORDER BY CASE O.type
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , GeneralSchema
        , GeneralObject
        , SQLServerPath

-- ReferenceBy

   SELECT T.ReferenceByType
        , T.ReferenceBySchema
        , T.ReferenceByObject
        , T.ReferenceOfType
        , T.ReferenceOfSchema
        , T.ReferenceOfObject
     FROM #Task AS T
    WHERE T.ReferenceByType IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND T.ReferenceByObject NOT LIKE 'uspG[SIUD]%'
      AND T.ReferenceByObject NOT LIKE 'trgG[SIUD]%'
      AND T.ReferenceByObject     LIKE @GeneralSchema
      AND T.ReferenceByObject     LIKE @GeneralObject
 ORDER BY CASE T.ReferenceByType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceBySchema
        , T.ReferenceByObject
        , CASE T.ReferenceOfType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceOfSchema
        , T.ReferenceOfObject

-- ReferenceBy

   SELECT T.ReferenceByType
        , T.ReferenceBySchema
        , T.ReferenceByObject
        , T.ReferenceOfType
        , T.ReferenceOfSchema
        , T.ReferenceOfObject
     FROM #Task AS T
    WHERE T.ReferenceByType IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND T.ReferenceByObject NOT LIKE 'uspG[SIUD]%'
      AND T.ReferenceByObject NOT LIKE 'trgG[SIUD]%'
      AND T.ReferenceByObject     LIKE @GeneralSchema
      AND T.ReferenceByObject     LIKE @GeneralObject
 ORDER BY CASE T.ReferenceOfType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceOfSchema
        , T.ReferenceOfObject
        , CASE T.ReferenceByType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceBySchema
        , T.ReferenceByObject

-- ReferenceOf

   SELECT T.ReferenceByType
        , T.ReferenceBySchema
        , T.ReferenceByObject
        , T.ReferenceOfType
        , T.ReferenceOfSchema
        , T.ReferenceOfObject
     FROM #Task AS T
    WHERE T.ReferenceOfType IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND T.ReferenceOfObject NOT LIKE 'uspG[SIUD]%'
      AND T.ReferenceOfObject NOT LIKE 'trgG[SIUD]%'
      AND T.ReferenceOfObject     LIKE @GeneralSchema
      AND T.ReferenceOfObject     LIKE @GeneralObject
 ORDER BY CASE T.ReferenceByType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceBySchema
        , T.ReferenceByObject
        , CASE T.ReferenceOfType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceOfSchema
        , T.ReferenceOfObject

-- ReferenceOf

   SELECT T.ReferenceByType
        , T.ReferenceBySchema
        , T.ReferenceByObject
        , T.ReferenceOfType
        , T.ReferenceOfSchema
        , T.ReferenceOfObject
     FROM #Task AS T
    WHERE T.ReferenceOfType IN (      'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
      AND T.ReferenceOfObject NOT LIKE 'uspG[SIUD]%'
      AND T.ReferenceOfObject NOT LIKE 'trgG[SIUD]%'
      AND T.ReferenceOfObject     LIKE @GeneralSchema
      AND T.ReferenceOfObject     LIKE @GeneralObject
 ORDER BY CASE T.ReferenceOfType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceOfSchema
        , T.ReferenceOfObject
        , CASE T.ReferenceByType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , T.ReferenceBySchema
        , T.ReferenceByObject

-- References, Tables

   SELECT Z.*
     FROM
  (SELECT E.GeneralType   AS ReferenceByType
        , E.GeneralSchema AS ReferenceBySchema
        , E.GeneralObject AS ReferenceByObject
        , R.Layer
        , U.GeneralType   AS ReferenceOfType
        , U.GeneralSchema AS ReferenceOfSchema
        , U.GeneralObject AS ReferenceOfObject
        , 1 AS Contexts
     FROM #DBAR AS R
     JOIN #Base AS E ON R.ReferenceByID = E.GeneralID
     JOIN #Base AS U ON R.ReferenceOfID = U.GeneralID
    WHERE R.Layer > 0
    UNION ALL
   SELECT E.GeneralType   AS ReferenceByType
        , E.GeneralSchema AS ReferenceBySchema
        , E.GeneralObject AS ReferenceByObject
        , T.Layer
        , U.GeneralType   AS ReferenceOfType
        , U.GeneralSchema AS ReferenceOfSchema
        , U.GeneralObject AS ReferenceOfObject
        , COUNT(*) AS Contexts
     FROM #DBAT AS T
     JOIN #Base AS E                                                                                                                                                                                                   ON T.ReferenceByID = E.GeneralID
     JOIN
  (SELECT S.name AS GeneralSchema
        , O.name AS GeneralObject
        , O.type AS GeneralType
        , O.object_id AS GeneralID
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
    WHERE O.type = 'U ') AS U ON T.ReferenceOfID = U.GeneralID
    WHERE T.Layer > 0
 GROUP BY E.GeneralType
        , E.GeneralSchema
        , E.GeneralObject
        , T.Layer
        , U.GeneralType
        , U.GeneralSchema
        , U.GeneralObject) AS Z
 ORDER BY CASE Z.ReferenceByType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , Z.ReferenceBySchema
        , Z.ReferenceByObject
        , Z.Layer
        , CASE Z.ReferenceOfType
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END
        , Z.ReferenceOfSchema
        , Z.ReferenceOfObject

*/

DROP TABLE #Base

DROP TABLE #Work

DROP TABLE #Task

DROP TABLE #TKey
DROP TABLE #TKeys

DROP TABLE #UKey
DROP TABLE #UKeys

DROP TABLE #DBAR
DROP TABLE #DBAT

SET NOCOUNT OFF

