/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @E datetime = GETDATE()

DECLARE @SQLService varchar(0128)

DECLARE @NamePrefix varchar(0128)

SET @SQLService  = @@SERVICENAME

SET @NamePrefix  = 'SQLServer'

IF  @SQLService != 'MSSQLSERVER' SET @NamePrefix = 'MSSQL$' + @SQLService

IF OBJECT_ID('tempdb..#CounterHistory', 'U ') IS NOT NULL DROP TABLE #CounterHistory

CREATE TABLE #CounterHistory
     ( KeyID        int NOT NULL IDENTITY(0,1)
     , KeyDT   datetime NOT NULL
     , C101      bigint NOT NULL
     , C102      bigint NOT NULL
     , C103      bigint NOT NULL
     , C104      bigint NOT NULL
     , C105      bigint NOT NULL
     , C106      bigint NOT NULL
     , C107      bigint NOT NULL
     , C108      bigint NOT NULL
     , C109      bigint NOT NULL
     , C201      bigint NOT NULL
     , C202      bigint NOT NULL
     , C203      bigint NOT NULL
     , C204      bigint NOT NULL
     , C205      bigint NOT NULL
     , C206      bigint NOT NULL
     , C207      bigint NOT NULL
     , C208      bigint NOT NULL
     , C209      bigint NOT NULL
     , C301      bigint NOT NULL
     , C302      bigint NOT NULL
     , C303      bigint NOT NULL
     , C304      bigint NOT NULL
     , C305      bigint NOT NULL
     , C306      bigint NOT NULL
     , C307      bigint NOT NULL
     , C308      bigint NOT NULL
     , C309      bigint NOT NULL
     , C501      bigint NOT NULL
     , C502      bigint NOT NULL
     , C503      bigint NOT NULL
     , C504      bigint NOT NULL
     , C505      bigint NOT NULL
     , C506      bigint NOT NULL
     , C507      bigint NOT NULL
     , C508      bigint NOT NULL
     , C509      bigint NOT NULL )

IF OBJECT_ID('tempdb..#Counter', 'U ') IS NOT NULL DROP TABLE #Counter

CREATE TABLE #Counter
     ( KeyID               smallint NOT NULL
     , object_name    varchar(0128) NOT NULL
     , counter_name   varchar(0128) NOT NULL
     , instance_name  varchar(0128) NOT NULL )

INSERT #Counter SELECT 101, ':Buffer Manager'        , 'Buffer cache hit ratio'       , ''
INSERT #Counter SELECT 201, ':Buffer Manager'        , 'Buffer cache hit ratio base'  , ''
INSERT #Counter SELECT 102, ':Plan Cache'            , 'Cache Hit Ratio'              , 'Object Plans'
INSERT #Counter SELECT 202, ':Plan Cache'            , 'Cache Hit Ratio Base'         , 'Object Plans'
INSERT #Counter SELECT 103, ':Plan Cache'            , 'Cache Hit Ratio'              , 'SQL Plans'
INSERT #Counter SELECT 203, ':Plan Cache'            , 'Cache Hit Ratio Base'         , 'SQL Plans'
INSERT #Counter SELECT 104, ':Plan Cache'            , 'Cache Pages'                  , 'Object Plans'
INSERT #Counter SELECT 204, ':Plan Cache'            , 'Cache Object Counts'          , 'Object Plans'
INSERT #Counter SELECT 105, ':Plan Cache'            , 'Cache Pages'                  , 'SQL Plans'
INSERT #Counter SELECT 205, ':Plan Cache'            , 'Cache Object Counts'          , 'SQL Plans'

INSERT #Counter SELECT 301, ':Buffer Manager'        , 'Page life expectancy'         , ''
INSERT #Counter SELECT 302, ':Buffer Manager'        , 'Database pages'               , ''
INSERT #Counter SELECT 303, ':Memory Manager'        , 'Database Cache Memory (KB)'   , ''
INSERT #Counter SELECT 304, ':Memory Manager'        , 'Total Server Memory (KB)'     , ''
INSERT #Counter SELECT 305, ':Memory Manager'        , 'Target Server Memory (KB)'    , ''
INSERT #Counter SELECT 306, ':Memory Manager'        , 'Lock Memory (KB)'             , ''
INSERT #Counter SELECT 307, ':Memory Manager'        , 'Granted Workspace Memory (KB)', ''
INSERT #Counter SELECT 308, ':Memory Manager'        , 'Memory Grants Outstanding'    , ''
INSERT #Counter SELECT 309, ':Memory Manager'        , 'Memory Grants Pending'        , ''

       INSERT #CounterHistory
       SELECT W.KeyDT
            , W.C101
            , W.C102
            , W.C103
            , W.C104
            , W.C105
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'ma% parallelism') AS C106
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'co% parallelism') AS C107
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'min%memory (MB)') AS C108
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'max%memory (MB)') AS C109
            , W.C201
            , W.C202
            , W.C203
            , W.C204
            , W.C205
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'nested triggers') AS C206
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'opt%for ad hoc%') AS C207
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'Agent XPs'      ) AS C208
            , (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE '%Mail XPs'      ) AS C209
            , W.C301
            , W.C302
            , W.C303
            , W.C304
            , W.C305
            , W.C306
            , W.C307
            , W.C308
            , W.C309
            , O.physical_memory_kb                AS C501 -- SQL Server 2012 and newer
--          , O.physical_memory_in_bytes / 1024.0 AS C501 -- less than SQL Server 2012
            , O.cpu_count AS C502
            , Z.C503
            , Z.C504
            , Z.C505
            , Z.C506
            , Z.C507
            , Z.C508
            , Z.C509
         FROM
      (SELECT @E AS KeyDT
            , MAX(CASE WHEN T.KeyID = 101 THEN I.cntr_value ELSE 0 END) AS C101
            , MAX(CASE WHEN T.KeyID = 102 THEN I.cntr_value ELSE 0 END) AS C102
            , MAX(CASE WHEN T.KeyID = 103 THEN I.cntr_value ELSE 0 END) AS C103
            , MAX(CASE WHEN T.KeyID = 104 THEN I.cntr_value ELSE 0 END) AS C104
            , MAX(CASE WHEN T.KeyID = 105 THEN I.cntr_value ELSE 0 END) AS C105
            , MAX(CASE WHEN T.KeyID = 201 THEN I.cntr_value ELSE 0 END) AS C201
            , MAX(CASE WHEN T.KeyID = 202 THEN I.cntr_value ELSE 0 END) AS C202
            , MAX(CASE WHEN T.KeyID = 203 THEN I.cntr_value ELSE 0 END) AS C203
            , MAX(CASE WHEN T.KeyID = 204 THEN I.cntr_value ELSE 0 END) AS C204
            , MAX(CASE WHEN T.KeyID = 205 THEN I.cntr_value ELSE 0 END) AS C205
            , MAX(CASE WHEN T.KeyID = 301 THEN I.cntr_value ELSE 0 END) AS C301
            , MAX(CASE WHEN T.KeyID = 302 THEN I.cntr_value ELSE 0 END) AS C302
            , MAX(CASE WHEN T.KeyID = 303 THEN I.cntr_value ELSE 0 END) AS C303
            , MAX(CASE WHEN T.KeyID = 304 THEN I.cntr_value ELSE 0 END) AS C304
            , MAX(CASE WHEN T.KeyID = 305 THEN I.cntr_value ELSE 0 END) AS C305
            , MAX(CASE WHEN T.KeyID = 306 THEN I.cntr_value ELSE 0 END) AS C306
            , MAX(CASE WHEN T.KeyID = 307 THEN I.cntr_value ELSE 0 END) AS C307
            , MAX(CASE WHEN T.KeyID = 308 THEN I.cntr_value ELSE 0 END) AS C308
            , MAX(CASE WHEN T.KeyID = 309 THEN I.cntr_value ELSE 0 END) AS C309
         FROM sys.dm_os_performance_counters AS I
         JOIN #Counter AS T
           ON RTRIM(I.object_name  ) = @NamePrefix + T.object_name
          AND RTRIM(I.counter_name ) =               T.counter_name
          AND RTRIM(I.instance_name) =               T.instance_name) AS W,
      (SELECT SUM(                              1           ) AS C503
            , SUM(CASE WHEN S.is_idle != 0 THEN 1 ELSE 0 END) AS C504
            , SUM(S.current_workers_count                   ) AS C505
            , SUM(S.runnable_tasks_count                    ) AS C506
            , SUM(S.current_tasks_count                     )
            + SUM(S.work_queue_count                        ) AS C507
            , SUM(S.work_queue_count                        ) AS C508
            , SUM(S.pending_disk_io_count                   ) AS C509
         FROM sys.dm_os_schedulers AS S
        WHERE S.scheduler_id < 255
          AND S.is_online != 0) AS Z, sys.dm_os_sys_info AS O

   SELECT CONVERT(varchar(20), T.KeyDT, 120) AS [Date_Time]
        , CONVERT(decimal(09,02), CASE WHEN T.C201 = 0 THEN 0.0 ELSE (T.C101 * 100.0) / T.C201 END) AS BCHR
        , T.C301 AS Page_Life
        , T.C309 AS RAM_stalls
        , T.C308 AS RAM_grants
        , CONVERT(decimal(19,05), T.C307 / 1024.0 / 1024.0) AS GBs_RAM_task
        , CONVERT(decimal(19,05), T.C306 / 1024.0 / 1024.0) AS GBs_RAM_lock
        , CONVERT(decimal(19,05), T.C303 / 1024.0 / 1024.0) AS GBs_RAM_disk -- SQL Server 2012 and newer
--      , CONVERT(decimal(19,05), T.C302 /  128.0 / 1024.0) AS GBs_RAM_disk -- less than SQL Server 2012
        , CONVERT(decimal(19,05), T.C304 / 1024.0 / 1024.0) AS GBs_RAM_total
        , CONVERT(decimal(19,05), T.C305 / 1024.0 / 1024.0) AS GBs_RAM_ideal
        , CONVERT(decimal(19,05), T.C501 / 1024.0 / 1024.0) AS GBs_RAM_final
        , CONVERT(decimal(19,05), T.C108          / 1024.0) AS GBs_Server_Min
        , CONVERT(decimal(19,05), T.C109          / 1024.0) AS GBs_Server_Max
     FROM #CounterHistory AS T

   SELECT CONVERT(varchar(20), T.KeyDT, 120) AS [Date_Time]
        , CONVERT(decimal(09,02), CASE WHEN T.C202 = 0 THEN 0.0 ELSE (T.C102 * 100.0) / T.C202 END) AS PCHR_object
        , CONVERT(decimal(09,02), CASE WHEN T.C203 = 0 THEN 0.0 ELSE (T.C103 * 100.0) / T.C203 END) AS PCHR_ad_hoc
        , T.C204 AS Tally_PC_object
        , T.C205 AS Tally_PC_ad_hoc
        , CONVERT(decimal(19,05), T.C104 /  128.0 / 1024.0) AS GBs_PC_object
        , CONVERT(decimal(19,05), T.C105 /  128.0 / 1024.0) AS GBs_PC_ad_hoc
        , CONVERT(decimal(19,02), CASE WHEN T.C204 = 0 THEN 0.0 ELSE T.C104 * 8.0 / T.C204 END) AS KBs_Each_object
        , CONVERT(decimal(19,02), CASE WHEN T.C205 = 0 THEN 0.0 ELSE T.C105 * 8.0 / T.C205 END) AS KBs_Each_ad_hoc
        , T.C502          AS CPUs_All
        , T.C503          AS CPUs_SQL
        , T.C504          AS CPUs_Idle
--      , T.C505          AS Workers_All
--      , T.C506          AS Workers_Wait
--      , T.C507          AS Tasks_All
--      , T.C508          AS Tasks_Wait
--      , T.C509          AS Pending_IOs
        , T.C106          AS DOP_Max
        , T.C107          AS DOP_Cost
     FROM #CounterHistory AS T

   SELECT E.session_id
--      , E.request_id
        , E.login_time
        , E.login_name
        , E.host_name
        , E.program_name
        , E.batch_time
--      , E.DB_session
        , E.DB_request
        , E.run_time
        , E.cpu_time
        , E.GBs_request
        , E.GBs_granted
        , E.GBs_used
        , E.GBs_used_max
--      , E.CostEstimate
        , E.DOP
--      , E.DBName
--      , E.SchemaName
--      , E.ObjectName
--      , E.ObjectType
--      , E.command
        , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
        ,           E.text                  AS SQL_code_all
     FROM
  (SELECT P.is_user_process
        , P.session_id
        , R.request_id
        , CONVERT(varchar(40), P.login_time             , 120) AS login_time
        , P.login_name
        , P.host_name
        , P.program_name
        , CONVERT(varchar(40), P.last_request_start_time, 120) AS batch_time
--      , DB_NAME(P.database_id) AS DB_session
        , DB_NAME(R.database_id) AS DB_request
        , CONVERT(varchar(0010), R.total_elapsed_time / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, R.total_elapsed_time % 86400000, 0), 114) AS run_time
        , CONVERT(varchar(0010), R.cpu_time           / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, R.cpu_time           % 86400000, 0), 114) AS cpu_time
        ,            DB_NAME(            T.dbid) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(T.objectid, T.dbid) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(T.objectid, T.dbid) COLLATE database_default AS ObjectName
        ,                               SPACE(2) COLLATE database_default AS ObjectType
        , R.command
        , CASE WHEN R.statement_start_offset < 0 THEN     0                                                                            ELSE (R.statement_start_offset / 2)     END + 1 AS I
        , CASE WHEN R.statement_end_offset   < 0 THEN LEN(T.text) WHEN R.statement_end_offset > (LEN(T.text) * 2) - 4 THEN LEN(T.text) ELSE (R.statement_end_offset   / 2) + 1 END + 1 AS O
        , T.text COLLATE database_default AS text
        , CONVERT(decimal(19,05), G.requested_memory_kb / 1024.0 / 1024.0) AS GBs_request
        , CONVERT(decimal(19,05), G.granted_memory_kb   / 1024.0 / 1024.0) AS GBs_granted
        , CONVERT(decimal(19,05), G.used_memory_kb      / 1024.0 / 1024.0) AS GBs_used
        , CONVERT(decimal(19,05), G.max_used_memory_kb  / 1024.0 / 1024.0) AS GBs_used_max
        , CONVERT(decimal(19,05), G.query_cost                           ) AS CostEstimate
        , G.dop AS DOP
     FROM sys.dm_exec_sessions AS P
     JOIN sys.dm_exec_requests AS R
       ON P.session_id
        = R.session_id
     JOIN sys.dm_exec_query_memory_grants AS G
       ON R.session_id
        = G.session_id
      AND R.request_id
        = G.request_id
    OUTER APPLY sys.dm_exec_sql_text(R.sql_handle) AS T OUTER APPLY sys.dm_exec_query_plan(R.plan_handle) AS V
    WHERE P.session_id != @@SPID
      AND P.is_user_process != 0) AS E
 ORDER BY E.session_id
        , E.request_id

DROP TABLE #Counter

DROP TABLE #CounterHistory

SET NOCOUNT OFF

