/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

USE tempdb

DECLARE @Action TABLE
     ( database_id              int
     , file_id                  int
     , DBFile         varchar(0128)
     , DBPath         varchar(0256)
     , type                 tinyint
     , used                  bigint
     , size                  bigint
     , max_size                 int
     , growth                   int
     , is_percent               bit
     , is_default               bit
     , FGName         varchar(0128)
     , [Seconds]     decimal(19,05)
     , Stall_Reads   decimal(19,05)
     , Stall_Writes  decimal(19,05)
     , MBs_Reads     decimal(19,05)
     , MBs_Writes    decimal(19,05)
     , Tally_Reads           bigint
     , Tally_Writes          bigint )

   INSERT @Action
   SELECT DB_ID()
        , F.file_id
        , F.name          AS DBFile
        , F.physical_name AS DBPath
        , F.type          AS type
        , FILEPROPERTY(F.name, 'SpaceUsed') AS used
        , F.size
        , F.max_size
        , F.growth
        , F.is_percent_growth AS is_percent
        , H.is_default
        , H.name AS FGName
        , CONVERT(decimal(19,05), V.sample_ms            / 1000.0         ) AS [Seconds]
        , CONVERT(decimal(19,05), V.io_stall_read_ms     / 1000.0         ) AS Stall_Reads
        , CONVERT(decimal(19,05), V.io_stall_write_ms    / 1000.0         ) AS Stall_Writes
        , CONVERT(decimal(19,05), V.num_of_bytes_read    / 1024.0 / 1024.0) AS MBs_Reads
        , CONVERT(decimal(19,05), V.num_of_bytes_written / 1024.0 / 1024.0) AS MBs_Writes
        , V.num_of_reads  AS Tally_Reads
        , V.num_of_writes AS Tally_Writes
     FROM sys.database_files AS F CROSS APPLY sys.dm_io_virtual_file_stats(DB_ID(), F.file_id) AS V
LEFT JOIN sys.data_spaces    AS H
       ON F.data_space_id
        = H.data_space_id

   SELECT 'tempdb' AS DBName
        , W.Files_Data
        , CONVERT(decimal(19,05), (W.Pages_Size_SUM                   ) / 128.0 / 1024.0) AS GBs_Size_Data
        , CONVERT(decimal(19,05), (                   W.Pages_Used_SUM) / 128.0 / 1024.0) AS GBs_Used_Data
        , CONVERT(decimal(19,05), (W.Pages_Size_SUM - W.Pages_Used_SUM) / 128.0 / 1024.0) AS GBs_Free_Data
        , CONVERT(decimal(05,02), (                   W.Pages_Used_SUM) * 100.0 / W.Pages_Size_SUM) AS Percent_Used
        , CONVERT(decimal(05,02), (W.Pages_Size_SUM - W.Pages_Used_SUM) * 100.0 / W.Pages_Size_SUM) AS Percent_Free
--      , CONVERT(decimal(19,05), (W.Pages_Size_MIN                   ) / 128.0 / 1024.0) AS GBs_File_MIN
--      , CONVERT(decimal(19,05), (W.Pages_Size_MAX                   ) / 128.0 / 1024.0) AS GBs_File_MAX
     FROM
  (SELECT MIN(CASE WHEN S.type = 0 THEN S.size ELSE NULL END) AS Pages_Size_MIN
        , MAX(CASE WHEN S.type = 0 THEN S.size ELSE NULL END) AS Pages_Size_MAX
        , SUM(CASE WHEN S.type = 0 THEN S.size ELSE 0    END) AS Pages_Size_SUM
        , SUM(CASE WHEN S.type = 1 THEN S.size ELSE 0    END) AS Pages_Size_Log
        , SUM(CASE WHEN S.type = 0 THEN S.used ELSE 0    END) AS Pages_Used_SUM
        , SUM(CASE WHEN S.type = 1 THEN S.used ELSE 0    END) AS Pages_Used_Log
        , SUM(CASE WHEN S.type = 0 THEN 1      ELSE 0    END) AS Files_Data
        , SUM(CASE WHEN S.type = 1 THEN 1      ELSE 0    END) AS Files_Log
     FROM @Action AS S) AS W

   SELECT 'tempdb' AS DBName
        , W.Files_Log
        , CONVERT(decimal(19,05), (W.Pages_Size_Log                   ) / 128.0 / 1024.0) AS GBs_Size_Log
        , CONVERT(decimal(19,05), (                   W.Pages_Used_Log) / 128.0 / 1024.0) AS GBs_Used_Log
        , CONVERT(decimal(19,05), (W.Pages_Size_Log - W.Pages_Used_Log) / 128.0 / 1024.0) AS GBs_Free_Log
        , CONVERT(decimal(05,02), (                   W.Pages_Used_Log) * 100.0 / W.Pages_Size_Log) AS Percent_Used
        , CONVERT(decimal(05,02), (W.Pages_Size_Log - W.Pages_Used_Log) * 100.0 / W.Pages_Size_Log) AS Percent_Free
     FROM
  (SELECT MIN(CASE WHEN S.type = 0 THEN S.size ELSE NULL END) AS Pages_Size_MIN
        , MAX(CASE WHEN S.type = 0 THEN S.size ELSE NULL END) AS Pages_Size_MAX
        , SUM(CASE WHEN S.type = 0 THEN S.size ELSE 0    END) AS Pages_Size_SUM
        , SUM(CASE WHEN S.type = 1 THEN S.size ELSE 0    END) AS Pages_Size_Log
        , SUM(CASE WHEN S.type = 0 THEN S.used ELSE 0    END) AS Pages_Used_SUM
        , SUM(CASE WHEN S.type = 1 THEN S.used ELSE 0    END) AS Pages_Used_Log
        , SUM(CASE WHEN S.type = 0 THEN 1      ELSE 0    END) AS Files_Data
        , SUM(CASE WHEN S.type = 1 THEN 1      ELSE 0    END) AS Files_Log
     FROM @Action AS S) AS W

   SELECT 'tempdb' AS DBName
        , S.FGName
        , S.DBFile
        , S.DBPath
--      , V.volume_mount_point AS FSPath
        , CASE WHEN S.is_percent  = 0 THEN  0       ELSE CONVERT(decimal(09,00), S.growth                   ) END AS [Percent_File]
        , CASE WHEN S.is_percent != 0 THEN  0.00000 ELSE CONVERT(decimal(19,05), S.growth   / 128.0 / 1024.0) END AS [GBs_ADD_File]
        , CASE WHEN S.max_size    < 0 THEN -1.00000 ELSE CONVERT(decimal(19,05), S.max_size / 128.0 / 1024.0) END AS [GBs_MAX_File]
        , CONVERT(decimal(19,05), (S.size         ) / 128.0 / 1024.0) AS GBs_Size_File
        , CONVERT(decimal(19,05), (         S.used) / 128.0 / 1024.0) AS GBs_Used_File
        , CONVERT(decimal(19,05), (S.size - S.used) / 128.0 / 1024.0) AS GBs_Free_File
--      , CONVERT(decimal(05,02), (         S.used) * 100.0 / S.size) AS Percent_Used_File
--      , CONVERT(decimal(05,02), (S.size - S.used) * 100.0 / S.size) AS Percent_Free_File
        , CONVERT(decimal(19,05), (V.total_bytes                    ) / 1024.0 / 1024.0 / 1024.0) AS GBs_Size_Disk
        , CONVERT(decimal(19,05), (V.total_bytes - V.available_bytes) / 1024.0 / 1024.0 / 1024.0) AS GBs_Used_Disk
        , CONVERT(decimal(19,05), (                V.available_bytes) / 1024.0 / 1024.0 / 1024.0) AS GBs_Free_Disk
--      , CONVERT(decimal(05,02), (V.total_bytes - V.available_bytes) * 100.0 / V.total_bytes) AS Percent_Used_Disk
--      , CONVERT(decimal(05,02), (                V.available_bytes) * 100.0 / V.total_bytes) AS Percent_Free_Disk
        , CONVERT(decimal(19,05), S.Stall_Reads  / CASE WHEN S.Tally_Reads  = 0   THEN 1   ELSE S.Tally_Reads  END) AS Stall_Per_Read
        , CONVERT(decimal(19,05), S.Stall_Writes / CASE WHEN S.Tally_Writes = 0   THEN 1   ELSE S.Tally_Writes END) AS Stall_Per_Write
        , CONVERT(decimal(19,05), S.Stall_Reads  / CASE WHEN S.MBs_Reads    = 0.0 THEN 1.0 ELSE S.MBs_Reads    END) AS Stall_MB_Read
        , CONVERT(decimal(19,05), S.Stall_Writes / CASE WHEN S.MBs_Writes   = 0.0 THEN 1.0 ELSE S.MBs_Writes   END) AS Stall_MB_Write
     FROM @Action AS S CROSS APPLY sys.dm_os_volume_stats(S.database_id, S.file_id) AS V
    WHERE S.type = 0
 ORDER BY S.FGName
        , S.DBFile

   SELECT 'tempdb' AS DBName
        , S.FGName
        , S.DBFile
        , S.DBPath
--      , V.volume_mount_point AS FSPath
        , CASE WHEN S.is_percent  = 0 THEN  0       ELSE CONVERT(decimal(09,00), S.growth                   ) END AS [Percent_File]
        , CASE WHEN S.is_percent != 0 THEN  0.00000 ELSE CONVERT(decimal(19,05), S.growth   / 128.0 / 1024.0) END AS [GBs_ADD_File]
        , CASE WHEN S.max_size    < 0 THEN -1.00000 ELSE CONVERT(decimal(19,05), S.max_size / 128.0 / 1024.0) END AS [GBs_MAX_File]
        , CONVERT(decimal(19,05), (S.size         ) / 128.0 / 1024.0) AS GBs_Size_File
        , CONVERT(decimal(19,05), (         S.used) / 128.0 / 1024.0) AS GBs_Used_File
        , CONVERT(decimal(19,05), (S.size - S.used) / 128.0 / 1024.0) AS GBs_Free_File
--      , CONVERT(decimal(05,02), (         S.used) * 100.0 / S.size) AS Percent_Used_File
--      , CONVERT(decimal(05,02), (S.size - S.used) * 100.0 / S.size) AS Percent_Free_File
        , CONVERT(decimal(19,05), (V.total_bytes                    ) / 1024.0 / 1024.0 / 1024.0) AS GBs_Size_Disk
        , CONVERT(decimal(19,05), (V.total_bytes - V.available_bytes) / 1024.0 / 1024.0 / 1024.0) AS GBs_Used_Disk
        , CONVERT(decimal(19,05), (                V.available_bytes) / 1024.0 / 1024.0 / 1024.0) AS GBs_Free_Disk
--      , CONVERT(decimal(05,02), (V.total_bytes - V.available_bytes) * 100.0 / V.total_bytes) AS Percent_Used_Disk
--      , CONVERT(decimal(05,02), (                V.available_bytes) * 100.0 / V.total_bytes) AS Percent_Free_Disk
        , CONVERT(decimal(19,05), S.Stall_Reads  / CASE WHEN S.Tally_Reads  = 0   THEN 1   ELSE S.Tally_Reads  END) AS Stall_Per_Read
        , CONVERT(decimal(19,05), S.Stall_Writes / CASE WHEN S.Tally_Writes = 0   THEN 1   ELSE S.Tally_Writes END) AS Stall_Per_Write
        , CONVERT(decimal(19,05), S.Stall_Reads  / CASE WHEN S.MBs_Reads    = 0.0 THEN 1.0 ELSE S.MBs_Reads    END) AS Stall_MB_Read
        , CONVERT(decimal(19,05), S.Stall_Writes / CASE WHEN S.MBs_Writes   = 0.0 THEN 1.0 ELSE S.MBs_Writes   END) AS Stall_MB_Write
     FROM @Action AS S CROSS APPLY sys.dm_os_volume_stats(S.database_id, S.file_id) AS V
    WHERE CASE WHEN S.database_id = 1 THEN 0
               WHEN S.database_id = 2 THEN 1
               WHEN S.database_id = 3 THEN 0
               WHEN S.database_id = 4 THEN 0 ELSE 1 END != 0
      AND S.type = 1
 ORDER BY S.FGName
        , S.DBFile

   SELECT 'tempdb' AS DBName
        , O.type AS GeneralType
        , SUM(CASE WHEN O.name NOT LIKE '#%'                                                                           THEN 1 ELSE 0 END) AS Permanent
        , SUM(CASE WHEN O.name     LIKE '#%[_][_][_]%[0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F]' THEN 1 ELSE 0 END) AS Temporary
        , SUM(CASE WHEN O.name     LIKE            '#[0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F]' THEN 1 ELSE 0 END) AS OtherType
     FROM tempdb.sys.objects AS O
    WHERE O.type IN ('U ', 'V ', 'P ', 'FN', 'IF', 'TF', 'TR')
 GROUP BY O.type
 ORDER BY CASE O.type
          WHEN 'U ' THEN 1
          WHEN 'V ' THEN 2
          WHEN 'P ' THEN 3
          WHEN 'FN' THEN 4
          WHEN 'IF' THEN 5
          WHEN 'TF' THEN 6
          WHEN 'TR' THEN 7 ELSE 8 END

   SELECT P.session_id
        , CONVERT(varchar(40), P.login_time             , 120) AS login_time
        , P.login_name
        , P.host_name
        , P.program_name
        , CONVERT(varchar(40), P.last_request_start_time, 120) AS batch_time
--      , DB_NAME(P.database_id) AS DB_session
        , DB_NAME(R.database_id) AS DB_request
        , CONVERT(varchar(0010), R.total_elapsed_time / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, R.total_elapsed_time % 86400000, 0), 114) AS run_time
        , CONVERT(varchar(0010), R.cpu_time           / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, R.cpu_time           % 86400000, 0), 114) AS cpu_time
        , CONVERT(decimal(19,05), R.granted_query_memory / 128.0 / 1024.0) AS GBs_RAM
        , DB_NAME(W.database_id) AS DB_affected
--      , CONVERT(decimal(19,05), (W.user_objects_alloc_page_count                                            ) / 128.0 / 1024.0) AS GBs_session_user_all
        , CONVERT(decimal(19,05), (W.user_objects_alloc_page_count     - W.user_objects_dealloc_page_count    ) / 128.0 / 1024.0) AS GBs_session_user
--      , CONVERT(decimal(19,05), (W.internal_objects_alloc_page_count                                        ) / 128.0 / 1024.0) AS GBs_session_auto_all
        , CONVERT(decimal(19,05), (W.internal_objects_alloc_page_count - W.internal_objects_dealloc_page_count) / 128.0 / 1024.0) AS GBs_session_auto
--      , CONVERT(decimal(19,05), (Z.user_objects_alloc_page_count                                            ) / 128.0 / 1024.0) AS GBs_request_user_all
        , CONVERT(decimal(19,05), (Z.user_objects_alloc_page_count     - Z.user_objects_dealloc_page_count    ) / 128.0 / 1024.0) AS GBs_request_user
--      , CONVERT(decimal(19,05), (Z.internal_objects_alloc_page_count                                        ) / 128.0 / 1024.0) AS GBs_request_auto_all
        , CONVERT(decimal(19,05), (Z.internal_objects_alloc_page_count - Z.internal_objects_dealloc_page_count) / 128.0 / 1024.0) AS GBs_request_auto
     FROM sys.dm_exec_sessions AS P
LEFT JOIN sys.dm_exec_requests AS R
       ON P.session_id
        = R.session_id
     JOIN
  (SELECT U.session_id
        , U.database_id
        , U.user_objects_alloc_page_count
        , U.user_objects_dealloc_page_count
        , U.internal_objects_alloc_page_count
        , U.internal_objects_dealloc_page_count
     FROM sys.dm_db_session_space_usage AS U) AS W
       ON P.session_id
        = W.session_id
     JOIN
  (SELECT U.session_id
        , SUM(U.user_objects_alloc_page_count      ) AS user_objects_alloc_page_count
        , SUM(U.user_objects_dealloc_page_count    ) AS user_objects_dealloc_page_count
        , SUM(U.internal_objects_alloc_page_count  ) AS internal_objects_alloc_page_count
        , SUM(U.internal_objects_dealloc_page_count) AS internal_objects_dealloc_page_count
     FROM sys.dm_db_task_space_usage AS U
 GROUP BY U.session_id) AS Z
       ON P.session_id
        = Z.session_id
    WHERE W.user_objects_alloc_page_count
        + W.internal_objects_alloc_page_count
        + Z.user_objects_alloc_page_count
        + Z.internal_objects_alloc_page_count > 0
 ORDER BY P.session_id

SET NOCOUNT OFF

