/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

USE tempdb

   SELECT 'tempdb' AS DBName
        , CONVERT(decimal(19,05), (T.Pages_Size_SUM                                                           ) / 128.0 / 1024.0)           AS GBs_size
        , CONVERT(decimal(19,05), (W.user_objects_alloc_page_count     - W.user_objects_dealloc_page_count    ) / 128.0 / 1024.0)           AS GBs_session_user
        , CONVERT(decimal(19,05), (W.internal_objects_alloc_page_count - W.internal_objects_dealloc_page_count) / 128.0 / 1024.0)           AS GBs_session_auto
        , CONVERT(decimal(19,05), (Z.user_objects_alloc_page_count     - Z.user_objects_dealloc_page_count    ) / 128.0 / 1024.0)           AS GBs_request_user
        , CONVERT(decimal(19,05), (Z.internal_objects_alloc_page_count - Z.internal_objects_dealloc_page_count) / 128.0 / 1024.0)           AS GBs_request_auto
        , CONVERT(decimal(19,05), (V.reserved_page_count                                                      ) / 128.0 / 1024.0)           AS GBs_version_store
        , CONVERT(decimal(05,02), (W.user_objects_alloc_page_count     - W.user_objects_dealloc_page_count    ) * 100.0 / T.Pages_Size_SUM) AS Percent_session_user
        , CONVERT(decimal(05,02), (W.internal_objects_alloc_page_count - W.internal_objects_dealloc_page_count) * 100.0 / T.Pages_Size_SUM) AS Percent_session_auto
        , CONVERT(decimal(05,02), (Z.user_objects_alloc_page_count     - Z.user_objects_dealloc_page_count    ) * 100.0 / T.Pages_Size_SUM) AS Percent_request_user
        , CONVERT(decimal(05,02), (Z.internal_objects_alloc_page_count - Z.internal_objects_dealloc_page_count) * 100.0 / T.Pages_Size_SUM) AS Percent_request_auto
        , CONVERT(decimal(05,02), (V.reserved_page_count                                                      ) * 100.0 / T.Pages_Size_SUM) AS Percent_version_store
     FROM
  (SELECT SUM(U.user_objects_alloc_page_count      ) AS user_objects_alloc_page_count
        , SUM(U.user_objects_dealloc_page_count    ) AS user_objects_dealloc_page_count
        , SUM(U.internal_objects_alloc_page_count  ) AS internal_objects_alloc_page_count
        , SUM(U.internal_objects_dealloc_page_count) AS internal_objects_dealloc_page_count
     FROM sys.dm_db_session_space_usage         AS U) AS W,
  (SELECT SUM(U.user_objects_alloc_page_count      ) AS user_objects_alloc_page_count
        , SUM(U.user_objects_dealloc_page_count    ) AS user_objects_dealloc_page_count
        , SUM(U.internal_objects_alloc_page_count  ) AS internal_objects_alloc_page_count
        , SUM(U.internal_objects_dealloc_page_count) AS internal_objects_dealloc_page_count
     FROM sys.dm_db_task_space_usage            AS U) AS Z,
  (SELECT SUM(U.reserved_page_count                ) AS reserved_page_count
     FROM sys.dm_tran_version_store_space_usage AS U) AS V,
  (SELECT MIN(CASE WHEN F.type = 0 THEN F.size ELSE NULL END) AS Pages_Size_MIN
        , MAX(CASE WHEN F.type = 0 THEN F.size ELSE NULL END) AS Pages_Size_MAX
        , SUM(CASE WHEN F.type = 0 THEN F.size ELSE 0    END) AS Pages_Size_SUM
        , SUM(CASE WHEN F.type = 0 THEN 1      ELSE 0    END) AS Files_Data
     FROM tempdb.sys.database_files AS F) AS T

   SELECT DB_NAME(V.database_id) AS DBName
        , CONVERT(decimal(19,05), V.reserved_page_count / 128.0 / 1024.0)           AS GBs_version_store
        , CONVERT(decimal(05,02), V.reserved_page_count * 100.0 / T.Pages_Size_SUM) AS Percent_version_store
     FROM sys.dm_tran_version_store_space_usage AS V,
  (SELECT MIN(CASE WHEN F.type = 0 THEN F.size ELSE NULL END) AS Pages_Size_MIN
        , MAX(CASE WHEN F.type = 0 THEN F.size ELSE NULL END) AS Pages_Size_MAX
        , SUM(CASE WHEN F.type = 0 THEN F.size ELSE 0    END) AS Pages_Size_SUM
        , SUM(CASE WHEN F.type = 0 THEN 1      ELSE 0    END) AS Files_Data
     FROM tempdb.sys.database_files AS F) AS T
 ORDER BY CASE WHEN V.database_id = 1 THEN 1
               WHEN V.database_id = 2 THEN 4
               WHEN V.database_id = 3 THEN 2
               WHEN V.database_id = 4 THEN 3 ELSE 5 END
        , DB_NAME(V.database_id)

SET NOCOUNT OFF

