/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @GeneralSchema varchar(0128) = '%' -- enter schema name here, use LIKE wildcards as necessary

DECLARE @GeneralObject varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary

DECLARE @Pages int =  20 -- minimum number of data pages

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

PRINT CHAR(13) + CHAR(10)

PRINT 'Nature PK means primary   key'
PRINT 'Nature AK means alternate key (unique constraint)'
PRINT 'Nature U  means unique'
PRINT 'Nature UF means unique filtered'
PRINT 'Nature S  means simple'
PRINT 'Nature SF means simple filtered'

PRINT CHAR(13) + CHAR(10)

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

PRINT 'index_type 0 means a table as heap'
PRINT 'index_type 1 means a table as clustered index'
PRINT 'index_type 5 means a table as clustered index (columnstore)'
PRINT 'index_type 2 means a       nonclustered index'
PRINT 'index_type 6 means a       nonclustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

IF OBJECT_ID('tempdb..#ZKey', 'U ') IS NOT NULL DROP TABLE #ZKey

IF OBJECT_ID('tempdb..#Task', 'U ') IS NOT NULL DROP TABLE #Task

IF OBJECT_ID('tempdb..#Hack', 'U ') IS NOT NULL DROP TABLE #Hack

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , C.name      AS GeneralColumn
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , I.is_unique
        , I.is_disabled
        , ISNULL(I.filter_definition, SPACE(0)) AS GeneralFilter
        , E.index_rows
        , E.index_rows                                     AS Threshold
        , CONVERT(bigint,      E.index_rows * 0.20 ) + 500 AS Version14
        , CONVERT(bigint, SQRT(E.index_rows * 1000))       AS Version16
        , W.Pages
        , T.name
     INTO #ZKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
      AND M.key_ordinal = 1
LEFT JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
     JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(P.rows) AS index_rows
     FROM sys.partitions AS P
 GROUP BY P.object_id
        , P.index_id)    AS E
       ON I.object_id
        = E.object_id
      AND I.index_id
        = E.index_id
     JOIN
  (SELECT I.object_id
        , I.index_id
        , SUM(A.total_pages) AS Pages
     FROM sys.indexes    AS I
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type != 0
 GROUP BY I.object_id
        , I.index_id)          AS W
       ON I.object_id
        = W.object_id
      AND I.index_id
        = W.index_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
      AND S.name LIKE @GeneralSchema
      AND O.name LIKE @GeneralObject
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName

   UPDATE Z SET table_type = CASE WHEN E.GeneralType = 'V ' THEN 0 - E.index_type ELSE E.index_type END
     FROM #ZKey AS Z
     JOIN #ZKey AS E
       ON Z.GeneralID
        = E.GeneralID
      AND E.index_type IN (0, 1, 5)

   UPDATE #ZKey SET Threshold = CASE WHEN index_rows !> 500 THEN 500 ELSE CASE WHEN Version16 < Version14 THEN Version16 ELSE Version14 END END

   SELECT T.object_id
        , I.index_id
        , T.stats_id
        , COUNT(*) AS histogram
        , CONVERT(decimal(19,05),    AVG(E.equal_rows + E.range_rows)) AS Average
        , CONVERT(decimal(19,05), STDEVP(E.equal_rows + E.range_rows)) AS Deviate
     INTO #Task
     FROM #ZKey     AS I
     JOIN sys.stats AS T
       ON I.GeneralID
        = T.object_id
      AND I.index_id
        = T.stats_id
    CROSS APPLY sys.dm_db_stats_histogram(T.object_id, T.stats_id) AS E
    WHERE E.equal_rows + E.range_rows > 1
 GROUP BY T.object_id
        , I.index_id
        , T.stats_id

   SELECT T.object_id
        , I.index_id
        , T.stats_id
        , SUBSTRING(MAX(STR(E.step_number, 3) + CONVERT(varchar(2000), E.range_high_key)), 4, 2000) AS KeyValue
        , CONVERT(bigint, 0) AS modification_counter
        , CONVERT(bigint, 0) AS modification_counter_END
     INTO #Hack
     FROM #ZKey     AS I
     JOIN sys.stats AS T
       ON I.GeneralID
        = T.object_id
      AND I.index_id
        = T.stats_id
    CROSS APPLY sys.dm_db_stats_histogram(T.object_id, T.stats_id) AS E
    WHERE I.name LIKE '%int'
      AND I.index_type IN (1, 2)
 GROUP BY T.object_id
        , I.index_id
        , T.stats_id

  DECLARE @object_id varchar(0010)
  DECLARE @index_id  varchar(0010)
  DECLARE @stats_id  varchar(0010)

  DECLARE @KeyValue  varchar(2000)

  DECLARE @name      varchar(0128)

  DECLARE @SQLServerName varchar(0128)
  DECLARE @VirtualSchema varchar(0128)
  DECLARE @VirtualObject varchar(0128)
  DECLARE @GeneralColumn varchar(0128)
  DECLARE @GeneralFilter varchar(4000)

  DECLARE DBItems CURSOR FAST_FORWARD FOR
   SELECT I.SQLServerName
        , I.GeneralSchema
        , I.GeneralObject
        , I.GeneralColumn
        , CASE WHEN LEN(I.GeneralFilter) = 0 THEN SPACE(0) ELSE ' AND ' + I.GeneralFilter END
        , U.KeyValue
        , I.name
        , CONVERT(varchar(0010), U.object_id)
        , CONVERT(varchar(0010), U.index_id )
        , CONVERT(varchar(0010), U.stats_id )
     FROM #ZKey AS I
     JOIN #Hack AS U
       ON I.GeneralID
        = U.object_id
      AND I.index_id
        = U.stats_id
    WHERE I.Pages
        >  @Pages
      AND I.GeneralType = 'U '
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName

OPEN DBItems

FETCH NEXT FROM DBItems INTO @SQLServerName, @VirtualSchema, @VirtualObject, @GeneralColumn, @GeneralFilter, @KeyValue, @name, @object_id, @index_id, @stats_id

WHILE @@FETCH_STATUS = 0

    BEGIN

    EXECUTE ('
       UPDATE #Hack SET modification_counter_END = (SELECT COUNT(*) FROM [' + @VirtualSchema + '].[' + @VirtualObject + '] WITH (INDEX([' + @SQLServerName + ']))' + ' WHERE [' + @GeneralColumn + '] > ' + @KeyValue + @GeneralFilter + ')
         FROM #Hack AS U
        WHERE U.object_id = ' + @object_id + ' AND U.index_id = ' + @index_id)

    FETCH NEXT FROM DBItems INTO @SQLServerName, @VirtualSchema, @VirtualObject, @GeneralColumn, @GeneralFilter, @KeyValue, @name, @object_id, @index_id, @stats_id

    END

CLOSE DBItems DEALLOCATE DBItems

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.GeneralColumn
        , I.SQLServerName
--      , I.SQLServerFile
        , CASE WHEN I.index_type            = 0 THEN 'S '
               WHEN I.index_type            = 5 THEN 'S '
               WHEN I.index_type            = 6 THEN 'S '
               WHEN I.is_primary_key       != 0 THEN 'PK'
               WHEN I.is_unique_constraint != 0 THEN 'AK'
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) = 0 THEN 'U '
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) > 0 THEN 'UF'
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) = 0 THEN 'S '
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) > 0 THEN 'SF' END AS Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        , T.histogram
--      , T.Average
--      , T.Deviate
--      , U.KeyValue
--      , U.modification_counter
--      , U.modification_counter_END
        , CONVERT(decimal(09,03), U.modification_counter_END / CASE WHEN T.Average = 0 THEN 1 ELSE T.Average END) AS Score
        , CONVERT(varchar(0040), E.last_updated, 120) AS [UPDATE_date]
--      , CONVERT(decimal(09,02), E.rows_sampled * 100.0 / CASE WHEN E.rows = 0 THEN 1 ELSE E.rows END) AS [SAMPLE]
     FROM #ZKey AS I
     JOIN #Task AS T
       ON I.GeneralID
        = T.object_id
      AND I.index_id
        = T.stats_id
     JOIN #Hack AS U
       ON I.GeneralID
        = U.object_id
      AND I.index_id
        = U.stats_id
    OUTER APPLY sys.dm_db_stats_properties(T.object_id, T.stats_id) AS E
    WHERE I.Pages
        >  @Pages
      AND I.GeneralType = 'U '
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.GeneralColumn
        , I.SQLServerName
--      , I.SQLServerFile
        , CASE WHEN I.index_type            = 0 THEN 'S '
               WHEN I.index_type            = 5 THEN 'S '
               WHEN I.index_type            = 6 THEN 'S '
               WHEN I.is_primary_key       != 0 THEN 'PK'
               WHEN I.is_unique_constraint != 0 THEN 'AK'
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) = 0 THEN 'U '
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) > 0 THEN 'UF'
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) = 0 THEN 'S '
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) > 0 THEN 'SF' END AS Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        , T.histogram
--      , T.Average
--      , T.Deviate
--      , U.KeyValue
--      , U.modification_counter
--      , U.modification_counter_END
        , CONVERT(decimal(09,03), U.modification_counter_END / CASE WHEN T.Average = 0 THEN 1 ELSE T.Average END) AS Score
        , CONVERT(varchar(0040), E.last_updated, 120) AS [UPDATE_date]
--      , CONVERT(decimal(09,02), E.rows_sampled * 100.0 / CASE WHEN E.rows = 0 THEN 1 ELSE E.rows END) AS [SAMPLE]
     FROM #ZKey AS I
     JOIN #Task AS T
       ON I.GeneralID
        = T.object_id
      AND I.index_id
        = T.stats_id
     JOIN #Hack AS U
       ON I.GeneralID
        = U.object_id
      AND I.index_id
        = U.stats_id
    OUTER APPLY sys.dm_db_stats_properties(T.object_id, T.stats_id) AS E
    WHERE I.Pages
        >  @Pages
      AND I.GeneralType = 'U '
 ORDER BY Score DESC
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName

DROP TABLE #ZKey

DROP TABLE #Task

DROP TABLE #Hack

