/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

PRINT 'Nature PK means primary   key'
PRINT 'Nature AK means alternate key (unique constraint)'
PRINT 'Nature U  means unique'
PRINT 'Nature UF means unique filtered'
PRINT 'Nature S  means simple'
PRINT 'Nature SF means simple filtered'

PRINT CHAR(13) + CHAR(10)

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

PRINT 'index_type 0 means a table as heap'
PRINT 'index_type 1 means a table as clustered index'
PRINT 'index_type 5 means a table as clustered index (columnstore)'
PRINT 'index_type 2 means a       nonclustered index'
PRINT 'index_type 6 means a       nonclustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

DECLARE @GBs decimal(19,05)

IF OBJECT_ID('tempdb..#ZKey'  , 'U ') IS NOT NULL DROP TABLE #ZKey
IF OBJECT_ID('tempdb..#ZKeys' , 'U ') IS NOT NULL DROP TABLE #ZKeys

IF OBJECT_ID('tempdb..#Hack'  , 'U ') IS NOT NULL DROP TABLE #Hack

IF OBJECT_ID('tempdb..#Work'  , 'U ') IS NOT NULL DROP TABLE #Work

IF OBJECT_ID('tempdb..#Action', 'U ') IS NOT NULL DROP TABLE #Action

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.type          AS SQLServerPile
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , I.is_unique
        , I.is_disabled
        , M.is_included_column
        , M.is_descending_key
        , M.partition_ordinal
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , CASE WHEN M.is_included_column  = 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY M.key_ordinal, M.index_column_id) ELSE 0 END AS regular_column_id
        , CASE WHEN M.is_included_column != 0 THEN ROW_NUMBER() OVER (PARTITION BY M.object_id, M.index_id, M.is_included_column ORDER BY                M.index_column_id) ELSE 0 END AS include_column_id
        , ISNULL(I.filter_definition, SPACE(0)) AS GeneralFilter
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
     INTO #ZKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
LEFT JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ', 'V ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName
        ,   index_column_id

   SELECT Z.*
        , CASE WHEN Z.name = 'time'           THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'datetime2'      THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'datetimeoffset' THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'float'          THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2)                                         + ')'
               WHEN Z.name = 'numeric'        THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'decimal'        THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'vardecimal'     THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'binary'         THEN Z.name + '(' +                                 RIGHT(STR(Z.max_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'varbinary'      THEN Z.name + '(' + CASE WHEN Z.max_length > 0 THEN RIGHT(STR(Z.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN Z.name = 'nchar'          THEN Z.name + '(' +                                 RIGHT(STR(Z.min_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'nvarchar'       THEN Z.name + '(' + CASE WHEN Z.min_length > 0 THEN RIGHT(STR(Z.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN Z.name = 'char'           THEN Z.name + '(' +                                 RIGHT(STR(Z.max_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'varchar'        THEN Z.name + '(' + CASE WHEN Z.max_length > 0 THEN RIGHT(STR(Z.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE Z.name END AS SQLServerType
     INTO #ZKeys
     FROM #ZKey AS Z
 ORDER BY Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerName
        , Z.index_column_id

   UPDATE Z SET table_type = CASE WHEN E.GeneralType = 'V ' THEN 0 - E.index_type ELSE E.index_type END FROM #ZKey  AS Z JOIN #ZKey AS E ON Z.GeneralID = E.GeneralID AND E.index_type IN (0, 1, 5) AND E.index_column_id IN (0, 1)
   UPDATE Z SET table_type = CASE WHEN E.GeneralType = 'V ' THEN 0 - E.index_type ELSE E.index_type END FROM #ZKeys AS Z JOIN #ZKey AS E ON Z.GeneralID = E.GeneralID AND E.index_type IN (0, 1, 5) AND E.index_column_id IN (0, 1)

   SELECT Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerPile
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
        , SUM(CASE WHEN Z.regular_column_id >  0 THEN 1 ELSE 0 END) AS KeyColumns
        , SUM(CASE WHEN Z.include_column_id >  0 THEN 1 ELSE 0 END) AS AnyColumns
        , MAX(CASE WHEN Z.regular_column_id =  1 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  2 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  3 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  4 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  5 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  6 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  7 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  8 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id =  9 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 10 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 11 THEN   '[' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 12 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 13 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 14 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 15 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 16 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 17 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 18 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id = 19 THEN ', [' + Z.GeneralColumn + ']' + CASE WHEN Z.is_descending_key != 0 THEN ' DESC' ELSE SPACE(0) END ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.regular_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS RegularColumn
        , MAX(CASE WHEN Z.include_column_id =  1 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  2 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  3 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  4 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  5 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  6 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  7 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  8 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id =  9 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 10 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 11 THEN   '[' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 12 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 13 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 14 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 15 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 16 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 17 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 18 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id = 19 THEN ', [' + Z.GeneralColumn + ']'                                                                     ELSE SPACE(0) END)
        + MAX(CASE WHEN Z.include_column_id > 19 THEN ', [...]'                                                                                         ELSE SPACE(0) END) AS IncludeColumn
     INTO #Hack
     FROM #ZKey AS Z
 GROUP BY Z.GeneralID
        , Z.GeneralType
        , Z.GeneralSchema
        , Z.GeneralObject
        , Z.SQLServerPile
        , Z.SQLServerFile
        , Z.SQLServerName
        , Z.index_id
        , Z.table_type
        , Z.index_type
        , Z.fill_factor
        , Z.is_primary_key
        , Z.is_unique_constraint
        , Z.is_unique
        , Z.is_disabled
        , Z.GeneralFilter
 ORDER BY Z.GeneralSchema
        , Z.GeneralObject
        , Z.index_id

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerPile
        , I.SQLServerFile
        , CASE WHEN I.index_type            = 0 THEN 'S '
               WHEN I.index_type            = 5 THEN 'S '
               WHEN I.index_type            = 6 THEN 'S '
               WHEN I.is_primary_key       != 0 THEN 'PK'
               WHEN I.is_unique_constraint != 0 THEN 'AK'
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) = 0 THEN 'U '
               WHEN I.is_unique            != 0 AND LEN(I.GeneralFilter) > 0 THEN 'UF'
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) = 0 THEN 'S '
               WHEN I.is_unique             = 0 AND LEN(I.GeneralFilter) > 0 THEN 'SF' END AS Nature
        , I.fill_factor AS Factor
        , I.is_primary_key
        , I.is_unique_constraint
        , I.is_unique
        , I.is_disabled
        , I.table_type
        , I.index_type
        ,                         ISNULL(E.index_rows , 0)                   AS index_rows
        ,                         ISNULL(T.pages_total, 0)                   AS pages_total
        ,                         ISNULL(W.pages_LOB  , 0)                   AS pages_LOB
        ,                         ISNULL(Z.pages_ROV  , 0)                   AS pages_ROV
--      , CONVERT(decimal(19,05), ISNULL(T.pages_total, 0) / 128.0 / 1024.0) AS GBs_total
--      , CONVERT(decimal(19,05), ISNULL(W.pages_LOB  , 0) / 128.0 / 1024.0) AS GBs_LOB
--      , CONVERT(decimal(19,05), ISNULL(Z.pages_ROV  , 0) / 128.0 / 1024.0) AS GBs_ROV
        , I.RegularColumn
        , I.IncludeColumn
        , I.GeneralFilter
        , I.GeneralID
        , I.index_id
     INTO #Work
     FROM #Hack AS I
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(P.rows) AS index_rows
     FROM sys.partitions AS P
 GROUP BY P.object_id
        , P.index_id)    AS E
       ON I.GeneralID
        = E.object_id
      AND I.index_id
        = E.index_id
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(A.total_pages) AS pages_total
     FROM sys.partitions AS P
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type != 0
 GROUP BY P.object_id
        , P.index_id)    AS T
       ON I.GeneralID
        = T.object_id
      AND I.index_id
        = T.index_id
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(A.total_pages) AS pages_LOB
     FROM sys.partitions AS P
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type  = 2
 GROUP BY P.object_id
        , P.index_id)    AS W
       ON I.GeneralID
        = W.object_id
      AND I.index_id
        = W.index_id
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(A.total_pages) AS pages_ROV
     FROM sys.partitions AS P
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type  = 3
 GROUP BY P.object_id
        , P.index_id)    AS Z
       ON I.GeneralID
        = Z.object_id
      AND I.index_id
        = Z.index_id
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

-- The calculation below is convoluted in order to match rounding in the SQLFacts tool.

   SELECT @GBs = SUM(CONVERT(decimal(19,05), Z.pages_table / 128.0 / 1024.0))
               + SUM(CONVERT(decimal(19,05), Z.pages_index / 128.0 / 1024.0))
     FROM
  (SELECT I.GeneralID
        , SUM(CASE WHEN I.index_type     IN (0, 1, 5) THEN I.pages_total ELSE 0 END) AS pages_table
        , SUM(CASE WHEN I.index_type NOT IN (0, 1, 5) THEN I.pages_total ELSE 0 END) AS pages_index
     FROM #Work AS I
 GROUP BY I.GeneralID) AS Z

IF @GBs = 0.0 SET @GBs = 1.0

   SELECT F.file_id
        ,          F.name
        , F.physical_name
        , F.type
        , FILEPROPERTY(F.name, 'SpaceUsed') AS used
        , F.size
        , F.max_size
        , F.growth
        , F.is_percent_growth AS is_percent
        , D.is_default
        , D.name AS SQLServerFile
     INTO #Action
     FROM sys.database_files AS F
LEFT JOIN sys.data_spaces    AS D
       ON F.data_space_id
        = D.data_space_id

-- result set 1

   SELECT S.SQLServerFile
        ,          S.name AS DBFile
        , S.physical_name AS DBPath
--      , V.volume_mount_point AS FSPath
        , CASE WHEN S.is_percent  = 0 THEN  0       ELSE CONVERT(decimal(09,00), S.growth                   ) END AS [Percent_File]
        , CASE WHEN S.is_percent != 0 THEN  0.00000 ELSE CONVERT(decimal(19,05), S.growth   / 128.0 / 1024.0) END AS [GBs_ADD_File]
        , CASE WHEN S.max_size    < 0 THEN -1.00000 ELSE CONVERT(decimal(19,05), S.max_size / 128.0 / 1024.0) END AS [GBs_MAX_File]
        , CONVERT(decimal(19,05), (S.size         ) / 128.0 / 1024.0) AS GBs_Size_File
        , CONVERT(decimal(19,05), (         S.used) / 128.0 / 1024.0) AS GBs_Used_File
        , CONVERT(decimal(19,05), (S.size - S.used) / 128.0 / 1024.0) AS GBs_Free_File
--      , CONVERT(decimal(05,02), (         S.used) * 100.0 / S.size) AS Percent_Used_File
--      , CONVERT(decimal(05,02), (S.size - S.used) * 100.0 / S.size) AS Percent_Free_File
        , CONVERT(decimal(19,05), (V.total_bytes                    ) / 1024.0 / 1024.0 / 1024.0) AS GBs_Size_Disk
        , CONVERT(decimal(19,05), (V.total_bytes - V.available_bytes) / 1024.0 / 1024.0 / 1024.0) AS GBs_Used_Disk
        , CONVERT(decimal(19,05), (                V.available_bytes) / 1024.0 / 1024.0 / 1024.0) AS GBs_Free_Disk
--      , CONVERT(decimal(05,02), (V.total_bytes - V.available_bytes) * 100.0 / V.total_bytes) AS Percent_Used_Disk
--      , CONVERT(decimal(05,02), (                V.available_bytes) * 100.0 / V.total_bytes) AS Percent_Free_Disk
     FROM #Action AS S CROSS APPLY sys.dm_os_volume_stats(DB_ID(), S.file_id) AS V
 ORDER BY S.type
        , S.SQLServerFile
        , S.name

-- result set 2

   SELECT S.SQLServerFile
        , S.is_default
        , COUNT(*)                                                                   AS Files_Data
        , CONVERT(decimal(19,05), (SUM(S.size)              ) / 128.0 / 1024.0)      AS GBs_Size_Data
        , CONVERT(decimal(19,05), (              SUM(S.used)) / 128.0 / 1024.0)      AS GBs_Used_Data
        , CONVERT(decimal(19,05), (SUM(S.size) - SUM(S.used)) / 128.0 / 1024.0)      AS GBs_Free_Data
        , CONVERT(decimal(05,02), (              SUM(S.used)) * 100.0 / SUM(S.size)) AS Percent_Used
        , CONVERT(decimal(05,02), (SUM(S.size) - SUM(S.used)) * 100.0 / SUM(S.size)) AS Percent_Free
     FROM #Action AS S
    WHERE S.type = 0
 GROUP BY S.SQLServerFile
        , S.is_default
 ORDER BY S.SQLServerFile

-- result set 3

   SELECT H.name AS SQLServerFile
        , H.is_default
        , SUM(CASE WHEN Z.type = 0 THEN Z.MyCOUNT ELSE 0 END) AS Index_0
        , SUM(CASE WHEN Z.type = 1 THEN Z.MyCOUNT ELSE 0 END) AS Index_1
        , SUM(CASE WHEN Z.type = 5 THEN Z.MyCOUNT ELSE 0 END) AS Index_5
        , SUM(CASE WHEN Z.type = 2 THEN Z.MyCOUNT ELSE 0 END) AS Index_2
        , SUM(CASE WHEN Z.type = 6 THEN Z.MyCOUNT ELSE 0 END) AS Index_6
     FROM sys.data_spaces AS H
     JOIN
  (SELECT A.data_space_id
        , I.type
        , COUNT(DISTINCT S.name + '.' + O.name + '.' + ISNULL(I.name, O.name)) AS MyCOUNT
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type != 0
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
 GROUP BY A.data_space_id
        , I.type) AS Z
       ON H.data_space_id
        = Z.data_space_id
    WHERE H.type = 'FG'
 GROUP BY H.name
        , H.is_default
 ORDER BY H.name

-- result set 4

   SELECT X.name AS [PS_Name]
        , Y.name AS [PF_Name]
        , CASE WHEN Z.name = 'time'           THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'datetime2'      THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'datetimeoffset' THEN Z.name + '(' +                                                   STR(Z.scale,       1)     + ')'
               WHEN Z.name = 'float'          THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2)                                         + ')'
               WHEN Z.name = 'numeric'        THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'decimal'        THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'vardecimal'     THEN Z.name + '(' + RIGHT(STR(Z.precision + 100, 3), 2) + ',' + RIGHT(STR(Z.scale + 100, 3), 2) + ')'
               WHEN Z.name = 'binary'         THEN Z.name + '(' +                                 RIGHT(STR(Z.max_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'varbinary'      THEN Z.name + '(' + CASE WHEN Z.max_length > 0 THEN RIGHT(STR(Z.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN Z.name = 'nchar'          THEN Z.name + '(' +                                 RIGHT(STR(Z.min_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'nvarchar'       THEN Z.name + '(' + CASE WHEN Z.min_length > 0 THEN RIGHT(STR(Z.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN Z.name = 'char'           THEN Z.name + '(' +                                 RIGHT(STR(Z.max_length + 10000, 5), 4)                 + ')'
               WHEN Z.name = 'varchar'        THEN Z.name + '(' + CASE WHEN Z.max_length > 0 THEN RIGHT(STR(Z.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE Z.name END AS SQLServerType
        , CASE WHEN Y.boundary_value_on_right = 0 THEN 'THRU' ELSE 'FROM' END + ' - ' + ISNULL(CASE WHEN Z.name LIKE '%datetime%' THEN LEFT(CONVERT(varchar(0400), CONVERT(datetime2(7), W.value), 120), 16) ELSE CONVERT(varchar(0400), W.value) END, SPACE(0)) AS Boundary
        , H.partition_number AS [Partition]
        , H.name AS SQLServerFile
     FROM sys.partition_schemes AS X
     JOIN
  (SELECT E.partition_scheme_id AS data_space_id
        , E.destination_id      AS partition_number
        , K.name
     FROM sys.destination_data_spaces AS E
     JOIN sys.data_spaces AS K
       ON E.data_space_id
        = K.data_space_id) AS H
       ON X.data_space_id
        = H.data_space_id
     JOIN sys.partition_functions AS Y
       ON X.function_id
        = Y.function_id
     JOIN
  (SELECT E.function_id
        , E.parameter_id
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND E.max_length > 0 THEN E.max_length / 2 ELSE E.max_length END AS min_length
        , E.max_length
        , E.precision
        , E.scale
     FROM sys.partition_parameters AS E
     JOIN sys.types AS T
       ON E.user_type_id
        = T.user_type_id) AS Z
       ON Y.function_id
        = Z.function_id
LEFT JOIN sys.partition_range_values AS W
       ON Z.function_id
        = W.function_id
      AND Z.parameter_id = 1
      AND W.parameter_id = 1
      AND H.partition_number
        = W.boundary_id + CASE WHEN Y.boundary_value_on_right = 0 THEN 0 ELSE 1 END
 ORDER BY X.name
        , Y.name
        , H.partition_number

-- result set 5

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        , CONVERT(decimal(19,05), I.pages_total / 128.0 / 1024.0) AS GBs_total_size
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
        , ISNULL(C.GeneralColumn, SPACE(0)) AS GeneralColumn
        , P.partition_number AS [Partition]
        , P.rows AS [Rows]
        , CASE WHEN P.data_compression = 1 THEN 'ROW'
               WHEN P.data_compression = 2 THEN 'PAGE'
               WHEN P.data_compression > 2 THEN 'COLUMNSTORE' ELSE SPACE(0) END AS [Compression]
     FROM #Work  AS I
LEFT JOIN #ZKeys AS C
       ON I.GeneralID
        = C.GeneralID
      AND I.index_id
        = C.index_id
      AND C.partition_ordinal = 1
     JOIN sys.partitions AS P
       ON I.GeneralID
        = P.object_id
      AND I.index_id
        = P.index_id
    WHERE I.SQLServerPile = 'PS'
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName
        , P.partition_number

-- result set 6

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        , CONVERT(decimal(19,05), I.pages_total / 128.0 / 1024.0) AS GBs_total_size
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
        , ISNULL(C.GeneralColumn, SPACE(0)) AS GeneralColumn
        , P.partition_number AS [Partition]
        , P.rows AS [Rows]
        , CASE WHEN P.data_compression = 1 THEN 'ROW'
               WHEN P.data_compression = 2 THEN 'PAGE'
               WHEN P.data_compression > 2 THEN 'COLUMNSTORE' ELSE SPACE(0) END AS [Compression]
     FROM #Work  AS I
LEFT JOIN #ZKeys AS C
       ON I.GeneralID
        = C.GeneralID
      AND I.index_id
        = C.index_id
      AND C.partition_ordinal = 1
     JOIN sys.partitions AS P
       ON I.GeneralID
        = P.object_id
      AND I.index_id
        = P.index_id
    WHERE P.data_compression IN (1, 2)
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName
        , P.partition_number

-- result set 7

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        , CONVERT(decimal(19,05), I.pages_total / 128.0 / 1024.0) AS GBs_total_size
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
     FROM #Work  AS I
    WHERE I.index_type     IN (5, 6)
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

-- result set 8

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        , CONVERT(decimal(19,05), I.pages_total / 128.0 / 1024.0) AS GBs_total_size
        , CONVERT(decimal(19,05), I.pages_LOB   / 128.0 / 1024.0) AS GBs_LOB_size
        , T.large_value_types_out_of_row AS is_lvtor
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
     FROM #Work  AS I
     JOIN sys.tables AS T
       ON I.GeneralID
        = T.object_id
    WHERE I.index_type NOT IN (5, 6)
      AND I.pages_LOB != 0
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

-- result set 9

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        , CONVERT(decimal(19,05), I.pages_total / 128.0 / 1024.0) AS GBs_total_size
        , CONVERT(decimal(19,05), I.pages_ROV   / 128.0 / 1024.0) AS GBs_ROV_size
        , T.large_value_types_out_of_row AS is_lvtor
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
     FROM #Work  AS I
     JOIN sys.tables AS T
       ON I.GeneralID
        = T.object_id
    WHERE I.index_type NOT IN (5, 6)
      AND I.pages_ROV != 0
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

-- result set 10

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        , I.SQLServerFile
        , I.Nature
--      , I.fill_factor AS Factor
--      , I.is_primary_key
--      , I.is_unique_constraint
--      , I.is_unique
--      , I.is_disabled
--      , STR(I.table_type, 1) + ' / ' + STR(I.index_type, 1) AS types
        , I.table_type
        , I.index_type
        , I.index_rows
        ,                         CONVERT(decimal(19,05), I.pages_total / 128.0 / 1024.0)                 AS GBs_total_size
        , CONVERT(decimal(05,02), CONVERT(decimal(19,05), I.pages_total / 128.0 / 1024.0) * 100.0 / @GBs) AS [Percent]
--      , I.RegularColumn
--      , I.IncludeColumn
--      , I.GeneralFilter
     FROM #Work  AS I
 ORDER BY [Percent] DESC
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName

-- result set 11

-- The calculation below is convoluted in order to match rounding in the SQLFacts tool.

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.table_type
        , I.index_rows AS table_rows
        , T.Indexes
        ,                         T.GBs_table                 AS GBs_Table
        ,                         T.GBs_index                 AS GBs_Indexes
        , CONVERT(decimal(05,02), T.GBs_total * 100.0 / @GBs) AS [Percent]
     FROM #Work  AS I
     JOIN
  (SELECT Z.GeneralID
        ,                         SUM(CASE WHEN Z.index_type NOT IN (0, 1, 5) THEN 1             ELSE 0 END)                   AS Indexes
        , CONVERT(decimal(19,05), SUM(CASE WHEN Z.index_type     IN (0, 1, 5) THEN Z.pages_total ELSE 0 END) / 128.0 / 1024.0) AS GBs_table
        , CONVERT(decimal(19,05), SUM(CASE WHEN Z.index_type NOT IN (0, 1, 5) THEN Z.pages_total ELSE 0 END) / 128.0 / 1024.0) AS GBs_index
        , CONVERT(decimal(19,05), SUM(CASE WHEN Z.index_type     IN (0, 1, 5) THEN Z.pages_total ELSE 0 END) / 128.0 / 1024.0)
        + CONVERT(decimal(19,05), SUM(CASE WHEN Z.index_type NOT IN (0, 1, 5) THEN Z.pages_total ELSE 0 END) / 128.0 / 1024.0) AS GBs_total
     FROM #Work  AS Z
 GROUP BY Z.GeneralID) AS T
       ON I.GeneralID
        = T.GeneralID
    WHERE I.index_type IN (0, 1, 5)
 ORDER BY [Percent] DESC
        , I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName

DROP TABLE #ZKey
DROP TABLE #ZKeys

DROP TABLE #Hack

DROP TABLE #Work

DROP TABLE #Action

SET NOCOUNT OFF

