/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @GeneralSchema varchar(0128) = '%' -- enter schema name here, use LIKE wildcards as necessary

DECLARE @GeneralObject varchar(0128) = '%' -- enter object name here, use LIKE wildcards as necessary

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

PRINT CHAR(13) + CHAR(10)

PRINT 'Instance Collation = ' + CONVERT(varchar(0256), SERVERPROPERTY('Collation'))

PRINT CHAR(13) + CHAR(10)

PRINT 'Database Collation = ' + CONVERT(varchar(0256), DATABASEPROPERTYEX(DB_NAME(), 'Collation'))

PRINT CHAR(13) + CHAR(10)

PRINT 'table_type 0 means a table as heap'
PRINT 'table_type 1 means a table as clustered index'
PRINT 'table_type 5 means a table as clustered index (columnstore)'

PRINT CHAR(13) + CHAR(10)

PRINT 'temporal 0 means standard table'
PRINT 'temporal 1 means temporal table history'
PRINT 'temporal 2 means temporal table'

PRINT CHAR(13) + CHAR(10)

DECLARE @Layer smallint

DECLARE @Batch smallint

IF OBJECT_ID('tempdb..#Base' , 'U ') IS NOT NULL DROP TABLE #Base

IF OBJECT_ID('tempdb..#PKey' , 'U ') IS NOT NULL DROP TABLE #PKey
IF OBJECT_ID('tempdb..#PKeys', 'U ') IS NOT NULL DROP TABLE #PKeys

IF OBJECT_ID('tempdb..#FKey' , 'U ') IS NOT NULL DROP TABLE #FKey
IF OBJECT_ID('tempdb..#FKeys', 'U ') IS NOT NULL DROP TABLE #FKeys

IF OBJECT_ID('tempdb..#TKey' , 'U ') IS NOT NULL DROP TABLE #TKey
IF OBJECT_ID('tempdb..#TKeys', 'U ') IS NOT NULL DROP TABLE #TKeys

IF OBJECT_ID('tempdb..#WKey' , 'U ') IS NOT NULL DROP TABLE #WKey

IF OBJECT_ID('tempdb..#Work' , 'U ') IS NOT NULL DROP TABLE #Work

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , O.parent_object_id AS VariousID
        , CONVERT(varchar(max ), ISNULL(M.definition, SPACE(0))) AS SQLServerCode
     INTO #Base
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
LEFT JOIN sys.sql_modules AS M
       ON O.object_id
        = M.object_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY O.type
        , S.name
        , O.name

   SELECT O.object_id AS GeneralID
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , M.is_descending_key
        , M.partition_ordinal
        , M.key_ordinal
        , C.name      AS GeneralColumn
     INTO #PKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND CASE WHEN I.is_primary_key       != 0 THEN 1
               WHEN I.is_unique_constraint != 0 THEN 1 ELSE 0 END != 0
     JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
     JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName
        ,   key_ordinal

   SELECT P.GeneralID
        , P.GeneralObject
        , P.GeneralSchema
        , P.SQLServerFile
        , P.SQLServerName
        , CONVERT(     int, -1) AS Layer
        , CONVERT(     int, -1) AS Estimate
        , CONVERT(smallint,  0) AS Factor01
        , CONVERT(smallint,  0) AS Factor02
        , CONVERT(smallint,  0) AS Factor03
        , CONVERT(smallint,  0) AS Factor04
        , CONVERT(smallint,  0) AS Factor05
     INTO #PKeys
     FROM #PKey AS P
    WHERE P.is_primary_key != 0
 GROUP BY P.GeneralID
        , P.GeneralObject
        , P.GeneralSchema
        , P.SQLServerFile
        , P.SQLServerName
 ORDER BY P.GeneralSchema
        , P.GeneralObject
        , P.SQLServerName

   SELECT O.object_id AS ForeignID
        , W.object_id AS PrimaryID
        , O.name      AS ForeignObject
        , W.name      AS PrimaryObject
        , S.name      AS ForeignSchema
        , Z.name      AS PrimarySchema
        , F.name      AS SQLServerName
        , CONVERT(varchar(0040), F.create_date, 120) AS create_date
        , CONVERT(varchar(0040), F.modify_date, 120) AS modify_date
        , F.is_disabled
        , F.is_not_trusted
        , M.constraint_column_id
        , C.name      AS ForeignColumn
        , K.name      AS PrimaryColumn
        , F.delete_referential_action
        , F.delete_referential_action_desc
        , F.update_referential_action
        , F.update_referential_action_desc
     INTO #FKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.foreign_keys AS F
       ON        O.object_id
        = F.parent_object_id
     JOIN sys.foreign_key_columns AS M
       ON            F.object_id
        = M.constraint_object_id
     JOIN sys.columns AS C
       ON M.parent_object_id
        =        C.object_id
      AND M.parent_column_id
        =        C.column_id
     JOIN sys.columns AS K
       ON M.referenced_object_id
        =            K.object_id
      AND M.referenced_column_id
        =            K.column_id
     JOIN sys.objects AS W
       ON F.referenced_object_id
        =            W.object_id
--    AND            O.object_id
--     !=            W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
      AND Z.name IN (SELECT [Schema] FROM @Match)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   PrimarySchema
        ,   PrimaryObject
        ,   ForeignSchema
        ,   ForeignObject
        ,   constraint_column_id

   SELECT F.PrimaryID
        , F.ForeignID
        , F.PrimaryObject
        , F.ForeignObject
        , F.PrimarySchema
        , F.ForeignSchema
        , F.SQLServerName
        , COUNT(*) AS Columns
     INTO #FKeys
     FROM #FKey AS F
    WHERE F.PrimaryID
       != F.ForeignID
 GROUP BY F.PrimaryID
        , F.ForeignID
        , F.PrimaryObject
        , F.ForeignObject
        , F.PrimarySchema
        , F.ForeignSchema
        , F.SQLServerName
 ORDER BY F.PrimarySchema
        , F.PrimaryObject
        , F.ForeignSchema
        , F.ForeignObject

   SELECT O.object_id AS GeneralID
        , O.type      AS GeneralType
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        , C.column_id
        , ISNULL(M.index_column_id, 0) AS index_column_id
        , C.is_sparse
        , C.is_nullable
        , C.is_computed
        , C.is_identity
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_SEED   (S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [From]
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_INCR   (S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [Plus]
        , CASE WHEN O.type = 'U ' THEN CASE WHEN C.is_identity != 0 THEN CONVERT(decimal(38,00), IDENT_CURRENT(S.name + '.' + O.name)) ELSE 0 END ELSE 0 END AS [Used]
        , C.name      AS GeneralColumn
        , T.name
        , CASE WHEN T.name LIKE 'n%char' AND C.max_length > 0 THEN C.max_length / 2 ELSE C.max_length END AS min_length
        , C.max_length
        , C.precision
        , C.scale
        , ISNULL(                   C.collation_name , '') AS collation_name
        , ISNULL(CONVERT(varchar(4000), W.definition), '') AS FormulaCode
        , ISNULL(CONVERT(varchar(4000), Z.definition), '') AS DefaultCode
        , ISNULL(                             Z.name , '') AS DefaultName
     INTO #TKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.columns AS C
       ON O.object_id
        = C.object_id
     JOIN sys.types   AS T
       ON C.user_type_id
        = T.user_type_id
LEFT JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND I.is_primary_key != 0
LEFT JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
      AND C.column_id
        = M.column_id
LEFT JOIN sys.computed_columns AS W
       ON C.object_id
        = W.object_id
      AND C.column_id
        = W.column_id
LEFT JOIN sys.default_constraints AS Z
       ON        C.object_id
        = Z.parent_object_id
      AND        C.column_id
        = Z.parent_column_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralType
        ,   GeneralSchema
        ,   GeneralObject
        ,   column_id

   SELECT T.*
        , CASE WHEN T.name = 'time'           THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetime2'      THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'datetimeoffset' THEN T.name + '(' +                                                   STR(T.scale,       1)     + ')'
               WHEN T.name = 'float'          THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2)                                         + ')'
               WHEN T.name = 'numeric'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'decimal'        THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'vardecimal'     THEN T.name + '(' + RIGHT(STR(T.precision + 100, 3), 2) + ',' + RIGHT(STR(T.scale + 100, 3), 2) + ')'
               WHEN T.name = 'binary'         THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varbinary'      THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'nchar'          THEN T.name + '(' +                                 RIGHT(STR(T.min_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'nvarchar'       THEN T.name + '(' + CASE WHEN T.min_length > 0 THEN RIGHT(STR(T.min_length + 10000, 5), 4) ELSE 'max ' END + ')'
               WHEN T.name = 'char'           THEN T.name + '(' +                                 RIGHT(STR(T.max_length + 10000, 5), 4)                 + ')'
               WHEN T.name = 'varchar'        THEN T.name + '(' + CASE WHEN T.max_length > 0 THEN RIGHT(STR(T.max_length + 10000, 5), 4) ELSE 'max ' END + ')'
                                              ELSE T.name END AS SQLServerType
     INTO #TKeys
     FROM #TKey AS T
--  WHERE T.GeneralType IN ('U ')
 ORDER BY T.GeneralType
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id

SET @Layer = 0

SET @Batch = 0

   UPDATE P SET Layer = @Layer
     FROM #PKeys AS P
LEFT JOIN #FKeys AS F
       ON P.GeneralID
        = F.ForeignID
    WHERE F.ForeignID IS NULL

SET @Batch = @@ROWCOUNT

WHILE @Batch > 0 AND @Layer < 90

    BEGIN

    SET @Layer = @Layer + 1

       UPDATE P SET Layer = @Layer
         FROM #PKeys AS P
        WHERE NOT EXISTS
      (SELECT *
         FROM #PKeys AS W
         JOIN #FKeys AS Z
           ON W.GeneralID
            = Z.PrimaryID
          AND P.GeneralID
            = Z.ForeignID
        WHERE W.Layer < 0)
          AND P.Layer < 0

    SET @Batch = @@ROWCOUNT

    END

   SELECT O.object_id AS GeneralID
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , ISNULL(CONVERT(decimal(38,00), IDENT_SEED   (S.name + '.' + O.name)), 0) AS [From]
        , ISNULL(CONVERT(decimal(38,00), IDENT_INCR   (S.name + '.' + O.name)), 0) AS [Plus]
        , ISNULL(CONVERT(decimal(38,00), IDENT_CURRENT(S.name + '.' + O.name)), 0) AS [Used]
        , T.index_id
        , CONVERT(smallint, I.type) AS table_type
        , CONVERT(smallint, I.type) AS index_type
        , CASE WHEN T.DC_MIN  = T.DC_MAX AND T.DC_MIN = 1 THEN 'ROW'
               WHEN T.DC_MIN  = T.DC_MAX AND T.DC_MIN = 2 THEN 'PAGE'
               WHEN T.DC_MIN  = T.DC_MAX AND T.DC_MIN > 2 THEN 'COLUMNSTORE'
               WHEN T.DC_MIN != T.DC_MAX                  THEN 'MIXED TYPES' ELSE SPACE(0) END AS [Compression]
        , T.[Partitions]
        , T.total_rows          AS [Rows]
        , ISNULL(Z.index_id, 0) AS [Indexes]
        , CONVERT(decimal(19,05), ISNULL(W.total_pages, 0) / 128.0 / 1024.0) AS GBs_Table
        , CONVERT(decimal(19,05), ISNULL(Z.total_pages, 0) / 128.0 / 1024.0) AS GBs_Indexes
        , CONVERT(int, 0) AS [Columns]
        , CONVERT(int, 0) AS [Width]
     INTO #WKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND I.type                     IN (0, 1, 5)
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
     JOIN
  (SELECT I.object_id
        , MIN(I.index_id)            AS index_id
        , SUM(P.rows)                AS total_rows
        , COUNT(*)                   AS Partitions
        , MIN(P.data_compression)    AS DC_MIN
        , MAX(P.data_compression)    AS DC_MAX
     FROM sys.indexes    AS I
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
    WHERE I.type                     IN (0, 1, 5)
 GROUP BY I.object_id)               AS T
       ON O.object_id
        = T.object_id
     JOIN
  (SELECT I.object_id
        , MIN(I.index_id)            AS index_id
        , SUM(A.total_pages)         AS total_pages
     FROM sys.indexes    AS I
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
     JOIN sys.allocation_units       AS A
       ON P.partition_id
        = A.container_id
      AND A.type != 0
    WHERE I.type                     IN (0, 1, 5)
 GROUP BY I.object_id)               AS W
       ON O.object_id
        = W.object_id
LEFT JOIN
  (SELECT I.object_id
        , COUNT(DISTINCT I.index_id) AS index_id
        , SUM(A.total_pages)         AS total_pages
     FROM sys.indexes    AS I
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
     JOIN sys.allocation_units       AS A
       ON P.partition_id
        = A.container_id
      AND A.type != 0
    WHERE I.type                 NOT IN (0, 1, 5)
 GROUP BY I.object_id)               AS Z
       ON O.object_id
        = Z.object_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
 ORDER BY   GeneralSchema
        ,   GeneralObject

   UPDATE #WKey SET
            [Columns]
        = Z.[Columns]
        ,   [Width]
        = Z.[Width]
     FROM #WKey AS W
     JOIN
  (SELECT T.GeneralID
        , COUNT(*) AS [Columns]
        , SUM(CASE WHEN T.max_length < 0 THEN 16 ELSE T.max_length END) AS [Width]
     FROM #TKey AS T
 GROUP BY T.GeneralID) AS Z
       ON W.GeneralID
        = Z.GeneralID

   SELECT I.GeneralSchema
        , I.GeneralObject
        , I.SQLServerName
        ,                         ISNULL(E.index_rows , 0)                   AS index_rows
        ,                         ISNULL(T.pages_total, 0)                   AS pages_total
        ,                         ISNULL(W.pages_LOB  , 0)                   AS pages_LOB
        ,                         ISNULL(Z.pages_ROV  , 0)                   AS pages_ROV
--      , CONVERT(decimal(19,05), ISNULL(T.pages_total, 0) / 128.0 / 1024.0) AS GBs_total
--      , CONVERT(decimal(19,05), ISNULL(W.pages_LOB  , 0) / 128.0 / 1024.0) AS GBs_LOB
--      , CONVERT(decimal(19,05), ISNULL(Z.pages_ROV  , 0) / 128.0 / 1024.0) AS GBs_ROV
        , I.GeneralID
        , I.index_id
     INTO #Work
     FROM #WKey AS I
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(P.rows) AS index_rows
     FROM sys.partitions AS P
 GROUP BY P.object_id
        , P.index_id)    AS E
       ON I.GeneralID
        = E.object_id
      AND I.index_id
        = E.index_id
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(A.total_pages) AS pages_total
     FROM sys.partitions AS P
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type != 0
 GROUP BY P.object_id
        , P.index_id)    AS T
       ON I.GeneralID
        = T.object_id
      AND I.index_id
        = T.index_id
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(A.total_pages) AS pages_LOB
     FROM sys.partitions AS P
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type  = 2
 GROUP BY P.object_id
        , P.index_id)    AS W
       ON I.GeneralID
        = W.object_id
      AND I.index_id
        = W.index_id
LEFT JOIN
  (SELECT P.object_id
        , P.index_id
        , SUM(A.total_pages) AS pages_ROV
     FROM sys.partitions AS P
     JOIN sys.allocation_units AS A
       ON P.partition_id
        = A.container_id
      AND A.type  = 3
 GROUP BY P.object_id
        , P.index_id)    AS Z
       ON I.GeneralID
        = Z.object_id
      AND I.index_id
        = Z.index_id
 ORDER BY I.GeneralSchema
        , I.GeneralObject
        , CASE I.index_type
          WHEN 0 THEN 0
          WHEN 1 THEN 0
          WHEN 5 THEN 0
          WHEN 2 THEN 1
          WHEN 6 THEN 2 ELSE 3 END
        , I.SQLServerName

   SELECT E.GeneralSchema
        , E.GeneralObject
        , W.SQLServerFile
--      , W.SQLServerName
        , E.create_date
        , E.modify_date
        , W.table_type
        , ISNULL(OBJECTPROPERTY(E.GeneralID, 'TableTemporalType'), 0) AS [temporal]
        , T.large_value_types_out_of_row AS is_lvtor
        , P.Layer
        , W.[From]
        , W.[Plus]
        , W.[Used]
        , W.[Columns]
        , W.[Width]
        , W.[Compression]
        , W.[Partitions]
        , W.[Rows]
--      , W.[Indexes]
        , W.GBs_Table
--      , W.GBs_Indexes
--      , CONVERT(decimal(05,02), CONVERT(decimal(19,05), I.pages_LOB       / 128.0 / 1024.0) * 100.0 / CASE WHEN W.GBs_Table = 0.0 THEN 1.0 ELSE W.GBs_Table END) AS Percent_LOB
--      , CONVERT(decimal(05,02), CONVERT(decimal(19,05), I.pages_ROV       / 128.0 / 1024.0) * 100.0 / CASE WHEN W.GBs_Table = 0.0 THEN 1.0 ELSE W.GBs_Table END) AS Percent_ROV
        ,                         CONVERT(decimal(19,05), I.pages_LOB       / 128.0 / 1024.0)                                                                      AS GBs_total_LOB
        ,                         CONVERT(decimal(19,05), I.pages_ROV       / 128.0 / 1024.0)                                                                      AS GBs_total_ROV
        ,                         CONVERT(decimal(19,05), U.pages_fetch_LOB / 128.0 / 1024.0)                                                                      AS GBs_fetch_LOB
        ,                         CONVERT(decimal(19,05), U.pages_fetch_ROV / 128.0 / 1024.0)                                                                      AS GBs_fetch_ROV
        , U.leaf_inserts
        , U.limb_inserts
        , U.leaf_updates
        , U.limb_updates
        , U.leaf_deletes
        , U.limb_deletes
        , U.leaf_splits
        , U.limb_splits
        , U.forwards
        , CASE WHEN V.object_id IS NULL THEN NULL ELSE V.user_seeks   + V.system_seeks   END AS [seeks]
        , CASE WHEN V.object_id IS NULL THEN NULL ELSE V.user_scans   + V.system_scans   END AS [scans]
        , CASE WHEN V.object_id IS NULL THEN NULL ELSE V.user_lookups + V.system_lookups END AS [looks]
        , CASE WHEN V.object_id IS NULL THEN NULL ELSE (      SELECT CONVERT(varchar(0040), MAX(ISNULL(K.access_date, CONVERT(datetime, '1900/01/01'))), 120) FROM
                                                       (      SELECT V.last_user_seek   AS access_date UNION SELECT V.last_system_seek   AS access_date
                                                        UNION SELECT V.last_user_scan   AS access_date UNION SELECT V.last_system_scan   AS access_date
                                                        UNION SELECT V.last_user_lookup AS access_date UNION SELECT V.last_system_lookup AS access_date) AS K) END AS access_date
        , CASE WHEN T.large_value_types_out_of_row = 0 AND EXISTS (SELECT * FROM #TKey AS Z WHERE Z.GeneralID = E.GeneralID AND Z.max_length < 0) THEN 'EXECUTE sp_tableoption ''' + E.GeneralSchema + '.' + E.GeneralObject + ''', ''large value types out of row'', ''ON''' ELSE SPACE(0) END AS SQLCode
     FROM #Base  AS E
     JOIN sys.tables AS T
       ON E.GeneralID
        = T.object_id
LEFT JOIN #PKeys AS P
       ON E.GeneralID
        = P.GeneralID
     JOIN #WKey  AS W
       ON E.GeneralID
        = W.GeneralID
     JOIN #Work  AS I
       ON E.GeneralID
        = I.GeneralID
LEFT JOIN
  (SELECT Z.object_id
        , Z.index_id
        , SUM(Z.leaf_insert_count          ) AS leaf_inserts
        , SUM(Z.leaf_update_count          ) AS leaf_updates
        , SUM(Z.leaf_delete_count          ) AS leaf_deletes
        , SUM(Z.leaf_allocation_count      ) AS leaf_splits
        , SUM(Z.nonleaf_insert_count       ) AS limb_inserts
        , SUM(Z.nonleaf_update_count       ) AS limb_updates
        , SUM(Z.nonleaf_delete_count       ) AS limb_deletes
        , SUM(Z.nonleaf_allocation_count   ) AS limb_splits
        , SUM(Z.forwarded_fetch_count      ) AS forwards
        , SUM(Z.range_scan_count           ) AS range_scans
        , SUM(Z.singleton_lookup_count     ) AS row_lookups
        , SUM(Z.row_lock_count             ) AS row_locks
        , SUM(Z.row_lock_wait_count        ) AS row_lock_waits
        , SUM(Z.row_lock_wait_in_ms        ) AS row_lock_stall
        , SUM(Z.page_lock_count            ) AS page_locks
        , SUM(Z.page_lock_wait_count       ) AS page_lock_waits
        , SUM(Z.page_lock_wait_in_ms       ) AS page_lock_stall
        , SUM(Z.page_latch_wait_count      ) AS page_latch_waits
        , SUM(Z.page_latch_wait_in_ms      ) AS page_latch_stall
        , SUM(Z.page_io_latch_wait_count   ) AS page_io_latch_waits
        , SUM(Z.page_io_latch_wait_in_ms   ) AS page_io_latch_stall
        , SUM(Z.lob_fetch_in_pages         ) AS pages_fetch_LOB
        , SUM(Z.row_overflow_fetch_in_pages) AS pages_fetch_ROV
     FROM sys.dm_db_index_operational_stats(DB_ID(), NULL, NULL, NULL) AS Z
    WHERE Z.database_id = DB_ID()
 GROUP BY Z.object_id
        , Z.index_id) AS U
       ON W.GeneralID
        = U.object_id
      AND W.index_id
        = U.index_id
LEFT JOIN sys.dm_db_index_usage_stats AS V
       ON W.GeneralID
        = V.object_id
      AND W.index_id
        = V.index_id
      AND V.database_id = DB_ID()
    WHERE E.GeneralType IN ('U ')
      AND E.GeneralSchema LIKE @GeneralSchema
      AND E.GeneralObject LIKE @GeneralObject
--    AND ISNULL(OBJECTPROPERTY(E.GeneralID, 'TableIsMemoryOptimized'), 0)  = 0
--    AND ISNULL(OBJECTPROPERTY(E.GeneralID, 'TableTemporalType'     ), 0) != 1
 ORDER BY E.GeneralType -- does not affect sort
--      ,   SQLServerFile
--      ,   create_date
--      ,   modify_date
--      ,   table_type
--      ,   [temporal]
--      ,   [Columns] DESC
--      ,   [Width]   DESC
--      ,   [Rows]    DESC
--      ,   GBs_Table DESC
        , E.GeneralSchema
        , E.GeneralObject

/*

   SELECT T.GeneralSchema
        , T.GeneralObject
        , T.column_id
        , T.GeneralColumn
        , T.SQLServerType
        , T.collation_name
        , T.is_sparse
        , T.is_nullable
        , T.is_identity
        , T.[From]
        , T.[Plus]
        , T.[Used]
        , T.index_column_id AS PK_column -- PKey ordinal
        , T.DefaultName
        , T.DefaultCode
        , T.FormulaCode
     FROM #TKeys AS T
    WHERE T.GeneralType IN ('U ')
      AND T.GeneralSchema LIKE @GeneralSchema
      AND T.GeneralObject LIKE @GeneralObject
--    AND ISNULL(OBJECTPROPERTY(T.GeneralID, 'TableIsMemoryOptimized'), 0)  = 0
--    AND ISNULL(OBJECTPROPERTY(T.GeneralID, 'TableTemporalType'     ), 0) != 1
 ORDER BY T.GeneralType -- does not affect sort
        , T.GeneralSchema
        , T.GeneralObject
        , T.column_id

*/

DROP TABLE #Base

DROP TABLE #PKey
DROP TABLE #PKeys

DROP TABLE #FKey
DROP TABLE #FKeys

DROP TABLE #TKey
DROP TABLE #TKeys

DROP TABLE #WKey

DROP TABLE #Work

SET NOCOUNT OFF

