/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Seconds_AVG decimal(19,05) = NULL -- minimum number for Seconds_AVG, NULL means use value at Percentile below
DECLARE @Seconds_MIN decimal(19,05) = NULL -- minimum number for Seconds_MIN, NULL means use value at Percentile below
DECLARE @Seconds_MAX decimal(19,05) = NULL -- minimum number for Seconds_MAX, NULL means use value at Percentile below

DECLARE @Percentile smallint = 95 -- this must be a value from the @Percentiles table

DECLARE @CPU_time bit = 1
--      @CPU_time     = 0 means Seconds are run time
--      @CPU_time     = 1 means Seconds are CPU time

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

DECLARE @MAXDOP    bigint = (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'ma% parallelism')

DECLARE @Threshold bigint = (SELECT CONVERT(bigint, value_in_use) FROM sys.configurations WHERE name LIKE 'co% parallelism')

DECLARE @Percentiles TABLE (Percentile smallint)

INSERT @Percentiles VALUES (10), (20), (30), (40), (50), (60), (70), (80), (90), (95), (96), (97), (98), (99), (100)

IF OBJECT_ID('tempdb..#Action'     , 'U ') IS NOT NULL DROP TABLE #Action

IF OBJECT_ID('tempdb..#Percentiles', 'U ') IS NOT NULL DROP TABLE #Percentiles

IF OBJECT_ID('tempdb..#Action_Base', 'U ') IS NOT NULL DROP TABLE #Action_Base

IF OBJECT_ID('tempdb..#Action_Work', 'U ') IS NOT NULL DROP TABLE #Action_Work

   SELECT S.sql_handle
        , S.plan_handle
        , S.execution_count
        , S.statement_start_offset
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.min_elapsed_time ELSE   S.min_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MIN
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.max_elapsed_time ELSE   S.max_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MAX
     INTO #Action
     FROM sys.dm_exec_query_stats AS S
     JOIN
  (SELECT W.sql_handle
        , W.plan_handle
        , ROW_NUMBER() OVER (PARTITION BY W.sql_handle ORDER BY W.cached_time DESC, W.plan_handle) AS Instance
     FROM sys.dm_exec_procedure_stats AS W
    WHERE W.database_id >     4
      AND W.database_id < 32767) AS Z
       ON S.sql_handle
        = Z.sql_handle
      AND S.plan_handle
        = Z.plan_handle
    WHERE Z.Instance = 1
 ORDER BY S.sql_handle
        , S.statement_start_offset

   SELECT      P.Percentile
        , CASE P.Percentile WHEN  10 THEN W.P10
                            WHEN  20 THEN W.P20
                            WHEN  30 THEN W.P30
                            WHEN  40 THEN W.P40
                            WHEN  50 THEN W.P50
                            WHEN  60 THEN W.P60
                            WHEN  70 THEN W.P70
                            WHEN  80 THEN W.P80
                            WHEN  90 THEN W.P90
                            WHEN  95 THEN W.P95
                            WHEN  96 THEN W.P96
                            WHEN  97 THEN W.P97
                            WHEN  98 THEN W.P98
                            WHEN  99 THEN W.P99
                            WHEN 100 THEN W.P00 END AS Seconds_AVG
        , CASE P.Percentile WHEN  10 THEN X.P10
                            WHEN  20 THEN X.P20
                            WHEN  30 THEN X.P30
                            WHEN  40 THEN X.P40
                            WHEN  50 THEN X.P50
                            WHEN  60 THEN X.P60
                            WHEN  70 THEN X.P70
                            WHEN  80 THEN X.P80
                            WHEN  90 THEN X.P90
                            WHEN  95 THEN X.P95
                            WHEN  96 THEN X.P96
                            WHEN  97 THEN X.P97
                            WHEN  98 THEN X.P98
                            WHEN  99 THEN X.P99
                            WHEN 100 THEN X.P00 END AS Seconds_MIN
        , CASE P.Percentile WHEN  10 THEN Y.P10
                            WHEN  20 THEN Y.P20
                            WHEN  30 THEN Y.P30
                            WHEN  40 THEN Y.P40
                            WHEN  50 THEN Y.P50
                            WHEN  60 THEN Y.P60
                            WHEN  70 THEN Y.P70
                            WHEN  80 THEN Y.P80
                            WHEN  90 THEN Y.P90
                            WHEN  95 THEN Y.P95
                            WHEN  96 THEN Y.P96
                            WHEN  97 THEN Y.P97
                            WHEN  98 THEN Y.P98
                            WHEN  99 THEN Y.P99
                            WHEN 100 THEN Y.P00 END AS Seconds_MAX
     INTO #Percentiles
     FROM @Percentiles AS P
, (SELECT DISTINCT 'Seconds_AVG' AS Metric
        , PERCENTILE_DISC(0.10) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P10
        , PERCENTILE_DISC(0.20) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P20
        , PERCENTILE_DISC(0.30) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P30
        , PERCENTILE_DISC(0.40) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P40
        , PERCENTILE_DISC(0.50) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P50
        , PERCENTILE_DISC(0.60) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P60
        , PERCENTILE_DISC(0.70) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P70
        , PERCENTILE_DISC(0.80) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P80
        , PERCENTILE_DISC(0.90) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P90
        , PERCENTILE_DISC(0.95) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P95
        , PERCENTILE_DISC(0.96) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P96
        , PERCENTILE_DISC(0.97) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P97
        , PERCENTILE_DISC(0.98) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P98
        , PERCENTILE_DISC(0.99) WITHIN GROUP (ORDER BY Seconds_AVG) OVER () AS P99
        , (SELECT MAX(Seconds_AVG) FROM #Action)                            AS P00
      FROM #Action) AS W
, (SELECT DISTINCT 'Seconds_MIN' AS Metric
        , PERCENTILE_DISC(0.10) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P10
        , PERCENTILE_DISC(0.20) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P20
        , PERCENTILE_DISC(0.30) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P30
        , PERCENTILE_DISC(0.40) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P40
        , PERCENTILE_DISC(0.50) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P50
        , PERCENTILE_DISC(0.60) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P60
        , PERCENTILE_DISC(0.70) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P70
        , PERCENTILE_DISC(0.80) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P80
        , PERCENTILE_DISC(0.90) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P90
        , PERCENTILE_DISC(0.95) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P95
        , PERCENTILE_DISC(0.96) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P96
        , PERCENTILE_DISC(0.97) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P97
        , PERCENTILE_DISC(0.98) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P98
        , PERCENTILE_DISC(0.99) WITHIN GROUP (ORDER BY Seconds_MIN) OVER () AS P99
        , (SELECT MAX(Seconds_MIN) FROM #Action)                            AS P00
      FROM #Action) AS X
, (SELECT DISTINCT 'Seconds_MAX' AS Metric
        , PERCENTILE_DISC(0.10) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P10
        , PERCENTILE_DISC(0.20) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P20
        , PERCENTILE_DISC(0.30) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P30
        , PERCENTILE_DISC(0.40) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P40
        , PERCENTILE_DISC(0.50) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P50
        , PERCENTILE_DISC(0.60) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P60
        , PERCENTILE_DISC(0.70) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P70
        , PERCENTILE_DISC(0.80) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P80
        , PERCENTILE_DISC(0.90) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P90
        , PERCENTILE_DISC(0.95) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P95
        , PERCENTILE_DISC(0.96) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P96
        , PERCENTILE_DISC(0.97) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P97
        , PERCENTILE_DISC(0.98) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P98
        , PERCENTILE_DISC(0.99) WITHIN GROUP (ORDER BY Seconds_MAX) OVER () AS P99
        , (SELECT MAX(Seconds_MAX) FROM #Action)                            AS P00
      FROM #Action) AS Y
 ORDER BY P.Percentile

IF @Seconds_AVG IS NULL SELECT @Seconds_AVG = P.Seconds_AVG FROM #Percentiles AS P WHERE P.Percentile = @Percentile
IF @Seconds_MIN IS NULL SELECT @Seconds_MIN = P.Seconds_MIN FROM #Percentiles AS P WHERE P.Percentile = @Percentile
IF @Seconds_MAX IS NULL SELECT @Seconds_MAX = P.Seconds_MAX FROM #Percentiles AS P WHERE P.Percentile = @Percentile

   SELECT Z.*
     INTO #Action_Base
     FROM
  (SELECT A.sql_handle
        , A.plan_handle
        , A.execution_count
        , A.statement_start_offset
        , A.Seconds_AVG
        , A.Seconds_MIN
        , A.Seconds_MAX
        , ROW_NUMBER() OVER (PARTITION BY A.sql_handle ORDER BY A.statement_start_offset) AS StatementID
     FROM #Action AS A) AS Z
    WHERE CASE WHEN Z.Seconds_AVG !< @Seconds_AVG THEN 1
               WHEN Z.Seconds_MIN !< @Seconds_MIN THEN 1
               WHEN Z.Seconds_MAX !< @Seconds_MAX THEN 1 ELSE 0 END != 0
 ORDER BY Z.sql_handle
        , Z.statement_start_offset

   SELECT E.*
        , CONVERT(int, 0) AS T
        , CONVERT(int, 0) AS W
        , CONVERT(int, 0) AS Z
     INTO #Action_Work
     FROM
  (SELECT S.execution_count                                   AS Executions
        , DATEDIFF(second, S.creation_time, GETDATE()) + 1    AS Seconds
        , CONVERT(varchar(0040) ,       S.creation_time, 120) AS Creation
        , CONVERT(varchar(0040) , S.last_execution_time, 120) AS Last_Run
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0 / S.execution_count) AS Seconds_AVG
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN S.total_elapsed_time ELSE S.total_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_SUM
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN  S.last_elapsed_time ELSE  S.last_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_LST
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.min_elapsed_time ELSE   S.min_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MIN
        , CONVERT(decimal(19,05), CASE WHEN @CPU_time = 0 THEN   S.max_elapsed_time ELSE   S.max_worker_time END / 1000.0 / 1000.0                    ) AS Seconds_MAX
        , S.total_logical_writes / S.execution_count AS Writes_AVG
        , S.total_logical_writes                     AS Writes_SUM
        ,  S.last_logical_writes                     AS Writes_LST
        ,   S.min_logical_writes                     AS Writes_MIN
        ,   S.max_logical_writes                     AS Writes_MAX
        ,  S.total_logical_reads / S.execution_count AS LReads_AVG
        ,  S.total_logical_reads                     AS LReads_SUM
        ,   S.last_logical_reads                     AS LReads_LST
        ,    S.min_logical_reads                     AS LReads_MIN
        ,    S.max_logical_reads                     AS LReads_MAX
        , S.total_physical_reads / S.execution_count AS PReads_AVG
        , S.total_physical_reads                     AS PReads_SUM
        ,  S.last_physical_reads                     AS PReads_LST
        ,   S.min_physical_reads                     AS PReads_MIN
        ,   S.max_physical_reads                     AS PReads_MAX
        ,           S.total_rows / S.execution_count AS Rows_AVG
        ,           S.total_rows                     AS Rows_SUM
        ,            S.last_rows                     AS Rows_LST
        ,             S.min_rows                     AS Rows_MIN
        ,             S.max_rows                     AS Rows_MAX
        ,            DB_NAME(            V.dbid) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(V.objectid, V.dbid) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(V.objectid, V.dbid) COLLATE database_default AS ObjectName
        ,                               SPACE(2) COLLATE database_default AS ObjectType
        , CASE WHEN S.statement_start_offset < 0 THEN     0                                                                            ELSE (S.statement_start_offset / 2)     END + 1 AS I
        , CASE WHEN S.statement_end_offset   < 0 THEN LEN(T.text) WHEN S.statement_end_offset > (LEN(T.text) * 2) - 4 THEN LEN(T.text) ELSE (S.statement_end_offset   / 2) + 1 END + 1 AS O
        , T.text COLLATE database_default AS text
        , S.sql_handle
        ,                 CONVERT(nvarchar(max), V.query_plan) COLLATE database_default AS query_plan
        , REPLACE(
          REPLACE(
          REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(
          REPLACE(REPLACE(CONVERT(nvarchar(max), V.query_plan), '&#x09;', ''), '&#x9;', '')
                                                              , '&#x0D;', ''), '&#xD;', '')
                                                              , '&#x0A;', ''), '&#xA;', '')
                                                              , '&amp;amp;amp;', '')
                                                              , '&amp;amp;'    , '')
                                                              , '&amp;'        , '') COLLATE database_default AS query_plus
        , A.StatementID
     FROM #Action_Base AS A
     JOIN sys.dm_exec_query_stats AS S
       ON A.sql_handle
        = S.sql_handle
      AND A.plan_handle
        = S.plan_handle
      AND A.statement_start_offset
        = S.statement_start_offset
    OUTER APPLY sys.dm_exec_sql_text(S.sql_handle) AS T OUTER APPLY sys.dm_exec_query_plan(S.plan_handle) AS V) AS E
 ORDER BY E.sql_handle
        , E.I

   UPDATE #Action_Work SET T = CHARINDEX(LEFT(REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(SUBSTRING(E.text, E.I, E.O - E.I), CHAR(09), '')      
                                                                                       , CHAR(13), '')      
                                                                                       , CHAR(10), '')      
                                                                                       , '&amp;' , '')      
                                                                                       , '&'     , '')      
                                                                                       , '['     , '{'     )
                                                                                       , ']'     , '}'     )
                                                                                       , '<'     , '&lt;'  )
                                                                                       , '>'     , '&gt;'  )
                                                                                       , '"'     , '&quot;'), 2000), E.query_plus, 1)
     FROM #Action_Work AS E
    WHERE E.T = 0

   UPDATE #Action_Work SET T = CHARINDEX(LEFT(REPLACE(
                                              REPLACE(
                                              REPLACE(
--                                            REPLACE(
--                                            REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(
                                              REPLACE(SUBSTRING(E.text, E.I, E.O - E.I), CHAR(09), '')      
                                                                                       , CHAR(13), '')      
                                                                                       , CHAR(10), '')      
                                                                                       , '&amp;' , '')      
                                                                                       , '&'     , '')      
--                                                                                     , '['     , '{'     )
--                                                                                     , ']'     , '}'     )
                                                                                       , '<'     , '&lt;'  )
                                                                                       , '>'     , '&gt;'  )
                                                                                       , '"'     , '&quot;'), 2000), E.query_plus, 1)
     FROM #Action_Work AS E
    WHERE E.T = 0

   UPDATE #Action_Work SET W = CHARINDEX('StatementSubTreeCost="', E.query_plus, E.T + 2)
     FROM #Action_Work AS E

   UPDATE #Action_Work SET Z = CHARINDEX('"', E.query_plus, E.W + 22)
     FROM #Action_Work AS E

/*

   SELECT @Seconds_AVG AS Seconds_AVG
        , @Seconds_MIN AS Seconds_MIN
        , @Seconds_MAX AS Seconds_MAX
        , @Threshold   AS Threshold
        , @MAXDOP      AS MAXDOP

*/

   SELECT P.Percentile
        , P.Seconds_AVG
        , P.Seconds_MIN
        , P.Seconds_MAX
     FROM  #Percentiles AS P
 ORDER BY P.Percentile

   SELECT U.Executions
        , U.[Runs/Hour]
        , U.[Time/Hour]
        , U.Creation
        , U.Last_Run
        , U.Seconds_AVG -- average
        , U.Seconds_MIN -- minimum
        , U.Seconds_MAX -- maximum
        , U.LReads_AVG
        , U.LReads_MIN
        , U.LReads_MAX
        , U.Writes_AVG
        , U.Writes_MIN
        , U.Writes_MAX
        , CASE WHEN U.Seconds_AVG  !< @Seconds_AVG THEN 'Over_AVG'  ELSE NULL END AS Over_AVG
        , CASE WHEN U.Seconds_MIN  !< @Seconds_MIN THEN 'Over_MIN'  ELSE NULL END AS Over_MIN
        , CASE WHEN U.Seconds_MAX  !< @Seconds_MAX THEN 'Over_MAX'  ELSE NULL END AS Over_MAX
        , CASE WHEN U.CostEstimate !< @Threshold   THEN 'Threshold' ELSE NULL END AS Threshold
        , U.CostEstimate
        , U.DBName
        , U.SchemaName
        , U.ObjectName
--      , U.ObjectType
--      , U.sql_handle
--      , U.query_plan
        , U.SQL_code
        , U.Query
     FROM
  (SELECT E.Executions
        ,                         CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END                  AS [Runs/Hour]
        , CONVERT(decimal(19,02), CASE WHEN E.Seconds < 3600 THEN E.Executions ELSE CONVERT(decimal(19,00), E.Executions * 3600.0 / E.Seconds) END * E.Seconds_AVG) AS [Time/Hour]
        , E.Creation
        , E.Last_Run
        , E.Seconds_AVG -- average
        , E.Seconds_MIN -- minimum
        , E.Seconds_MAX -- maximum
        , E.LReads_AVG
        , E.LReads_MIN
        , E.LReads_MAX
--      , E.PReads_AVG
--      , E.PReads_MIN
--      , E.PReads_MAX
        , E.Writes_AVG
        , E.Writes_MIN
        , E.Writes_MAX
--      , E.Rows_AVG
--      , E.Rows_MIN
--      , E.Rows_MAX
        , E.DBName
        , E.SchemaName
        , E.ObjectName
        , E.ObjectType
        , E.sql_handle
--      , CONVERT(XML, E.query_plan) AS query_plan
        , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
--      ,           E.text                  AS SQL_code_all
        , E.StatementID AS Query
        , CONVERT(decimal(19,05), CONVERT(float(53), CASE WHEN E.T > 0 AND E.W > 0 AND E.W < E.Z THEN SUBSTRING(E.query_plus, E.W + 22, E.Z - E.W - 22) ELSE NULL END)) AS CostEstimate
     FROM #Action_Work AS E) AS U
 ORDER BY U.DBName
        , U.SchemaName
        , U.ObjectName
        , U.sql_handle
        , U.Query

DROP TABLE #Action

DROP TABLE #Percentiles

DROP TABLE #Action_Base

DROP TABLE #Action_Work

SET NOCOUNT OFF

