/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @Brackets bit = 0 -- use brackets on object/column names

DECLARE @X varchar(0010) = CASE WHEN @Brackets = 0 THEN SPACE(0) ELSE '[' END
DECLARE @Y varchar(0010) = CASE WHEN @Brackets = 0 THEN SPACE(0) ELSE ']' END

DECLARE @GeneralID int

DECLARE @GeneralType char(0002)

DECLARE @GeneralSchema varchar(0128) = 'dbo' -- enter schema name here

DECLARE @GeneralObject varchar(0128) = 'TBD' -- enter object name here

DECLARE @GeneralColumn varchar(0128)

DECLARE @A smallint = 0
DECLARE @I smallint
DECLARE @O smallint
DECLARE @W smallint
DECLARE @Z smallint
DECLARE @T smallint

DECLARE @Layer smallint

DECLARE @Batch smallint

DECLARE @PrimaryID int
DECLARE @PrimarySchema varchar(0128)
DECLARE @PrimaryObject varchar(0128)
DECLARE @PrimaryColumn varchar(0128)

DECLARE @ForeignID int
DECLARE @ForeignSchema varchar(0128)
DECLARE @ForeignObject varchar(0128)
DECLARE @ForeignColumn varchar(0128)

DECLARE @SQLCode varchar(4000)
DECLARE @SQLMode varchar(4000)

DECLARE @U bit

IF OBJECT_ID('tempdb..#PKey' , 'U ') IS NOT NULL DROP TABLE #PKey
IF OBJECT_ID('tempdb..#PKeys', 'U ') IS NOT NULL DROP TABLE #PKeys

IF OBJECT_ID('tempdb..#FKey' , 'U ') IS NOT NULL DROP TABLE #FKey
IF OBJECT_ID('tempdb..#FKeys', 'U ') IS NOT NULL DROP TABLE #FKeys

   SELECT O.object_id AS GeneralID
        , O.name      AS GeneralObject
        , S.name      AS GeneralSchema
        ,        H.name          AS SQLServerFile
        , ISNULL(I.name, O.name) AS SQLServerName
        , I.index_id
        , I.type      AS table_type
        , I.type      AS index_type
        , I.fill_factor
        , I.is_primary_key
        , I.is_unique_constraint
        , M.is_descending_key
        , M.partition_ordinal
        , M.key_ordinal
        , C.name      AS GeneralColumn
     INTO #PKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND CASE WHEN I.is_primary_key       != 0 THEN 1
               WHEN I.is_unique_constraint != 0 THEN 1 ELSE 0 END != 0
     JOIN sys.index_columns AS M
       ON I.object_id
        = M.object_id
      AND I.index_id
        = M.index_id
     JOIN sys.columns AS C
       ON M.object_id
        = C.object_id
      AND M.column_id
        = C.column_id
LEFT JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   GeneralSchema
        ,   GeneralObject
        ,   SQLServerName
        ,   key_ordinal

   SELECT P.GeneralID
        , P.GeneralObject
        , P.GeneralSchema
        , P.SQLServerFile
        , P.SQLServerName
        , LEN(P.GeneralSchema)
        + LEN(P.GeneralObject) AS I
        , LEN(P.GeneralObject) AS O
        , CONVERT(     int, -1) AS Layer
        , CONVERT(     int, -1) AS Estimate
--      , CONVERT(smallint,  0) AS Factor01
--      , CONVERT(smallint,  0) AS Factor02
--      , CONVERT(smallint,  0) AS Factor03
--      , CONVERT(smallint,  0) AS Factor04
--      , CONVERT(smallint,  0) AS Factor05
     INTO #PKeys
     FROM #PKey AS P
    WHERE P.is_primary_key != 0
 GROUP BY P.GeneralID
        , P.GeneralObject
        , P.GeneralSchema
        , P.SQLServerFile
        , P.SQLServerName
 ORDER BY P.GeneralSchema
        , P.GeneralObject
        , P.SQLServerName

   SELECT O.object_id AS ForeignID
        , W.object_id AS PrimaryID
        , O.name      AS ForeignObject
        , W.name      AS PrimaryObject
        , S.name      AS ForeignSchema
        , Z.name      AS PrimarySchema
        , F.name      AS SQLServerName
        , CONVERT(varchar(0040), F.create_date, 120) AS create_date
        , CONVERT(varchar(0040), F.modify_date, 120) AS modify_date
        , F.is_disabled
        , F.is_not_trusted
        , M.constraint_column_id
        , C.name      AS ForeignColumn
        , K.name      AS PrimaryColumn
     INTO #FKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.foreign_keys AS F
       ON        O.object_id
        = F.parent_object_id
     JOIN sys.foreign_key_columns AS M
       ON            F.object_id
        = M.constraint_object_id
     JOIN sys.columns AS C
       ON M.parent_object_id
        =        C.object_id
      AND M.parent_column_id
        =        C.column_id
     JOIN sys.columns AS K
       ON M.referenced_object_id
        =            K.object_id
      AND M.referenced_column_id
        =            K.column_id
     JOIN sys.objects AS W
       ON F.referenced_object_id
        =            W.object_id
--    AND            O.object_id
--     !=            W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
      AND Z.name IN (SELECT [Schema] FROM @Match)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
 ORDER BY   PrimarySchema
        ,   PrimaryObject
        ,   ForeignSchema
        ,   ForeignObject
        ,   constraint_column_id

   SELECT F.PrimaryID
        , F.ForeignID
        , F.PrimaryObject
        , F.ForeignObject
        , F.PrimarySchema
        , F.ForeignSchema
        , F.SQLServerName
        , COUNT(*) AS Columns
     INTO #FKeys
     FROM #FKey AS F
    WHERE F.PrimaryID
       != F.ForeignID
 GROUP BY F.PrimaryID
        , F.ForeignID
        , F.PrimaryObject
        , F.ForeignObject
        , F.PrimarySchema
        , F.ForeignSchema
        , F.SQLServerName
 ORDER BY F.PrimarySchema
        , F.PrimaryObject
        , F.ForeignSchema
        , F.ForeignObject

SET @Layer = 0

SET @Batch = 0

/*

   UPDATE P SET Layer = @Layer
     FROM #PKeys AS P
LEFT JOIN #FKeys AS F
       ON P.GeneralID
        = F.ForeignID
    WHERE F.ForeignID IS NULL

*/

   UPDATE P SET Layer = @Layer
     FROM #PKeys AS P
    WHERE P.GeneralSchema
        =  @GeneralSchema
      AND P.GeneralObject
        =  @GeneralObject

SET @Batch = @@ROWCOUNT

WHILE @Batch > 0 AND @Layer < 90

    BEGIN

    SET @Layer = @Layer + 1

/*

       UPDATE P SET Layer = @Layer
         FROM #PKeys AS P
        WHERE NOT EXISTS
      (SELECT *
         FROM #PKeys AS W
         JOIN #FKeys AS Z
           ON W.GeneralID
            = Z.PrimaryID
          AND P.GeneralID
            = Z.ForeignID
        WHERE W.Layer < 0)
          AND P.Layer < 0

*/

       UPDATE P SET Layer = @Layer
         FROM #PKeys AS P
         JOIN
      (SELECT Z.ForeignID
         FROM #PKeys AS W
         JOIN #FKeys AS Z
           ON W.GeneralID
            = Z.PrimaryID
        WHERE W.Layer = @Layer - 1) AS T
           ON P.GeneralID
            = T.ForeignID

    SET @Batch = @@ROWCOUNT

    END

   SELECT P.GeneralSchema
        , P.GeneralObject
        ,        H.name          AS SQLServerFile
--      , ISNULL(I.name, O.name) AS SQLServerName
        , CONVERT(varchar(0040), O.create_date, 120) AS create_date
        , CONVERT(varchar(0040), O.modify_date, 120) AS modify_date
        , I.type AS table_type
--      , I.type AS index_type
--      , ISNULL(CONVERT(decimal(38,00), IDENT_SEED   (P.GeneralSchema + '.' + P.GeneralObject)), 0) AS [From]
--      , ISNULL(CONVERT(decimal(38,00), IDENT_INCR   (P.GeneralSchema + '.' + P.GeneralObject)), 0) AS [Plus]
--      , ISNULL(CONVERT(decimal(38,00), IDENT_CURRENT(P.GeneralSchema + '.' + P.GeneralObject)), 0) AS [Used]
        , (SELECT COUNT(*) FROM #FKeys AS F WHERE F.ForeignID = P.GeneralID) AS [FKs_P]
        , (SELECT COUNT(*) FROM #FKeys AS F WHERE F.PrimaryID = P.GeneralID) AS [FKs_C]
        , P.Layer
     FROM #PKeys AS P
     JOIN sys.objects AS O
       ON P.GeneralID
        = O.object_id
     JOIN sys.indexes AS I
       ON O.object_id
        = I.object_id
      AND I.type IN (0, 1, 5)
     JOIN sys.data_spaces AS H
       ON I.data_space_id
        = H.data_space_id
    WHERE P.Layer !< 0
 ORDER BY P.Layer
        , P.GeneralSchema
        , P.GeneralObject

-- generate SQL

PRINT '-- CREATE temporary tables'

PRINT CHAR(13) + CHAR(10)

  DECLARE Objects CURSOR FAST_FORWARD FOR
   SELECT P.GeneralID
        , P.GeneralSchema
        , P.GeneralObject
        , P.I
        , (SELECT MAX(T.key_ordinal) FROM #PKey AS T WHERE T.GeneralID = P.GeneralID AND T.is_primary_key != 0) AS Z
     FROM #PKeys AS P
    WHERE P.Layer !< 0
 ORDER BY P.Layer
        , P.GeneralSchema
        , P.GeneralObject

OPEN Objects

FETCH NEXT FROM Objects INTO @GeneralID, @GeneralSchema, @GeneralObject, @W, @Z

WHILE @@FETCH_STATUS = 0

    BEGIN

    SET @SQLCode = SPACE(0)
    SET @SQLMode = SPACE(0)

      DECLARE Columns CURSOR FAST_FORWARD FOR
       SELECT P.key_ordinal
            , P.GeneralColumn
            , COLUMNPROPERTY(P.GeneralID, P.GeneralColumn, 'IsIdentity')
         FROM #PKey AS P
        WHERE P.GeneralID
            =  @GeneralID
          AND P.is_primary_key != 0
     ORDER BY P.key_ordinal

    OPEN Columns

    FETCH NEXT FROM Columns INTO @T, @GeneralColumn, @U

    WHILE @@FETCH_STATUS = 0

        BEGIN

        IF @U  = 0 SET @SQLCode = @SQLCode + CASE WHEN @T = 1 THEN SPACE(0) ELSE CHAR(13) + CHAR(10) + '        , ' END +           'T.' + @X + @GeneralColumn + @Y

        IF @U != 0 SET @SQLCode = @SQLCode + CASE WHEN @T = 1 THEN SPACE(0) ELSE CHAR(13) + CHAR(10) + '        , ' END + 'CASE WHEN T.' + @X + @GeneralColumn + @Y + ' IS NULL THEN T.' + @X + @GeneralColumn + @Y + ' ELSE ' + 'T.' + @X + @GeneralColumn + @Y + ' END AS ' + @X + @GeneralColumn + @Y

        FETCH NEXT FROM Columns INTO @T, @GeneralColumn, @U

        END

    CLOSE Columns DEALLOCATE Columns

    PRINT '   SELECT ' + @SQLCode

    PRINT '     INTO ' + SPACE(LEN(@GeneralSchema)) + '#' + @GeneralObject

    PRINT '     FROM ' + @GeneralSchema + '.' + @GeneralObject + ' AS T'

    PRINT '    WHERE 0 = 1'

    PRINT CHAR(13) + CHAR(10)

    FETCH NEXT FROM Objects INTO @GeneralID, @GeneralSchema, @GeneralObject, @W, @Z

    END

CLOSE Objects DEALLOCATE Objects

   SELECT  @GeneralID
        = P.GeneralID
        ,  @GeneralSchema
        = P.GeneralSchema
        ,  @GeneralObject
        = P.GeneralObject
     FROM #PKeys AS P
    WHERE P.Layer= 0

SET @Batch = @@ROWCOUNT

SET @Layer = 0

SET @SQLCode = SPACE(0)
SET @SQLMode = SPACE(0)

PRINT '-- INSERT temporary tables -- >>>>> set DELETE filter criteria in the WHERE clause below <<<<<'

PRINT CHAR(13) + CHAR(10)

  DECLARE Columns CURSOR FAST_FORWARD FOR
   SELECT P.key_ordinal
        , P.GeneralColumn
     FROM #PKey AS P
    WHERE P.GeneralID
        =  @GeneralID
      AND P.is_primary_key != 0
 ORDER BY P.key_ordinal

OPEN Columns

FETCH NEXT FROM Columns INTO @T, @GeneralColumn

WHILE @@FETCH_STATUS = 0

    BEGIN

    SET @SQLCode = @SQLCode + CASE WHEN @T = 1 THEN SPACE(0) ELSE CHAR(13) + CHAR(10) + '        , ' END + 'T.' + @X + @GeneralColumn + @Y

    FETCH NEXT FROM Columns INTO @T, @GeneralColumn

    END

CLOSE Columns DEALLOCATE Columns

PRINT '   INSERT ' + SPACE(LEN(@GeneralSchema)) + '#' + @GeneralObject

PRINT '   SELECT ' + @SQLCode

PRINT '     FROM ' + @GeneralSchema + '.' + @GeneralObject + ' AS T'

PRINT '    WHERE 0 = 1'

PRINT CHAR(13) + CHAR(10)

WHILE @Batch > 0

    BEGIN

      DECLARE Parents CURSOR FAST_FORWARD FOR
       SELECT P.GeneralID
            , P.GeneralSchema
            , P.GeneralObject
         FROM #PKeys AS P
        WHERE P.Layer
            =  @Layer
     ORDER BY P.Layer
            , P.GeneralSchema
            , P.GeneralObject

    OPEN Parents

    FETCH NEXT FROM Parents INTO @PrimaryID, @PrimarySchema, @PrimaryObject

    WHILE @@FETCH_STATUS = 0

        BEGIN

          DECLARE Objects CURSOR FAST_FORWARD FOR
           SELECT F.ForeignID
                , F.ForeignSchema
                , F.ForeignObject
             FROM #FKeys AS F
            WHERE F.PrimaryID
                =  @PrimaryID
         ORDER BY F.ForeignSchema
                , F.ForeignObject

        OPEN Objects

        FETCH NEXT FROM Objects INTO @ForeignID, @ForeignSchema, @ForeignObject

        WHILE @@FETCH_STATUS = 0

            BEGIN

            SET @SQLCode = SPACE(0)
            SET @SQLMode = SPACE(0)

              DECLARE Columns CURSOR FAST_FORWARD FOR
               SELECT P.key_ordinal
                    , P.GeneralColumn
                 FROM #PKey AS P
                WHERE P.GeneralID
                    =  @ForeignID
                  AND P.is_primary_key != 0
             ORDER BY P.key_ordinal

            OPEN Columns

            FETCH NEXT FROM Columns INTO @T, @GeneralColumn

            WHILE @@FETCH_STATUS = 0

                BEGIN

                SET @SQLCode = @SQLCode + CASE WHEN @T = 1 THEN SPACE(0) ELSE CHAR(13) + CHAR(10) + '        , ' END + 'T.' + @X + @GeneralColumn + @Y

                FETCH NEXT FROM Columns INTO @T, @GeneralColumn

                END

            CLOSE Columns DEALLOCATE Columns

              DECLARE Columns CURSOR FAST_FORWARD FOR
               SELECT F.PrimaryColumn
                    , F.ForeignColumn
                    , F.constraint_column_id
                 FROM #FKey AS F
                WHERE F.PrimaryID
                    =  @PrimaryID
                  AND F.ForeignID
                    =  @ForeignID
             ORDER BY F.constraint_column_id

            OPEN Columns

            FETCH NEXT FROM Columns INTO @PrimaryColumn, @ForeignColumn, @T

            WHILE @@FETCH_STATUS = 0

                BEGIN

                SET @SQLMode = @SQLMode + CASE WHEN @T = 1 THEN SPACE(0) ELSE CHAR(13) + CHAR(10) + '      AND ' END + 'T.' + @X + @ForeignColumn + @Y + CHAR(13) + CHAR(10) + '        = '     + 'I.' + @X + @PrimaryColumn + @Y

                FETCH NEXT FROM Columns INTO @PrimaryColumn, @ForeignColumn, @T

                END

            CLOSE Columns DEALLOCATE Columns

            PRINT '   INSERT ' + SPACE(LEN(@ForeignSchema)) + '#' + @ForeignObject

            PRINT '   SELECT ' + @SQLCode

            PRINT '     FROM ' + @ForeignSchema + '.' + @ForeignObject + ' AS T'

            PRINT '     JOIN ' + SPACE(LEN(@ForeignSchema)) + '#' + @PrimaryObject + ' AS I'

            PRINT '       ON ' + @SQLMode

            PRINT CHAR(13) + CHAR(10)

            FETCH NEXT FROM Objects INTO @ForeignID, @ForeignSchema, @ForeignObject

            END

        CLOSE Objects DEALLOCATE Objects

        FETCH NEXT FROM Parents INTO @PrimaryID, @PrimarySchema, @PrimaryObject

        END

    CLOSE Parents DEALLOCATE Parents

    SET @Layer = @Layer + 1

    SET @Batch = (SELECT COUNT(*) FROM #PKeys AS P WHERE P.Layer = @Layer)

    END

PRINT '-- DELETE rows from the bottom up'

PRINT CHAR(13) + CHAR(10)

  DECLARE Objects CURSOR FAST_FORWARD FOR
   SELECT P.GeneralID
        , P.GeneralSchema
        , P.GeneralObject
     FROM #PKeys AS P
    WHERE P.Layer !< 0
 ORDER BY P.Layer DESC
        , P.GeneralSchema
        , P.GeneralObject

OPEN Objects

FETCH NEXT FROM Objects INTO @GeneralID, @GeneralSchema, @GeneralObject

WHILE @@FETCH_STATUS = 0

    BEGIN

    SET @SQLCode = SPACE(0)
    SET @SQLMode = SPACE(0)

      DECLARE Columns CURSOR FAST_FORWARD FOR
       SELECT P.key_ordinal
            , P.GeneralColumn
         FROM #PKey AS P
        WHERE P.GeneralID
            =  @GeneralID
          AND P.is_primary_key != 0
     ORDER BY P.key_ordinal

    OPEN Columns

    FETCH NEXT FROM Columns INTO @T, @GeneralColumn

    WHILE @@FETCH_STATUS = 0

        BEGIN

        SET @SQLMode = @SQLMode + CASE WHEN @T = 1 THEN SPACE(0) ELSE CHAR(13) + CHAR(10) + '      AND ' END + 'T.' + @X + @GeneralColumn + @Y + CHAR(13) + CHAR(10) + '        = '     + 'I.' + @X + @GeneralColumn + @Y

        FETCH NEXT FROM Columns INTO @T, @GeneralColumn

        END

    CLOSE Columns DEALLOCATE Columns

--  PRINT '   SELECT T.*'

    PRINT '   DELETE ' + @GeneralSchema + '.' + @GeneralObject

    PRINT '     FROM ' + @GeneralSchema + '.' + @GeneralObject + ' AS T'

    PRINT '     JOIN ' + SPACE(LEN(@GeneralSchema)) + '#' + @GeneralObject + ' AS I'

    PRINT '       ON ' + @SQLMode

    PRINT CHAR(13) + CHAR(10)

    FETCH NEXT FROM Objects INTO @GeneralID, @GeneralSchema, @GeneralObject

    END

CLOSE Objects DEALLOCATE Objects

PRINT '-- DROP temporary tables'

PRINT CHAR(13) + CHAR(10)

  DECLARE Objects CURSOR FAST_FORWARD FOR
   SELECT P.GeneralID
        , P.GeneralSchema
        , P.GeneralObject
     FROM #PKeys AS P
    WHERE P.Layer !< 0
 ORDER BY P.Layer
        , P.GeneralSchema
        , P.GeneralObject

OPEN Objects

FETCH NEXT FROM Objects INTO @GeneralID, @GeneralSchema, @GeneralObject

WHILE @@FETCH_STATUS = 0

    BEGIN

    PRINT 'DROP TABLE #' + @GeneralObject

    PRINT CHAR(13) + CHAR(10)

    FETCH NEXT FROM Objects INTO @GeneralID, @GeneralSchema, @GeneralObject

    END

CLOSE Objects DEALLOCATE Objects

DROP TABLE #PKey
DROP TABLE #PKeys

DROP TABLE #FKey
DROP TABLE #FKeys

SET NOCOUNT OFF

