/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @Match TABLE ([Schema] varchar(0128))

/*

INSERT @Match ([Schema])
VALUES ('dbo')
     , ('dba')

*/

   INSERT @Match ([Schema])
   SELECT S.name
     FROM sys.schemas AS S
    WHERE CASE WHEN S.schema_id  =     1 THEN 1
               WHEN S.schema_id  =     2 THEN 0
               WHEN S.schema_id  =     3 THEN 0
               WHEN S.schema_id  =     4 THEN 0
               WHEN S.schema_id !< 16384 THEN 0 ELSE 1 END != 0
 ORDER BY S.schema_id

DECLARE @PrimaryID int
DECLARE @PrimaryObject varchar(0128)
DECLARE @PrimarySchema varchar(0128)
DECLARE @PrimaryColumn varchar(0128)

DECLARE @ForeignID int
DECLARE @ForeignObject varchar(0128)
DECLARE @ForeignSchema varchar(0128)
DECLARE @ForeignColumn varchar(0128)

DECLARE @VirtualID int

DECLARE @ControlColumn varchar(0128)

DECLARE @SQLServerName varchar(0128)

DECLARE @Z char(0002) = CHAR(13) + CHAR(10)

DECLARE @I bigint

DECLARE @SQLMore varchar(4800)

DECLARE @SQLCode varchar(4000) = '
   SELECT @VirtualID
        , F.@ControlColumn
        , F.@ForeignColumn
     FROM @ForeignSchema.@ForeignObject AS F
LEFT JOIN @PrimarySchema.@PrimaryObject AS P
       ON F.@ForeignColumn
        = P.@PrimaryColumn
    WHERE F.@ForeignColumn IS NOT NULL
      AND P.@PrimaryColumn IS     NULL
 ORDER BY F.@ControlColumn ' + @Z

IF OBJECT_ID('tempdb..#FKey', 'U ') IS NOT NULL DROP TABLE #FKey

IF OBJECT_ID('tempdb..#VKey', 'U ') IS NOT NULL DROP TABLE #VKey

IF OBJECT_ID('tempdb..#WKey', 'U ') IS NOT NULL DROP TABLE #WKey

   SELECT O.object_id AS ForeignID
        , W.object_id AS PrimaryID
        , O.name      AS ForeignObject
        , W.name      AS PrimaryObject
        , S.name      AS ForeignSchema
        , Z.name      AS PrimarySchema
        , F.name      AS SQLServerName
        , CONVERT(varchar(0040), F.create_date, 120) AS create_date
        , CONVERT(varchar(0040), F.modify_date, 120) AS modify_date
        , F.is_disabled
        , F.is_not_trusted
--      , M.constraint_column_id
        , F.object_id AS VirtualID
        , V.name      AS ControlColumn
        , C.name      AS ForeignColumn
        , K.name      AS PrimaryColumn
--      , F.delete_referential_action
--      , F.delete_referential_action_desc
--      , F.update_referential_action
--      , F.update_referential_action_desc
     INTO #FKey
     FROM sys.schemas AS S
     JOIN sys.objects AS O
       ON S.schema_id
        = O.schema_id
     JOIN sys.foreign_keys AS F
       ON        O.object_id
        = F.parent_object_id
     JOIN sys.foreign_key_columns AS M
       ON            F.object_id
        = M.constraint_object_id
      AND M.constraint_column_id = 1
     JOIN sys.indexes AS I
       ON M.parent_object_id
        =        I.object_id
      AND I.is_primary_key != 0
     JOIN sys.index_columns AS E
       ON I.object_id
        = E.object_id
      AND I.index_id
        = E.index_id
      AND E.index_column_id = 1
     JOIN sys.columns AS V
       ON E.object_id
        = V.object_id
      AND E.column_id
        = V.column_id
     JOIN sys.columns AS C
       ON M.parent_object_id
        =        C.object_id
      AND M.parent_column_id
        =        C.column_id
     JOIN sys.columns AS K
       ON M.referenced_object_id
        =            K.object_id
      AND M.referenced_column_id
        =            K.column_id
     JOIN sys.objects AS W
       ON F.referenced_object_id
        =            W.object_id
--    AND            O.object_id
--     !=            W.object_id
     JOIN sys.schemas AS Z
       ON W.schema_id
        = Z.schema_id
      AND Z.name IN (SELECT [Schema] FROM @Match)
    WHERE S.name IN (SELECT [Schema] FROM @Match)
      AND O.type IN ('U ')
      AND O.name NOT LIKE 'sysdiagram%'
      AND O.is_ms_shipped = 0
      AND CASE WHEN F.is_disabled != 0 THEN 1 WHEN F.is_not_trusted != 0 THEN 1 ELSE 0 END = 1
 ORDER BY   PrimarySchema
        ,   PrimaryObject
        ,   ForeignSchema
        ,   ForeignObject
--      ,   constraint_column_id

   SELECT F.VirtualID
        , CONVERT(bigint, 0) AS ReferenceByID
        , CONVERT(bigint, 0) AS ReferenceOfID
     INTO #VKey
     FROM #FKey AS F
    WHERE 0 = 1

   SELECT I.object_id
        , SUM(P.rows)    AS [Rows]
     INTO #WKey
     FROM sys.indexes    AS I
     JOIN sys.partitions AS P
       ON I.object_id
        = P.object_id
      AND I.index_id
        = P.index_id
    WHERE I.type IN (0, 1, 5)
 GROUP BY I.object_id

  DECLARE DBItems CURSOR FAST_FORWARD FOR
   SELECT F.PrimarySchema
        , F.PrimaryObject
        , F.PrimaryColumn
        , F.ForeignSchema
        , F.ForeignObject
        , F.ForeignColumn
        , F.ControlColumn
        , F.SQLServerName
        , F.PrimaryID
        , F.ForeignID
        , F.VirtualID
     FROM #FKey AS F
 ORDER BY F.PrimarySchema
        , F.PrimaryObject
        , F.ForeignSchema
        , F.ForeignObject
        , F.SQLServerName

OPEN DBItems

FETCH NEXT FROM DBItems INTO @PrimarySchema, @PrimaryObject, @PrimaryColumn, @ForeignSchema, @ForeignObject, @ForeignColumn, @ControlColumn, @SQLServerName, @PrimaryID, @ForeignID, @VirtualID

WHILE @@FETCH_STATUS = 0

    BEGIN

    SET @SQLMore = REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(
                   REPLACE(@SQLCode, '@SQLServerName', @SQLServerName)
                                   , '@ControlColumn', @ControlColumn)
                                   , '@ForeignColumn', @ForeignColumn)
                                   , '@PrimaryColumn', @PrimaryColumn)
                                   , '@ForeignObject', @ForeignObject)
                                   , '@PrimaryObject', @PrimaryObject)
                                   , '@ForeignSchema', @ForeignSchema)
                                   , '@PrimarySchema', @PrimarySchema)
                                   , '@VirtualID', CONVERT(varchar(0010), @VirtualID))
                                   , '@ForeignID', CONVERT(varchar(0010), @ForeignID))
                                   , '@PrimaryID', CONVERT(varchar(0010), @PrimaryID))

    INSERT #VKey EXECUTE (@SQLMore)

    SET @I = @@ROWCOUNT

    SET @SQLMore = CASE WHEN @I > 0 THEN '--' + SPACE(1) ELSE SPACE(3) END + 'ALTER TABLE ' + @ForeignSchema + '.' + @ForeignObject + ' WITH CHECK CHECK CONSTRAINT ' + @SQLServerName

    PRINT @SQLMore

    FETCH NEXT FROM DBItems INTO @PrimarySchema, @PrimaryObject, @PrimaryColumn, @ForeignSchema, @ForeignObject, @ForeignColumn, @ControlColumn, @SQLServerName, @PrimaryID, @ForeignID, @VirtualID

    END

CLOSE DBItems DEALLOCATE DBItems

   SELECT F.ForeignSchema
        , F.ForeignObject
        , F.ForeignColumn
        , F.PrimarySchema
        , F.PrimaryObject
        , F.PrimaryColumn
        , F.SQLServerName
--      , F.ControlColumn
        , Z.MyCOUNT AS [Rows]
        , CONVERT(decimal(05,02), Z.MyCOUNT * 100.0 / W.[Rows]) AS [Percent]
     FROM #FKey AS F
     JOIN #WKey AS W
       ON F.ForeignID
        = W.object_id
     JOIN
  (SELECT V.VirtualID
        , COUNT(*) AS MyCOUNT
     FROM #VKey AS V
 GROUP BY V.VirtualID) AS Z
       ON F.VirtualID
        = Z.VirtualID
 ORDER BY F.ForeignSchema
        , F.ForeignObject
        , F.PrimarySchema
        , F.PrimaryObject
        , F.SQLServerName

   SELECT F.ForeignSchema
        , F.ForeignObject
        , F.ForeignColumn
        , F.PrimarySchema
        , F.PrimaryObject
        , F.PrimaryColumn
        , F.SQLServerName
--      , F.ControlColumn
        , V.ReferenceByID
        , V.ReferenceOfID
     FROM #FKey AS F
     JOIN #VKey AS V
       ON F.VirtualID
        = V.VirtualID
 ORDER BY F.ForeignSchema
        , F.ForeignObject
        , F.PrimarySchema
        , F.PrimaryObject
        , F.SQLServerName
        , V.ReferenceByID

DROP TABLE #FKey

DROP TABLE #VKey

DROP TABLE #WKey

SET NOCOUNT OFF

