/* ------------------------------ *\

    Copyright 2021 by Wingenious

   see README for license details

\* ------------------------------ */


SET NOCOUNT ON

DECLARE @BaseVersion varchar(1000) = CONVERT(varchar(1000), SERVERPROPERTY('ProductVersion'))

DECLARE @Information varchar(4000) =
CASE WHEN    @@VERSION LIKE '%Azure%' THEN 'SQL Server PaaS '
     WHEN @BaseVersion LIKE    '8.%'  THEN 'SQL Server 2000 '
     WHEN @BaseVersion LIKE    '9.%'  THEN 'SQL Server 2005 '
     WHEN @BaseVersion LIKE   '10.0%' THEN 'SQL Server 2008 '
     WHEN @BaseVersion LIKE   '10.5%' THEN 'SQL Server 2008 R2 '
     WHEN @BaseVersion LIKE   '11.%'  THEN 'SQL Server 2012 '
     WHEN @BaseVersion LIKE   '12.%'  THEN 'SQL Server 2014 '
     WHEN @BaseVersion LIKE   '13.%'  THEN 'SQL Server 2016 '
     WHEN @BaseVersion LIKE   '14.%'  THEN 'SQL Server 2017 '
     WHEN @BaseVersion LIKE   '15.%'  THEN 'SQL Server 2019 '
     WHEN @BaseVersion LIKE   '16.%'  THEN 'SQL Server 2022 '
     WHEN @BaseVersion LIKE   '17.%'  THEN 'SQL Server 2025 ' ELSE 'SQL Server ' END
+ CONVERT(varchar(1000), SERVERPROPERTY('Edition')) + ' has been running since '
+ CONVERT(varchar(1000), (SELECT I.sqlserver_start_time FROM sys.dm_os_sys_info AS I), 120)

PRINT @Information

IF OBJECT_ID('tempdb..#Action'     , 'U ') IS NOT NULL DROP TABLE #Action

IF OBJECT_ID('tempdb..#Action_Wait', 'U ') IS NOT NULL DROP TABLE #Action_Wait

   SELECT P.is_user_process
        , P.session_id
        , R.request_id
        , CONVERT(varchar(40), P.login_time             , 120) AS login_time
        , P.login_name
        , P.host_name
        , P.program_name
        , CONVERT(varchar(40), P.last_request_start_time, 120) AS batch_time
--      , DB_NAME(P.database_id) AS DB_session
        , DB_NAME(R.database_id) AS DB_request
        , R.status                                             AS batch_state
        , CASE WHEN R.wait_resource LIKE '[1-9]%:[1-9]%:[1-9]%' THEN DB_NAME(CONVERT(smallint, SUBSTRING(R.wait_resource, 1, CHARINDEX(':', R.wait_resource, 1) - 1)))
               WHEN LEFT(R.wait_resource, 4) =           'KEY:' THEN DB_NAME(CONVERT(smallint, SUBSTRING(R.wait_resource, 6, CHARINDEX(':', R.wait_resource, 6) - 6)))
               WHEN LEFT(R.wait_resource, 5) =          'PAGE:' THEN DB_NAME(CONVERT(smallint, SUBSTRING(R.wait_resource, 7, CHARINDEX(':', R.wait_resource, 7) - 7)))
               WHEN LEFT(R.wait_resource, 7) =        'OBJECT:' THEN DB_NAME(CONVERT(smallint, SUBSTRING(R.wait_resource, 9, CHARINDEX(':', R.wait_resource, 9) - 9))) ELSE SPACE(0) END AS wait_database
        , R.wait_resource
        , R.wait_type
        , R.wait_time / 1000.0 AS wait_seconds
        , CONVERT(varchar(0010), R.total_elapsed_time / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, R.total_elapsed_time % 86400000, 0), 114) AS run_time
        , CONVERT(varchar(0010), R.cpu_time           / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, R.cpu_time           % 86400000, 0), 114) AS cpu_time
        , R.dop AS DOP
        , S.CPUs
        , S.tasks
        , R.reads
        , R.writes
        , R.row_count
        , CONVERT(decimal(19,05), R.granted_query_memory / 128.0 / 1024.0) AS GBs_RAM
        , R.blocking_session_id AS blocking_id
        , Z.transaction_state   AS trans_state
        ,            DB_NAME(            T.dbid) COLLATE database_default AS DBName
        , OBJECT_SCHEMA_NAME(T.objectid, T.dbid) COLLATE database_default AS SchemaName
        ,        OBJECT_NAME(T.objectid, T.dbid) COLLATE database_default AS ObjectName
        ,                               SPACE(2) COLLATE database_default AS ObjectType
        , R.command
        , CASE WHEN R.statement_start_offset < 0 THEN     0                                                                            ELSE (R.statement_start_offset / 2)     END + 1 AS I
        , CASE WHEN R.statement_end_offset   < 0 THEN LEN(T.text) WHEN R.statement_end_offset > (LEN(T.text) * 2) - 4 THEN LEN(T.text) ELSE (R.statement_end_offset   / 2) + 1 END + 1 AS O
        , T.text COLLATE database_default AS text
        , V.query_plan
     INTO #Action
     FROM sys.dm_exec_sessions AS P
LEFT JOIN sys.dm_exec_requests AS R
       ON P.session_id
        = R.session_id
LEFT JOIN
  (SELECT Q.session_id
        , Q.request_id
        , SUM(CASE WHEN Q.task_state = 'RUNNING' THEN 1 ELSE 0 END) AS CPUs
        , SUM(                                        1           ) AS tasks
     FROM sys.dm_os_tasks AS Q
    WHERE Q.session_id IS NOT NULL
 GROUP BY Q.session_id
        , Q.request_id)   AS S
       ON R.session_id
        = S.session_id
      AND R.request_id
        = S.request_id
LEFT JOIN sys.dm_tran_session_transactions AS W
       ON R.session_id
        = W.session_id
      AND R.transaction_id
        = W.transaction_id
LEFT JOIN sys.dm_tran_active_transactions AS Z
       ON W.transaction_id
        = Z.transaction_id
    OUTER APPLY sys.dm_exec_sql_text(R.sql_handle) AS T OUTER APPLY sys.dm_exec_query_plan(R.plan_handle) AS V
    WHERE P.session_id != @@SPID

   SELECT W.session_id
        ,        W.wait_type
        ,        W.wait_time_ms
        , W.signal_wait_time_ms
        , W.waiting_tasks_count
     INTO #Action_Wait
     FROM sys.dm_exec_session_wait_stats AS W
    WHERE W.session_id != @@SPID

-- result set 1

   SELECT E.session_id
--      , E.request_id
        , E.login_time
        , E.batch_time
--      , E.DB_session
        , E.DB_request
--      , E.batch_state
        , E.run_time
        , E.cpu_time
        , E.DOP
        , E.CPUs
--      , E.tasks
--      , E.reads
--      , E.writes
--      , E.row_count
        , E.GBs_RAM
        , E.blocking_id
        , E.trans_state
--      , E.wait_type
--      , E.wait_seconds
--      , E.wait_resource
--      , E.wait_database
--      , Z.wait_signal_all_types
--      , Z.wait_amount_all_types
--      , Z.ratio_signal
--      , Z.wait_count
        , E.login_name
        , E.host_name
        , E.program_name
--      , E.DBName
--      , E.SchemaName
--      , E.ObjectName
--      , E.ObjectType
--      , E.command
        , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
        ,           E.text                  AS SQL_code_all
--      , E.query_plan
     FROM #Action AS E
     JOIN
  (SELECT W.session_id
        , CONVERT(varchar(0010) , SUM(W.signal_wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(W.signal_wait_time_ms) % 86400000, 0), 114) AS wait_signal_all_types
        , CONVERT(varchar(0010) , SUM(       W.wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(       W.wait_time_ms) % 86400000, 0), 114) AS wait_amount_all_types
        , CONVERT(decimal(05,02), SUM(W.signal_wait_time_ms) * 100.0 / CASE WHEN SUM(W.wait_time_ms) = 0 THEN 1 ELSE SUM(W.wait_time_ms) END)                       AS ratio_signal
        , SUM(W.waiting_tasks_count) AS wait_count
     FROM #Action_Wait  AS W
 GROUP BY W.session_id) AS Z
       ON E.session_id
        = Z.session_id
    WHERE E.is_user_process != 0
 ORDER BY E.session_id
        , E.request_id

-- result set 2

   SELECT E.session_id
--      , E.request_id
        , E.login_time
        , E.batch_time
--      , E.DB_session
        , E.DB_request
--      , E.batch_state
        , E.run_time
        , E.cpu_time
        , E.DOP
        , E.CPUs
--      , E.tasks
--      , E.reads
--      , E.writes
--      , E.row_count
--      , E.GBs_RAM
--      , E.blocking_id
--      , E.trans_state
        , E.wait_type
        , E.wait_seconds
        , E.wait_resource
        , E.wait_database
--      , Z.wait_signal_all_types
--      , Z.wait_amount_all_types
--      , Z.ratio_signal
--      , Z.wait_count
--      , E.login_name
--      , E.host_name
--      , E.program_name
--      , E.DBName
--      , E.SchemaName
--      , E.ObjectName
--      , E.ObjectType
--      , E.command
--      , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
--      ,           E.text                  AS SQL_code_all
--      , E.query_plan
     FROM #Action AS E
     JOIN
  (SELECT W.session_id
        , CONVERT(varchar(0010) , SUM(W.signal_wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(W.signal_wait_time_ms) % 86400000, 0), 114) AS wait_signal_all_types
        , CONVERT(varchar(0010) , SUM(       W.wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(       W.wait_time_ms) % 86400000, 0), 114) AS wait_amount_all_types
        , CONVERT(decimal(05,02), SUM(W.signal_wait_time_ms) * 100.0 / CASE WHEN SUM(W.wait_time_ms) = 0 THEN 1 ELSE SUM(W.wait_time_ms) END)                       AS ratio_signal
        , SUM(W.waiting_tasks_count) AS wait_count
     FROM #Action_Wait  AS W
 GROUP BY W.session_id) AS Z
       ON E.session_id
        = Z.session_id
    WHERE E.is_user_process != 0
      AND E.wait_type IS NOT NULL
 ORDER BY E.session_id
        , E.request_id

/*

-- wait summary

   SELECT A.wait_type
        , COUNT(*) AS wait_count
        , CONVERT(decimal(19,03), SUM(A.wait_seconds)) AS wait_seconds
        , CONVERT(decimal(05,02), 
          CONVERT(decimal(19,03), SUM(A.wait_seconds)) * 100.0 / CASE WHEN U.wait_seconds > 0.0 THEN U.wait_seconds ELSE 1.0 END) AS [Percent]
     FROM
  (SELECT E.wait_type
        , E.wait_seconds
     FROM #Action AS E
    WHERE E.is_user_process != 0
      AND E.wait_type IS NOT NULL) AS A,
  (SELECT CONVERT(decimal(19,03), SUM(E.wait_seconds)) AS wait_seconds
     FROM #Action AS E
    WHERE E.is_user_process != 0
      AND E.wait_type IS NOT NULL) AS U
 GROUP BY A.wait_type
        , U.wait_seconds
 ORDER BY [Percent] DESC
        , A.wait_type

*/

/*

-- wait summary by database

   SELECT A.wait_type
        , COUNT(*) AS wait_count
        , CONVERT(decimal(19,03), SUM(A.wait_seconds)) AS wait_seconds
        , A.wait_database
     FROM
  (SELECT E.wait_type
        , E.wait_seconds
        , E.wait_database
     FROM #Action AS E
    WHERE E.is_user_process != 0
      AND E.wait_type IS NOT NULL) AS A
 GROUP BY A.wait_type
        , A.wait_database
 ORDER BY A.wait_type
        , A.wait_database

*/

-- result set 3

   SELECT E.session_id
--      , E.request_id
        , E.login_time
        , E.batch_time
--      , E.DB_session
        , E.DB_request
--      , E.batch_state
        , E.run_time
        , E.cpu_time
        , E.DOP
        , E.CPUs
--      , E.tasks
--      , E.reads
--      , E.writes
--      , E.row_count
--      , E.GBs_RAM
--      , E.blocking_id
--      , E.trans_state
--      , E.wait_type
--      , E.wait_seconds
--      , E.wait_resource
--      , E.wait_database
        , Z.wait_signal_all_types
        , Z.wait_amount_all_types
        , Z.ratio_signal
        , Z.wait_count
--      , E.login_name
--      , E.host_name
--      , E.program_name
--      , E.DBName
--      , E.SchemaName
--      , E.ObjectName
--      , E.ObjectType
--      , E.command
--      , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
--      ,           E.text                  AS SQL_code_all
--      , E.query_plan
     FROM #Action AS E
     JOIN
  (SELECT W.session_id
        , CONVERT(varchar(0010) , SUM(W.signal_wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(W.signal_wait_time_ms) % 86400000, 0), 114) AS wait_signal_all_types
        , CONVERT(varchar(0010) , SUM(       W.wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(       W.wait_time_ms) % 86400000, 0), 114) AS wait_amount_all_types
        , CONVERT(decimal(05,02), SUM(W.signal_wait_time_ms) * 100.0 / CASE WHEN SUM(W.wait_time_ms) = 0 THEN 1 ELSE SUM(W.wait_time_ms) END)                       AS ratio_signal
        , SUM(W.waiting_tasks_count) AS wait_count
     FROM #Action_Wait  AS W
 GROUP BY W.session_id) AS Z
       ON E.session_id
        = Z.session_id
    WHERE E.is_user_process != 0
 ORDER BY E.session_id
        , E.request_id

-- result set 4

   SELECT E.session_id
--      , E.request_id
        , E.login_time
        , E.batch_time
--      , E.DB_session
        , E.DB_request
--      , E.batch_state
        , E.run_time
        , E.cpu_time
        , E.DOP
        , E.CPUs
--      , E.tasks
--      , E.reads
--      , E.writes
--      , E.row_count
--      , E.GBs_RAM
--      , E.blocking_id
--      , E.trans_state
--      , E.wait_type
--      , E.wait_seconds
--      , E.wait_resource
--      , E.wait_database
        , CONVERT(varchar(0010) ,     W.signal_wait_time_ms  / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms,     W.signal_wait_time_ms  % 86400000, 0), 114) AS wait_signal_per_type
        , CONVERT(varchar(0010) ,            W.wait_time_ms  / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms,            W.wait_time_ms  % 86400000, 0), 114) AS wait_amount_per_type
        , CONVERT(decimal(05,02),     W.signal_wait_time_ms  * 100.0 / CASE WHEN     W.wait_time_ms  = 0 THEN 1 ELSE     W.wait_time_ms  END)                       AS ratio_signal
        , W.waiting_tasks_count AS wait_count
        , W.wait_type           AS wait_type_name
--      , E.login_name
--      , E.host_name
--      , E.program_name
--      , E.DBName
--      , E.SchemaName
--      , E.ObjectName
--      , E.ObjectType
--      , E.command
--      , SUBSTRING(E.text, E.I, E.O - E.I) AS SQL_code
--      ,           E.text                  AS SQL_code_all
--      , E.query_plan
     FROM #Action AS E
     JOIN #Action_Wait  AS W
       ON E.session_id
        = W.session_id
    WHERE E.is_user_process != 0
 ORDER BY E.session_id
        , E.request_id
        , W.wait_type

-- result set 5

   SELECT A.wait_type AS wait_type_name
        , COUNT(*) AS [sessions]
        , SUM(A.waiting_tasks_count) AS wait_count
        , CONVERT(varchar(0010) , SUM(A.signal_wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(A.signal_wait_time_ms) % 86400000, 0), 114) AS wait_signal_per_type
        , CONVERT(varchar(0010) , SUM(       A.wait_time_ms) / 86400000) + ':' + CONVERT(varchar(0020), DATEADD(ms, SUM(       A.wait_time_ms) % 86400000, 0), 114) AS wait_amount_per_type
        , CONVERT(decimal(05,02), SUM(A.signal_wait_time_ms) * 100.0 / CASE WHEN SUM(A.wait_time_ms) = 0 THEN 1 ELSE SUM(A.wait_time_ms) END)                       AS ratio_signal
--      , CONVERT(decimal(19,03), SUM(A.wait_seconds)) AS wait_seconds
        , CONVERT(decimal(05,02), 
          CONVERT(decimal(19,03), SUM(A.wait_seconds)) * 100.0 / CASE WHEN U.wait_seconds > 0.0 THEN U.wait_seconds ELSE 1.0 END) AS [Percent]
     FROM
  (SELECT E.session_id
        , W.wait_type
        , W.signal_wait_time_ms
        , W.wait_time_ms
        , W.wait_time_ms / 1000.0 AS wait_seconds
        , W.waiting_tasks_count
     FROM #Action AS E
     JOIN #Action_Wait  AS W
       ON E.session_id
        = W.session_id
    WHERE E.is_user_process != 0) AS A,
  (SELECT CONVERT(decimal(19,03), SUM(W.wait_time_ms / 1000.0)) AS wait_seconds
     FROM #Action AS E
     JOIN #Action_Wait  AS W
       ON E.session_id
        = W.session_id
    WHERE E.is_user_process != 0) AS U
 GROUP BY A.wait_type
        , U.wait_seconds
 ORDER BY [Percent] DESC
        , A.wait_type

DROP TABLE #Action

DROP TABLE #Action_Wait

SET NOCOUNT OFF

